if(!dojo._hasResource["aipo.widget.WideUseMemberPicker"]){
    //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["aipo.widget.WideUseMemberPicker"] = true;
/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://www.aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// 汎用閲覧メンバー選択ダイアログ呼び出し元
dojo.provide("aipo.widget.WideUseMemberPicker");

dojo.require("aimluck.widget.Dropdown");
dojo.require("aipo.widget.WideUseMemberSelectList");

/**
 * ex)
 * selectId:[呼び出し元ポートレットの閲覧メンバー要素のID],
 * buttonAddId:"button_member_add",
 * buttonRemoveId:"button_member_remove",
 * memberFromId:"tmp_member_from",
 * memberToId:"tmp_member_to",
 * memberFromUrl:this.memberFromUrl,
 * memberFromOptionKey:"name",
 * memberFromOptionValue:"aliasName",
 * groupSelectId:"tmp_group",
 * groupSelectOptionKey:"groupId",
 * groupSelectOptionValue:"name",
 * memberGroupUrl:this.memberGroupUrl,
 * changeGroupUrl:this.changeGroupUrl
 */
/** 汎用閲覧メンバー選択ダイアログ呼び出し元（ボタン） */
dojo.declare("aipo.widget.WideUseMemberPicker", [aimluck.widget.Dropdown], {
    startButtonName:"",
    selectId:"",
    buttonAddId:"",
    buttonRemoveId:"",
    memberFromId:"",
    memberToId:"",
    memberFromUrl:"",
    memberFromOptionKey:"",
    memberFromOptionValue:"",
    groupSelectId:"",
    groupSelectOptionKey:"",
    groupSelectOptionValue:"",
    memberGroupUrl:"",
    changeGroupUrl:"",

    initGroupName: "",
    initParentGroupName: "",
    parentGroupSelectId: "",
    group1SelectPreOptionKey: "",
    group1SelectPreOptionValue: "",
    group2SelectPreOptionKey: "",
    group2SelectPreOptionValue: "",
    post1GroupUrl: "",
    changePost2GroupUrl: "",
    changePost1GroupUrl: "",

    callback: function(){},
    member_maximum_to:10,

    selectWidgetId:"",
    tmpPortretId: "cinit",
    templateString:"<span class=\"dijit dijitLeft dijitInline\"\n"
                 + "\tdojoAttachEvent=\"onmouseenter:_onMouse,\n"
                 + "\tonmouseleave:_onMouse,\n"
                 + "\tonmousedown:_onMouse,\n"
                 + "\tonclick:_onDropDownClick,\n"
                 + "\tonkeydown:_onDropDownKeydown,\n"
                 + "\tonblur:_onDropDownBlur,\n"
                 + "\tonkeypress:_onKey\"\n"
                 + ">\n"
                 + "\t<span class=\"\" type=\"${type}\"\n"
                 + "\t\tdojoAttachPoint=\"focusNode,titleNode\"\n"
                 + "\t>"
                 + "\t\t<input type=\"button\" class=\"button\" \tdojoAttachPoint=\"containerNode,popupStateNode\" id=\"${id}_label\" value=\"${startButtonName}\"/>\n"
                 + "\t</span>\n"
                 + "</span>\n",

    /**
     * 初期表示処理
     */
    postCreate: function(){
      var widgetParams = {
          widgetId:this.selectWidgetId,
          selectId:this.selectId,
          buttonAddId:this.buttonAddId,
          buttonRemoveId:this.buttonRemoveId,
          memberFromId:this.memberFromId,
          memberToId:this.memberToId,
          memberFromUrl:this.memberFromUrl,
          memberFromOptionKey:this.memberFromOptionKey,
          memberFromOptionValue:this.memberFromOptionValue,
          groupSelectId:this.groupSelectId,
          groupSelectOptionKey:this.groupSelectOptionKey,
          groupSelectOptionValue:this.groupSelectOptionValue,
          memberGroupUrl:this.memberGroupUrl,
          changeGroupUrl:this.changeGroupUrl,
          tmpPortretId:this.tmpPortretId,
          initGroupName:this.initGroupName,
          initParentGroupName:this.initParentGroupName,
          parentGroupSelectId:this.parentGroupSelectId,
          group1SelectPreOptionKey:this.group1SelectPreOptionKey,
          group1SelectPreOptionValue:this.group1SelectPreOptionValue,
          group2SelectPreOptionKey:this.group2SelectPreOptionKey,
          group2SelectPreOptionValue:this.group2SelectPreOptionValue,
          post1GroupUrl:this.post1GroupUrl,
          changePost1GroupUrl:this.changePost1GroupUrl,
          changePost2GroupUrl:this.changePost2GroupUrl,
          callback: this.callback,
          member_maximum_to: this.member_maximum_to
      };

      var selectWidget = dijit.byId(this.selectWidgetId);
      if(selectWidget){
        this.dropDown = selectWidget;
        select = dojo.byId(selectWidget.memberToId);
        this.removeAllOptions(select);
      }else{
        this.dropDown = new aipo.widget.WideUseMemberSelectList(widgetParams, this.selectWidgetId);
      }
      // 呼び出し元ポートレットの閲覧メンバーをウィジットへ格納
      var targetList = dojo.byId(this.selectId);
      var s_o = targetList.options;
      for(var i = 0 ; i < s_o.length; i ++ ) {
          this.dropDown.addOptionToMemberTo(s_o[i].value, s_o[i].text, true);
      }
      this.inherited(arguments);
    },

    /**
     * 全削除処理
     *
     * @param select selectタグオブジェクト
     */
    removeAllOptions:function(select){
      var i;
      if (document.all) {
        var t_o = select.options;
        for(i = 0 ;i < t_o.length; i ++ ) {
          t_o.remove(i);
          i -= 1;
        }
      } else {
        var t_o = select.options;
        for(i = 0 ;i < t_o.length; i ++ ) {
          select.removeChild(t_o[i]);
          i -= 1;
        }
      }
    },

    /**
     * ドロップダウン処理
     */
    _openDropDown: function(){
        var dropDown = this.dropDown;
        var oldWidth=dropDown.domNode.style.width;
        var self = this;

        dijit.popup.open({
            parent: this,
            popup: dropDown,
            around: this.domNode,
            orient: this.isLeftToRight() ? {'BL':'TL', 'BR':'TR', 'TL':'BL', 'TR':'BR'}
                : {'BR':'TR', 'BL':'TL', 'TR':'BR', 'TL':'BL'},
            onExecute: function(){
                self._closeDropDown(true);
            },
            onCancel: function(){
                self._closeDropDown(true);
            },
            /** ウインドウ外クリックによる閉鎖処理 */
            onClose: function(){
                dropDown.domNode.style.width = oldWidth;
                self.popupStateNode.removeAttribute("popupActive");
                this._opened = false;
                self.callback.call(self.callback);
            }
        });
        if(this.domNode.offsetWidth > dropDown.domNode.offsetWidth){
            var adjustNode = null;
            if(!this.isLeftToRight()){
                adjustNode = dropDown.domNode.parentNode;
                var oldRight = adjustNode.offsetLeft + adjustNode.offsetWidth;
            }
            // make menu at least as wide as the button
            dojo.marginBox(dropDown.domNode, {w: this.domNode.offsetWidth});
            if(adjustNode){
                adjustNode.style.left = oldRight - this.domNode.offsetWidth + "px";
            }
        }
        this.popupStateNode.setAttribute("popupActive", "true");
        this._opened=true;
        if(dropDown.focus){
            dropDown.focus();
        }

        //For google chrome and Firefox 3.6 or higher
        var userAgent = window.navigator.userAgent.toLowerCase();
        if (userAgent.indexOf("chrome") > -1 || (dojo.isFF && (dojo.isFF >= 3.6))) {
            var pNode = this.dropDown.domNode.parentNode;
            var top = pNode.style.top.replace("px","");
            top_new = parseInt(top) + window.scrollY;
            pNode.style.top = top_new + "px";
        }
        // set this.checked and call setStateClass(), to affect button look while drop down is shown
    }
});

}
