if(!dojo._hasResource["aipo.widget.MonthlyScheduleDropdownDatepicker"]){ //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["aipo.widget.MonthlyScheduleDropdownDatepicker"] = true;
/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.widget.MonthlyScheduleDropdownDatepicker");

dojo.require("aimluck.widget.Dropdown");

dojo.require("aipo.widget.EmbedDateCalendar");
dojo.require("dojo.date.locale");

/**
 * ex)
 * selectId:"member_to",
 * inputId:"member_to_input",
 */
dojo.declare("aipo.widget.MonthlyScheduleDropdownDatepicker", [aimluck.widget.Dropdown], {
    dateId: "",
    dateValue: "",
    initValue: "",
    displayCheck: "",
    iconURL: "",
    iconAlt: "",
    callback: function(){},
    listWidgetId:"datewidget",
    templateString:"<div class=\"dijit dijitLeft dijitInline\"><div dojoAttachEvent=\"onmouseenter:_onMouse,onmouseleave:_onMouse,onmousedown:_onMouse,onclick:_onDropDownClick,onkeydown:_onDropDownKeydown,onblur:_onDropDownBlur,onkeypress:_onKey\"\n\t style=\"float:left;\"><div class='dijitRight'>\n\t<span class=\"\" type=\"${type}\"\n\t\tdojoAttachPoint=\"focusNode,titleNode\" waiRole=\"button\" waiState=\"haspopup-true,labelledby-${id}_label\"\n\t\t><span class=\"\" \tdojoAttachPoint=\"containerNode,popupStateNode\"\n\t\tid=\"${id}_label\"><img src=\"${iconURL}\" alt=\"${iconAlt}\" style=\"cursor:pointer;cursor:hand;padding-right:2px\" align=\"top\" />\n\t</span></div></div><div class=\"alignleft\"><span name=\"${dateId}_view\" id=\"${dateId}_view\" dojoAttachPoint=\"inputNode\" style=\"vertical-align:middle;background:#ffffff ;border:0px;\" autocomplete=\"off\" readonly=\"readonly\"></span><span style=\"display:${displayCheck}\"><input name=\"${dateId}_check\" type=\"checkbox\" value=\"TRUE\" id=\"${dateId}_flag\" dojoAttachEvent=\"onclick:onCheckBlank\" /><label for=\"${dateId}_flag\">\u0020\u6307\u5b9a\u3057\u306a\u3044</label></span><input type=\"hidden\" id=\"${dateId}\" name=\"${dateId}\" value=\"${dateValue}\" dojoAttachPoint=\"valueNode\" /><input type=\"hidden\" id=\"${dateId}_year\" name=\"${dateId}_year\" value=\"\" dojoAttachPoint=\"valueYearNode\" /><input type=\"hidden\" id=\"${dateId}_month\" name=\"${dateId}_month\" value=\"\" dojoAttachPoint=\"valueMonthNode\" /><input type=\"hidden\" id=\"${dateId}_day\" name=\"${dateId}_day\" value=\"\" dojoAttachPoint=\"valueDayNode\" /></div></div>\n",
    postCreate: function(){
        this.inherited(arguments);
        var params = {
          widgetId:this.listWidgetId,
          dateId:this.dateId,
          callback:this.callback
        };
        this.dropDown = new aipo.widget.EmbedDateCalendar(params, this.listWidgetId);
        this.dropDown.onChange = function(/*date*/date){
          var tyear = date.getFullYear();
          var tmonth = 1+date.getMonth();
          var tdate = date.getDate();
          var dayNames = dojo.date.locale.getNames('days', this.dayWidth, 'standAlone', this.lang);
          var tday = dayNames[date.getDay()];
          var viewvalue = dojo.byId(this.dateId+'_view');
          viewvalue.innerHTML = tyear+"\u5e74"+tmonth+"\u6708&nbsp;";
          var hiddendate = dojo.byId(this.dateId);
          hiddendate.value = tyear+"/"+tmonth+"/"+tdate;
          var hiddendate_year = dojo.byId(this.dateId+'_year');
          hiddendate_year.value = tyear;
          var hiddendate_month = dojo.byId(this.dateId+'_month');
          hiddendate_month.value = tmonth;
          var hiddendate_day = dojo.byId(this.dateId+'_day');
          hiddendate_day.value = tdate;
          dojo.byId(this.dateId+'_flag').checked = false;
        };
        this.dropDown.postSelectValue = function(/*date*/date){
          var portletId = dojo.byId("portletId").value;
          var url = dojo.byId("screenUrl").value + "&view_month=" + date.getFullYear() + "-" +  (1+date.getMonth());
          //alert(url + " " + this.portletId)
          this.callback.call(null, url, portletId, null)
        };
        // add start 要件No.15 スケジュール画面（月単位）カレンダー追加
        this.dropDown.postPopulateGrid = function(){
          // 選択日付の反転および当日の太字を無効にする。当日の下線はそのまま。
          dojo.query(".dijitCalendarDateTemplate", this.domNode).forEach(function(template, i) {
            if (dojo.hasClass(template, "dijitCalendarCurrentDate")) {
              dojo.removeClass(template, "dijitCalendarCurrentDate");
              dojo.addClass(template, "dijitCalendarTodayStyle");
            }
            if (dojo.hasClass(template, "dijitCalendarSelectedDate")) {
              dojo.removeClass(template, "dijitCalendarSelectedDate");
            }
          }, this);
        };
        // add end

        if(this.initValue != ""){
            var tmpdate = this.initValue.split("/");
            if(tmpdate.length == 3){
                var tyear = tmpdate[0];
                var tmonth = tmpdate[1]-1;
                var tday = tmpdate[2];

                var datevalue = dojo.byId(this.dateId);
                datevalue.value = this.initValue;

                this.dropDown.clearDate();
                this.dropDown.setValue(new Date(tyear, tmonth, tday));
            }
        }else{
          this.dropDown.disabledCalendar(true);
        }
    },
    onCheckBlank: function(/*evt*/ e){
        this.dropDown.disabledCalendar(dojo.byId(this.dateId+'_flag').checked);
    }
});

}
