if(!dojo._hasResource["aipo.schedule.dnd.OneDayScheduleAreaMove"]){
dojo._hasResource["aipo.schedule.dnd.OneDayScheduleAreaMove"] = true;
/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://www.aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// 1日スケジュール通常予定領域クリック・ドラッグ＆ドロップ
dojo.provide("aipo.schedule.dnd.OneDayScheduleAreaMove");

dojo.require("aimluck.dnd.Draggable");
dojo.require("aipo.common");
dojo.require("aipo.schedule");

/** 
 * 1日スケジュール用通常予定領域クリック・ドラッグ＆ドロップ実体
 */
dojo.declare("aipo.schedule.dnd.OneDayScheduleAreaDragMoveObject", [aimluck.dnd.DragMoveObject], {
    // 移動元グリッド座標
    positionFrom: 0,
    // 移動先グリッド座標
    positionTo: 0,
    // ドラッグ中フラグ
    _isDragging: false,
    /** マウス押下 */
    onMouseDown: function(e){
        // ドラッグ中フラグを無効化
        this._isDragging = false;
        // 親メソッドを実行
        aimluck.dnd.DragMoveObject.prototype.onMouseDown.apply(this, arguments);
        //this.inherited(arguments);
    },
    /** マウスドラッグ（初期処理） */
    onFirstMove: function(e){
        // ドラッグ中フラグを立てる
        this._isDragging = true;
        // ドラッグ開始時点のマウスY座標
        this.startY = this.dragSource._lastY;
        // ドラッグ対象のY座標
        this.startAbsoluteY = dojo._abs(dojo.byId(this.node), true).y;
        // ドラッグ対象のX座標
        this.startX =  dojo.getComputedStyle(this.node).left;

        //Google Chrome及びSafari、Firefox/3.6ではdojo._absの挙動が異なるので、AbsoluteYを修正する
        var userAgent = window.navigator.userAgent.toLowerCase();
        if (userAgent.indexOf("chrome") > -1 || (dojo.isFF && (dojo.isFF >= 3.6))) {
            // ページスクロール分を修正
            this.startAbsoluteY += window.scrollY;
        } else if(userAgent.indexOf("safari") > -1) {
            // DIVタグスクロール分を修正
            this.startAbsoluteY -= dojo.byId('weeklyScrollPane_'+this.portletId).scrollTop;
        }
        // ドラッグ開始時点のスクロール領域の先頭座標
        this.lastScroll = dojo.byId('weeklyScrollPane_'+this.portletId).scrollTop;
        // 親メソッドを実行
        aimluck.dnd.DragMoveObject.prototype.onFirstMove.apply(this, arguments);
        //this.inherited(arguments);
    },
    /** マウスドラッグ */
    onMouseMove: function(e){
        // 親メソッドを実行
        aimluck.dnd.DragMoveObject.prototype.onMouseMove.apply(this, arguments);
        //this.inherited(arguments);
        // スクロール領域の移動範囲
        var distance_scr = dojo.byId('weeklyScrollPane_'+this.portletId).scrollTop - this.lastScroll;

        // ドラッグ対象のY方向移動範囲（単位：グリッド枠）
        var quotient = Math.floor((this.startY-this.startAbsoluteY) / ptConfig[this.portletId].rowHeight);
        // ドラッグ対象のスクロール移動範囲を考慮したY方向移動範囲（単位：グリッド枠）
        var currentQuotient = Math.floor((this.startY+this.leftTop.t-this.startAbsoluteY+distance_scr) / ptConfig[this.portletId].rowHeight);
        // Y方向移動範囲を算出
        var nextTop = 0;
        var nextHeight = 0;
        if( currentQuotient < quotient) {
            nextTop = currentQuotient * ptConfig[this.portletId].rowHeight  +1;
            nextHeight = (quotient - currentQuotient+1) * ptConfig[this.portletId].rowHeight;
            this.positionFrom = currentQuotient;
            this.positionTo= quotient+1;
        } else {
            nextTop = quotient * ptConfig[this.portletId].rowHeight  +1;
            nextHeight = (currentQuotient - quotient+1) * ptConfig[this.portletId].rowHeight;
            this.positionTo = currentQuotient+1;
            this.positionFrom = quotient;
        }

        // Y方向移動範囲+高さが表示範囲を超えた場合、高さを表示範囲の最後までに合わせる
        if (nextTop + nextHeight > 864 ) {
             nextHeight = 864 - nextTop - ptConfig[this.portletId].rowHeight;
             this.positionTo = 47;
        }

        // ドラッグ対象のY座標を更新
        this.leftTop.t = nextTop;
        // ドラッグ対象のX座標を、ドラッグ開始時から固定化
        this.leftTop.l = this.startX;
        // ドラッグ対象の高さを更新
        this.leftTop.h = nextHeight;
        dojo.marginBox(this.node, this.leftTop);

        // 透過度設定
        dojo.style(this.node, "opacity", 0.8);
    },
    /** マウスドロップ */
    onMouseUp: function(e) {
        if(!this._isDragging){
            // ドラッグでなく、クリックされた
            this.onFirstMove(e);
            this.onMouseMove(e);
        }

        // 開始時間と終了時間を算出
        var hour = Math.floor(this.positionFrom/2);
        hour = (hour > 9) ? hour : "0" + hour;
        var minute = Math.floor(this.positionFrom%2)*30;
        var date = ptConfig[this.portletId].jsonData.formDateTime.substring(0, 10);
        var startTime = date + '-' + hour + '-' + minute;
        hour = Math.floor(this.positionTo/2);
        hour = (hour > 9) ? hour : "0" + hour;
        minute = Math.floor(this.positionTo%2)*30;
        var endTime = date + '-' + hour + '-' + minute;

        // 領域のスタイルを再設定する
        this.node.style.top = "0px";
        this.node.style.height = "864px";
        dojo.style(this.node, "opacity", 0.0 );

        if(this._isDragging == true){
          //右クリック、マウスホイールの場合は無視
          if( e.button != 2 && e.button != 4 ) {
            // 予定登録先を反映
            aipo.common.showWindow(ptConfig[this.portletId].formUrl + "&entityid=new&mode=form"  + "&form_start=" + startTime + '&form_end=' + endTime + '&userid=' + this.dragSource.targetUserId, this.portletId , aipo.schedule.onLoadScheduleDialog);
          }
        }
        // IEで追加ダイアログを閉じるとスクロールバーのｙ座標が強制的に0になってしまう現象の対策用
        aipo.schedule.tmpScroll = parseInt(dojo.byId('weeklyScrollPane_'+this.portletId)["scrollTop"], 10);

        // ドラッグ中フラグを無効化
       this._isDragging = false;
       // 親メソッドを実行
       aimluck.dnd.DragMoveObject.prototype.onMouseUp.apply(this, arguments);
       //this.inherited(arguments);
    }
});

/** 
 * １日スケジュール用通常予定領域ドラッグ＆ドロップコントローラー
 */
dojo.declare("aipo.schedule.dnd.OneDayScheduleAreaDraggable", [aimluck.dnd.Draggable], {
    // Moverクラス
    DragMoveObject: aipo.schedule.dnd.OneDayScheduleAreaDragMoveObject,
    // 操作対象ユーザーID
    targetUserId: null,
    // 操作可能フラグ
    canCreate: false,
    /** コンストラクタ */
    constructor: function(node, params){
        this.index = params.idx;
    },
    /** マウス押下 */
    onMouseDown: function(e){
        // 権限が無い場合は処理終了
        if(!this.canCreate){
            return;
        }
        // 親メソッドを実行
        aimluck.dnd.Draggable.prototype.onMouseDown.apply(this, arguments);
    }
});

}