/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule;

import java.util.List;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;

/**
 * スケジュールのキャンセル理由のフォームデータを管理するためのクラスです。 <br />
 */
public class ScheduleCancelReasonFormData extends ALAbstractFormData {

  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ScheduleCancelReasonFormData.class.getName());

  /** 削除範囲のフラグ */
  private ALNumberField del_range_flag;

  /** 削除対象ユーザーID */
  private ALStringField user_id;

  /** 削除対象日時 */
  private ALDateTimeField view_date;

  /**
   * 初期処理
   * 
   * @param action
   *            アクションクラス
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);

  }

  /**
   * 画面フィールド初期化
   * 
   */
  @Override
  public void initField() {
    // 削除対象日時
    view_date = new ALDateTimeField("yyyy-MM-dd");

    // 削除対象ユーザーID
    user_id = new ALStringField();
    user_id.setTrim(true);

    // 削除範囲のフラグ
    del_range_flag = new ALNumberField();

  }

  /**
   * バリデータ初期化
   * 
   */
  @Override
  protected void setValidator() {
  }

  /**
   * バリデーション
   * 
   * @param msgList
   *            エラーメッセージリスト
   * @return TRUE 成功 FALSE 失敗
   */
  @Override
  protected boolean validate(List<String> msgList) {
    return (msgList.size() == 0);
  }

  /**
   * 画面表示項目を設定します <BR>
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param msgList
   *            エラーメッセージリスト
   * @return true:処理成功 false:処理失敗
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  @Override
  protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    super.setFormData(rundata, context, msgList);
    return true;
  }

  /**
   * 
   * 
   */
  @Override
  protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
    try {

      // 削除対象日時
      if (rundata.getParameters().containsKey("view_date")) {
        view_date.setValue(rundata.getParameters().getString("view_date"));
      }
      // 削除対象ユーザーID
      if (rundata.getParameters().containsKey("userid")) {
        user_id.setValue(rundata.getParameters().getString("userid"));
      }
      // 削除範囲のフラグ
      if (rundata.getParameters().containsKey("del_range_flag")) {
        del_range_flag.setValue(rundata.getParameters().getString("del_range_flag"));
      }
      // エンティティID
      if (rundata.getParameters().containsKey("entityid")) {
        setEntityId(rundata.getParameters().getString("entityid"));
      }

    } catch (Exception ex) {
      logger.error("スケジュール作成（編集） キャンセル理由入力画面の入力値取得に失敗しました。", ex);
      msgList.add("スケジュール作成（編集） キャンセル理由入力画面の入力値取得に失敗しました。");
      return false;
    }
    return false;
  }

  /**
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   */
  @Override
  protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
    return false;
  }

  /**
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return
   */
  @Override
  protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
    return false;
  }

  /**
   * 削除処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param msgList
   *            エラーメッセージリスト
   * @return TRUE 成功 FALSE 失敗
   */
  @Override
  protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    return false;
  }

  /**
   * 削除対象日時を取得する
   * 
   * @return 削除対象日時
   */
  public ALDateTimeField getViewDate() {
    return view_date;
  }

  /**
   * 削除対象ユーザーIDを取得する
   * 
   * @return 削除対象ユーザーID
   */
  public ALStringField getUserId() {
    return user_id;
  }

  /**
   * 削除範囲フラグを取得する
   * 
   * @return 削除範囲フラグ
   */
  public ALNumberField getDelRangeFlag() {
    return del_range_flag;
  }

}
