/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.fileupload");

aipo.fileupload.getFolderName = function() {
    var obj = dojo.byId("folderName");
}

aipo.fileupload.onAddFileInfo = function(foldername, fileid, filename) {
    var select = dojo.byId('attachments');
    var value = fileid;
    var text = filename;
    aimluck.io.addOption(select, value, text, false);

    dojo.byId('folderName').value =  foldername;
}

aipo.fileupload.openAttachment = function(url){
    var wx = 430;
    var wy = 175;
    var x = (screen.width  - wx) / 2;
    var y = (screen.height - wy) / 2;

    var select = dojo.byId('attachments');
    var select_len = select.options.length;
    if(select_len == 1 && select.options[0].value == ''){
        select_len = 0;
    }
    var folderName = dojo.byId('folderName').value;
    var attachment_subwin = window.open(url+'&nsize='+select_len+'&folderName='+folderName,"attachment_window","left="+x+",top="+y+",width="+wx+",height="+wy+",resizable=yes,status=yes");
    attachment_subwin.focus();
}
// add start 要件No.11 メール作成／詳細（ファイル添付）
/**
 * ファイル名短縮
 * @param realFileName ファイル名＋拡張子＋サイズ
 * @param maxFileName ファイル名＋拡張子の最大文字
 * @param maxExtension 拡張子の最大文字数
 * @return 短縮後のファイル名（最大文字数超過時のみ）
 */
aipo.fileupload.fileNameMake = function(realFileName, maxFileName, maxExtension) {

    // 短縮ファイル名
    var cutFileName = "";
    // ファイル名文字数
    var file_len = 0;

    // ファイルサイズ分割用
    var regFileSize = /(.+)(\s\(.+?\))/;
    // 拡張子分割用
    var regExtension = /(.+)(\.[^.]+$)/;

    var file_name = "";
    var file_name_only = "";
    var file_name_extension = "";
    var file_name_size = "";

    // ファイル名＋拡張子
    try {
        file_name = realFileName.match(regFileSize)[1];
    } catch(E) {
        // ファイルサイズが無い画面用
        file_name = realFileName;
    }
    // ファイルサイズ
    try {
        file_name_size = realFileName.match(regFileSize)[2];
    } catch(E) {
        // ファイルサイズが無い画面用
        file_name_size = "";
    }
    // ファイル名のみ
    try {
        file_name_only = file_name.match(regExtension)[1];
    } catch(E) {
        // 拡張子が無いまたは、拡張子のみのファイル
        file_name_only = file_name;
    }
    // 拡張子のみ
    try {
        file_name_extension = file_name.match(regExtension)[2];
    } catch(E) {
        // 拡張子が無いファイル
        file_name_extension = "";
    }

    if ( file_name.length > maxFileName ) {
        // ピリオドを除いた拡張子が最大文字数を超えていた場合
        if ( file_name_extension.length - 1 > maxExtension ) {
            file_name_extension = file_name_extension.substr(0,maxExtension + 1)
        }
        // ファイル名文字数確定
        file_len =  maxFileName - file_name_extension.length
        if ( file_len == 1 ) {
            if ( (file_name_only.length > 1) && (file_name_extension.length - 1 == maxExtension) ) {
                // // ファイル名も拡張子も、どちらも指定の長さを超過した場合
                cutFileName = file_name.substr(0,file_len) + "\u2026" + file_name_extension.substr(0,maxExtension) + file_name_size;
            } else {
                cutFileName = file_name.substr(0,file_len) + file_name_extension + file_name_size;
            }
        } else {
            cutFileName = file_name.substr(0,file_len - 1) + "\u2026" + file_name_extension + file_name_size;
        }

        return cutFileName;

    } else {
        return realFileName;
    }
}
// add end

