/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.account_user");

dojo.require("aipo.widget.GroupNormalSelectList");

aipo.account_user.onLoadUserDialog = function(portlet_id){

/*
    var fpicker = dijit.byId("groupnormalselect");
    if(fpicker){
        var select = dojo.byId('init_grouplist');
        var i;
        var s_o = select.options;
        if (s_o.length == 1 && s_o[0].value == "") return;
        for(i = 0 ; i < s_o.length; i ++ ) {
            fpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
        }
    }
*/  
//add by motegi start
    var rpicker = dijit.byId("rolenormalselect");
    if(rpicker){
        var select = dojo.byId('init_rolelist');
        var i;
        var s_o = select.options;
        if (s_o.length == 1 && s_o[0].value == "") return;
        for(i = 0 ; i < s_o.length; i ++ ) {
            rpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
        }
    }
    
    var spicker = dijit.byId("groupsendnormalselect");
    if(spicker){
        var select = dojo.byId('init_groupsendlist');
        var i;
        var s_o = select.options;
        if (s_o.length == 1 && s_o[0].value == "") return;
        for(i = 0 ; i < s_o.length; i ++ ) {
            spicker.addOptionSync(s_o[i].value,s_o[i].text,true);
        }
    }
//add end

    var username = dojo.byId("username");
    if(username && username.type == 'text'){
      username.focus();
    }
}

aipo.account_user.formSwitchPostInput = function(button) {
    if(button.form.is_new_post.value == 'TRUE' || button.form.is_new_post.value == 'true') {
        button.value = '新しく入力する';
        aipo.account_user.formPostInputOff(button.form);
    } else {
        button.value = '一覧から選択する';
        aipo.account_user.formPostInputOn(button.form);
    }
}

aipo.account_user.formPostInputOn = function(form) {
    dojo.byId('postSelectField').style.display = "none";
    dojo.byId('postInputField').style.display = "";

    form.is_new_post.value = 'TRUE';
}

aipo.account_user.formPostInputOff = function(form) {
    dojo.byId('postInputField').style.display = "none";
    dojo.byId('postSelectField').style.display = "";

    form.is_new_post.value = 'FALSE';
}


aipo.account_user.formSwitchPositionInput = function(button) {
    if(button.form.is_new_position.value == 'TRUE' || button.form.is_new_position.value == 'true') {
        button.value = '新しく入力する';
        aipo.account_user.formPositionInputOff(button.form);
    } else {
        button.value = '一覧から選択する';
        aipo.account_user.formPositionInputOn(button.form);
    }
}

aipo.account_user.formPositionInputOn = function(form) {
    dojo.byId('positionSelectField').style.display = "none";
    dojo.byId('positionInputField').style.display = "";

    form.is_new_position.value = 'TRUE';
}

aipo.account_user.formPositionInputOff = function(form) {
    dojo.byId('positionInputField').style.display = "none";
    dojo.byId('positionSelectField').style.display = "";

    form.is_new_position.value = 'FALSE';
}

aipo.account_user.formAdminToggle = function(chkbox) {
    dojo.byId('is_admin').value = chkbox.checked ? 'true' : 'false';
}



aipo.account_user.onReceiveMessage = function(msg){
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        //change start
        //aipo.portletReload('account_user');
        for(var index in ptConfig) {
          if(ptConfig[index].group == 'account_user') {
            var url = ptConfig[index].reloadUrl;
            if( dojo.byId('SearchModeFlag') ) {
              url = url + "&mode=ajaxsearch&reload=1";
              ptConfig[index].reloadUrl = url;
            }
            //aipo.viewPage(url, index);
            aipo.portletReload('account_user');
          }
        }
        //change end
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
}

aipo.account_user.onListReceiveMessage = function(msg){
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        //change start
        //aipo.portletReload('account_user');
        for(var index in ptConfig) {
          if(ptConfig[index].group == 'account_user') {
            var url = ptConfig[index].reloadUrl;
            if( dojo.byId('SearchModeFlag') ) {
              url = url + "&mode=ajaxsearch&reload=1";
              ptConfig[index].reloadUrl = url;
            }
            //aipo.viewPage(url, index);
            aipo.portletReload('account_user');
          }
        }
        //change end
    }
    if (dojo.byId('listMessageDiv')) {
        dojo.byId('listMessageDiv').innerHTML = msg;
    }
}

aipo.account_user.submit2 = function(form) {
  var s_o = form.member_so.options;
  var tmp = '';

  for(i = 0 ; i < s_o.length; i++ ) {
    s_o[i].selected = false;
  }

  if(s_o.length > 0) {
    for(i = 0 ; i < s_o.length-1; i++ ) {
      tmp = tmp + s_o[i].value + ',';
    }
    tmp = tmp + s_o[s_o.length-1].value;
  }
  form.positions.value = tmp;
}

//add by motegi start 部署階層化対応
/**
 * 部署・役職レコード追加処理
 *
 */
aipo.account_user.appendRow = function(){

  var post1s = dojo.byId('post1s');
  var post2s = dojo.byId('post2s');
  var positions = dojo.byId('positions');
  if( post1s.options[post1s.selectedIndex].value == "" ) {
    return;
  }
  if( post2s.options[post2s.selectedIndex].value == "" ) {
    return;
  }

  var tbase = dojo.byId('base_member').tBodies[0];
  var tbod = dojo.byId('member_edit_table').tBodies[0];

  var rcopy = tbase.rows[0].cloneNode(true);
  tbod.insertBefore(rcopy, null);
  
  var new_row = tbod.rows[tbod.rows.length-1];
  
  new_row.cells[0].innerHTML = post1s.options[post1s.selectedIndex].innerHTML;
  new_row.cells[1].innerHTML = post2s.options[post2s.selectedIndex].innerHTML;
  new_row.cells[2].innerHTML = positions.options[positions.selectedIndex].innerHTML;
  
  for (var k = 0, obj; obj = new_row.cells[new_row.cells.length-1].childNodes[k]; k++){
    var name = obj.name;
    if (name) {       
      if (name.indexOf('post2_id[]') == 0) {
        obj.value = post2s.options[post2s.selectedIndex].value;
      }
      if (name.indexOf('position_id[]') == 0) {
        obj.value = positions.options[positions.selectedIndex].value;
      }
    }
  }
}

/**
 * 部署・役職レコード削除処理
 *
 */
if (window.addEventListener) {
  window.addEventListener('click',function(e){
    window.event = e;
    window.event.srcElement = e.target;
  },true);
} 

/**
 * 部署・役職レコード削除処理
 *
 */
aipo.account_user.deleteRow = function(){
  var bt = window.event.srcElement;
  var tr = bt.parentNode.parentNode;
  var tbod = tr.parentNode;
  tbod.deleteRow(tr.sectionRowIndex);
}

/**
 * 部署1プルダウン選択時処理
 *
 * @param link 検索URL
 * @param parent_post_id 部署1グループ名
 *　@param sel selectタグオブジェクト
 * @param portlet_id ポートレットID
 */
aipo.account_user.changeParentGroup = function(link, parent_post_id, sel, portlet_id) {
  var attr = " id=\"post2s\" style=\"width:30%;\" ";  
  //aimluck.utils.form.createSelect("post2s", "destpostDiv", link + "&parent_group_name=" + parent_post_id, "groupId", "name", sel, '<option value="">（選択してください）<\/option>', attr);
  aimluck.utils.form.createSelect("post2s", "destpostDiv", link + "&parent_group_name=" + parent_post_id, "groupId", "name", sel, '', attr);
}

/**
 * メールアカウント追加編集ポップアップ表示時処理
 *
 *　@param portlet_id ポートレットID
 */
aipo.account_user.onLoadMailAccountDialog = function(portlet_id){

  var obj = dojo.byId("account_name");
  if(obj){
     obj.focus();
  }

}

/**
 * プルダウン検索処理
 *
 * @param exec_url 検索URL
 *　@param p_id ポートレットID
 * @param change_post1 部署1選択か？
 */
aipo.account_user.onSearchUserSubmit = function(exec_url, p_id, change_post1){

  var parent_group_name =dojo.byId('parent_group_name').value;
  var post2_group_name =dojo.byId('post2_group_name').value;
  var admin_filter = dojo.byId('adminfiltercheckbox').checked;
  
  var search_params = [
                   ["ajax_search_corp","1"],    
                   ["parent_group_name",parent_group_name],
                   ["post2_group_name",post2_group_name],
                   ["change_post1",change_post1],
                   ["adminfiltered",admin_filter]               
                  ];
  
  aipo.viewPage(exec_url, p_id, search_params);
}

/**
 * キーワード検索処理
 *
 * @param form フォームオブジェクト
 *　@param url 検索URL
 * @param p_id ポートレットID
 */
aipo.account_user.onSubmitKeywordSerchButton = function(form,url,p_id){

     var exec_url = url;   
     var search_params
     if( form.sword.value != "" ) {
       search_params = [["sword",form.sword.value],["mode",form.mode.value]];
     } else {
       search_params = [["sword",form.sword.value]];
     }
     aipo.viewPage(exec_url, p_id, search_params);
     
}
