/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.annogen.override.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.codehaus.annogen.override.AnnoBean;
import org.codehaus.annogen.override.AnnoContext;

public class AnnoBeanBase
implements AnnoBean {
    private AnnoContext mContext = null;

    public boolean setValue(String valueName, Object value) {
        this.assertInited();
        String methodName = "set_" + valueName;
        Method[] m = this.getClass().getMethods();
        for (int i = 0; i < m.length; ++i) {
            if (!m[i].getName().equals(methodName)) continue;
            try {
                m[i].invoke((Object)this, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException iae) {
                IllegalArgumentException iae2 = new IllegalArgumentException(valueName + " " + value + "  " + value.getClass());
                iae2.initCause(iae);
                this.mContext.getLogger().error(iae2);
            }
            return true;
        }
        return false;
    }

    public AnnoBean createNestableBean(Class beanOrAnnoType) {
        this.assertInited();
        try {
            Class c = this.mContext.getAnnoBeanMapping().getAnnoBeanClassForRequest(beanOrAnnoType);
            if (c == null) {
                return null;
            }
            return this.mContext.createAnnoBeanFor(c);
        }
        catch (ClassNotFoundException e) {
            this.mContext.getLogger().error(e);
            return null;
        }
    }

    public Object getValue(String name) {
        return null;
    }

    public boolean isDefaultValueUsed(String valueName) {
        return false;
    }

    public Class annotationType() {
        try {
            return this.mContext.getAnnoBeanMapping().getDeclaredClassForAnnoBeanClass(this.getClass());
        }
        catch (ClassNotFoundException cnfe) {
            this.mContext.getLogger().error(cnfe);
            return null;
        }
    }

    public void init(AnnoContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("null ctx");
        }
        if (this.mContext != null) {
            throw new IllegalStateException("already inited");
        }
        this.mContext = ctx;
    }

    private void assertInited() {
        if (this.mContext == null) {
            throw new IllegalStateException();
        }
    }
}

