<?php
// 投稿画面の印刷プレビュー
function pripre_post_style_box($post, $box) {
    require_once ('utils.inc.php');

    $entry_style = get_post_custom_values('pripre_entry_style', $post->ID);
    if (empty($entry_style)) {
        $entry_style = "default/plain";
    }
    else {
        $entry_style = $entry_style[0];
    }
    
    $name = '';
    $templates = pripre_get_templates();
    echo '<select name="template" id="pripre_template">';
    foreach($templates as $id => $package) {
    	foreach($package['styles'] as $style) {
        if ($name != $package['name']) {
            echo '<option value="'.$style['id'].'"';
         	$name = $package['name'];
        	echo '>'.$name.'</option>';
        }
        echo '<option value="'.$style['id'].'"';
        if ($style['id'] == $entry_style) {
            echo ' selected="selected"';
        }
        echo '>&nbsp;&nbsp;'.$style['name'];
    	}
    }
    echo '</select>';
    echo '<div id="pripre_preview_pdf"></div>';
    echo '<input type="button" value="更新" onClick="pripre_preview_images();"/>';
    echo '<input type="button" value="PDF" onClick="pripre_preview_pdf();"/>';
    echo '<input type="button" value="HTML" onClick="pripre_preview_html();"/>';
    echo ' <a href="" target="_blank" id="pripre_site"></a>';
    
    echo '<script type="text/javascript">';
    echo 'var pripre_base = "'.plugins_url('pripre').'";
    var pripre_auto_preview = "'.get_option("pripre_auto_preview").'";
    var pripre_post_id = "'.$post->ID.'";
    var pripre_template_params = {';
    foreach($templates as $id => $package) {
    	foreach($package['styles'] as $style) {
	    	echo '"'.$style['id'].'":{';
	    	echo '"page-progression":"'.$style['page-progression'].'",';
	    	echo '"width":"'.$style['width'].'",';
	    	echo '"height":"'.$style['height'].'",';
	    	echo '"site":"'.$style['site'].'",';
	    	echo '},';
    	}
    }
    echo '};';
    echo '</script>';
    echo '<script type="text/javascript" src="' . plugins_url('pripre/js/edit.js') . '"></script>';

    // データ入力用の実際のフォーム
    $site = parse_url(get_option('home'));
    echo '<div style="text-align: center;"><input type="button" value="&laquo;" id="pripre_go_leftend" style="font-weight: bold;"/>';
    echo '<input type="button" value="&lsaquo;" id="pripre_go_left" style="font-weight: bold;"/>';
    echo ' <span id="pripre_page"></span> ';
    echo '<input type="button" value="&rsaquo;" id="pripre_go_right" style="font-weight: bold;"/>';
    echo '<input type="button" value="&raquo;" id="pripre_go_rightend" style="font-weight: bold;"/></div>';
    echo '<div id="pripre_image_wrapper" style="clear: both; border: 1px solid Black;">';
    echo '<img src="" id="pripre_image" style="width: 100%; height: 100%;"/>';
    echo '</div>';
}
?>
