/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Stack;
import java.util.StringTokenizer;

public class PathUtil {
    public static String resolveRelativeReference(String base, String ref) throws IllegalArgumentException {
        if (ref.startsWith("data:")) {
            return ref;
        }
        try {
            ref = URLDecoder.decode(ref, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
        if (ref.startsWith("#")) {
            int index = base.indexOf("#");
            ref = index < 0 ? base + ref : base.substring(0, index) + ref;
        } else {
            int index = base.lastIndexOf("/");
            ref = base.substring(0, index + 1) + ref;
        }
        return PathUtil.normalizePath(ref);
    }

    public static String normalizePath(String path) throws IllegalArgumentException {
        if (path.indexOf("..") < 0) {
            return path;
        }
        Stack<String> pathSegments = new Stack<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        while (tokenizer.hasMoreTokens()) {
            String pathSegment = tokenizer.nextToken();
            if (pathSegment.equals(".")) continue;
            if (pathSegment.equals("..")) {
                if (pathSegments.size() == 0) {
                    throw new IllegalArgumentException("Invalid path: " + path);
                }
                pathSegments.pop();
                continue;
            }
            pathSegments.push(pathSegment);
        }
        StringBuffer sb = new StringBuffer();
        String sep = "";
        int len = pathSegments.size();
        for (int i = 0; i < len; ++i) {
            sb.append(sep);
            sb.append((String)pathSegments.elementAt(i));
            sep = "/";
        }
        return sb.toString();
    }

    public static String removeAnchor(String href) {
        int index = href.indexOf("#");
        if (index == -1) {
            return href;
        }
        return href.substring(0, index);
    }
}

