/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.api;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFChecker;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.util.CheckUtil;
import com.adobe.epubcheck.util.DefaultReportImpl;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.WriterReportImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.ZipFile;

public class EpubCheck
implements DocumentValidator {
    public static final String VERSION = "3.0b2";
    File epubFile;
    Report report;

    public EpubCheck(File epubFile) {
        this.epubFile = epubFile;
        this.report = new DefaultReportImpl(epubFile.getName());
    }

    public EpubCheck(File epubFile, PrintWriter out) {
        this.epubFile = epubFile;
        this.report = new WriterReportImpl(out);
    }

    public EpubCheck(File epubFile, Report report) {
        this.epubFile = epubFile;
        this.report = report;
    }

    public EpubCheck(InputStream inputStream, Report report) {
        try {
            int read;
            File epubFile = File.createTempFile("epub.epub", null);
            epubFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(epubFile);
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            inputStream.close();
            out.flush();
            ((OutputStream)out).close();
            this.epubFile = epubFile;
            this.report = report;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean validate() {
        try {
            int readCount;
            FileInputStream epubIn = new FileInputStream(this.epubFile);
            byte[] header = new byte[58];
            if (readCount != -1) {
                int read;
                for (readCount = epubIn.read(header); readCount < header.length && (read = epubIn.read(header, readCount, header.length - readCount)) != -1; readCount += read) {
                }
            }
            if (readCount != header.length) {
                this.report.error(null, 0, 0, Messages.CANNOT_READ_HEADER);
            } else {
                int fnsize = this.getIntFromBytes(header, 26);
                int extsize = this.getIntFromBytes(header, 28);
                if (header[0] != 80 && header[1] != 75) {
                    this.report.error(null, 0, 0, Messages.CORRUPTED_ZIP_HEADER);
                } else if (fnsize != 8) {
                    this.report.error(null, 0, 0, String.format(Messages.LENGTH_FIRST_FILENAME, fnsize));
                } else if (extsize != 0) {
                    this.report.error(null, 0, 0, String.format(Messages.EXTRA_FIELD_LENGTH, extsize));
                } else if (!CheckUtil.checkString(header, 30, "mimetype")) {
                    this.report.error(null, 0, 0, Messages.MIMETYPE_ENTRY_MISSING);
                } else if (!CheckUtil.checkString(header, 38, "application/epub+zip")) {
                    this.report.error(null, 0, 0, String.format(Messages.MIMETYPE_WRONG_TYPE, "application/epub+zip"));
                }
            }
            epubIn.close();
            ZipFile zip = new ZipFile(this.epubFile);
            OCFPackage ocf = new OCFPackage(zip);
            OCFChecker checker = new OCFChecker(ocf, this.report);
            checker.runChecks();
            zip.close();
        }
        catch (IOException e) {
            this.report.error(null, 0, 0, String.format(Messages.IO_ERROR, e.getMessage()));
        }
        return this.report.getWarningCount() == 0 && this.report.getErrorCount() == 0;
    }

    private int getIntFromBytes(byte[] bytes, int offset) {
        int hi = 0xFF & bytes[offset + 1];
        int lo = 0xFF & bytes[offset + 0];
        return hi << 8 | lo;
    }
}

