package jp.cssj.cr.gc;

import java.io.IOException;
import java.net.URI;
import java.util.List;

import jp.cssj.cr.epub.Cache;
import jp.cssj.homare.css.value.LengthValue;
import jp.cssj.homare.impl.ua.AbstractUserAgent;
import jp.cssj.homare.impl.ua.NopVisitor;
import jp.cssj.homare.style.visitor.Visitor;
import jp.cssj.homare.ua.AbortException;
import jp.cssj.homare.ua.BrokenResultException;
import jp.cssj.resolver.Source;
import jp.cssj.sakae.gc.GC;
import jp.cssj.sakae.gc.font.FontManager;
import jp.cssj.sakae.gc.image.Image;

public class AndroidUserAgent extends AbstractUserAgent {
	private final FontManager fontManager;
	private final Cache cache;
	private final List<RecorderGC> pages;
	protected int pageCount = 0;

	public AndroidUserAgent(FontManager fontManager, Cache cache,
			List<RecorderGC> pages) {
		this.setUnitType(LengthValue.UNIT_PX);
		this.fontManager = fontManager;
		this.cache = cache;
		this.pages = pages;
		if (this.pages.isEmpty()) {
			this.pages.add(null);
		}
	}

	public FontManager getFontManager() {
		return this.fontManager;
	}

	public void meta(String name, String content) {
		// ignore
	}

	public GC nextPage() {
		// System.err.println("*** "+this.pageCount+" page");
		this.checkAbort(AbortException.ABORT_FORCE);
		GC gc = new RecorderGC(this.pageWidth, this.pageHeight,
				this.fontManager);
		return gc;
	}

	@Override
	public void closePage(GC gc) throws IOException {
		this.checkAbort(AbortException.ABORT_FORCE);
		super.closePage(gc);
		this.pages.set(this.pageCount, (RecorderGC) gc);
		// System.err.println("*** "+this.pageCount+" parse");
		++this.pageCount;
		if (this.pages.size() <= this.pageCount) {
			this.pages.add(null);
		}
	}

	public Visitor getVisitor(GC gc) {
		return new NopVisitor(this);
	}

	public void finish() throws BrokenResultException, IOException {
		this.pages.remove(this.pageCount);
	}

	@Override
	protected Image loadImage(Source source) throws IOException {
		URI uri = source.getURI();
		AndroidImage image = this.cache.getImage(uri);
		if (image == null) {
			image = new AndroidImage(source, this.cache);
			this.cache.putImage(uri, image);
		}
		return image;
	}
}
