package jp.cssj.cr.gc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import jp.cssj.cr.compat.XLine;
import jp.cssj.cr.compat.XMatrix;
import jp.cssj.sakae.font.Font;
import jp.cssj.sakae.font.FontMetricsImpl;
import jp.cssj.sakae.gc.GC;
import jp.cssj.sakae.gc.GraphicsException;
import jp.cssj.sakae.gc.font.FontManager;
import jp.cssj.sakae.gc.image.Image;
import jp.cssj.sakae.gc.paint.Color;
import jp.cssj.sakae.gc.text.Text;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;

/**
 * @author <a href="mailto:tatsuhiko at miya.be">MIYABE Tatsuhiko </a>
 * @version $Id: AbstractG2D_GC.java,v 1.2 2007-05-06 04:27:03 miyabe Exp $
 */

public class AndroidGC implements GC {
	private final boolean DEBUG = false;

	protected final Canvas c;
	protected final Annotations s;
	protected final FontManager fm;

	static class GS {
		protected Paint fillPaint, strokePaint;
		protected XMatrix matrix;

		GS() {
			this.fillPaint = new Paint();
			this.strokePaint = new Paint();
			this.matrix = new XMatrix();
			this.strokePaint.setAntiAlias(true);
			this.strokePaint.setStyle(Style.STROKE);
			this.fillPaint.setAntiAlias(true);
			this.fillPaint.setStyle(Style.FILL);
		}

		GS(GS gs) {
			this.fillPaint = new Paint(gs.fillPaint);
			this.strokePaint = new Paint(gs.strokePaint);
			this.matrix = new XMatrix(gs.matrix);
		}
	}

	GS gs = new GS();
	List<GS> stack = new ArrayList<GS>();

	public AndroidGC(final Canvas c, final Annotations s, final FontManager fm) {
		this.c = c;
		this.s = s;
		this.fm = fm;
	}

	public FontManager getFontManager() {
		return this.fm;
	}

	protected Canvas getCanvas() {
		return this.c;
	}

	public void begin() {
		this.c.save();
		this.stack.add(this.gs);
		this.gs = new GS(this.gs);
	}

	public void end() {
		this.c.restore();
		this.gs = this.stack.remove(this.stack.size() - 1);
	}

	public void setLineWidth(double width) {
		this.gs.strokePaint.setStrokeWidth((float) width);
	}

	public void setLinePattern(double[] pattern) {
		// TODO
	}

	public void setLineCap(short style) {
		// TODO
	}

	public void setLineJoin(short style) {
		// TODO
	}

	public void setTextMode(short textMode) throws GraphicsException {
		// TODO
	}

	public void setComposite(Object composite) {
		// TODO
	}

	public void setStrokePaint(Object paint) throws GraphicsException {
		if (DEBUG) {
			System.err.println("setStrokePaint:" + paint);
		}
		if (!(paint instanceof Color)) {
			return;
		}
		this.gs.strokePaint = this.toPaint(this.gs.strokePaint, paint);
	}

	public void setFillPaint(Object paint) throws GraphicsException {
		if (DEBUG) {
			System.err.println("setFillPaint:" + paint);
		}
		if (!(paint instanceof Color)) {
			return;
		}
		this.gs.fillPaint = this.toPaint(this.gs.fillPaint, paint);
	}

	private Paint toPaint(Paint paint, Object o) {
		Color color = (Color) o;
		paint.setARGB(255, (int) (color.getRed() * 255),
				(int) (color.getGreen() * 255), (int) (color.getBlue() * 255));
		return paint;
	}

	public void transform(XMatrix at) {
		this.gs.matrix.preConcat(at);
		this.c.setMatrix(this.gs.matrix);
	}

	public XMatrix getTransform() {
		return this.gs.matrix;
	}

	public void clip(Path shape) {
		this.c.clipPath(shape);
	}

	public void clip(RectF r) {
		this.c.clipRect(r);
	}

	public void resetState() {
		this.c.restoreToCount(this.c.getSaveCount());
	}

	public void drawImage(Image image) throws GraphicsException {
		if (image instanceof AndroidImage) {
			AndroidImage androImage = (AndroidImage) image;
			if (this.s != null) {
				Matrix mx = this.getTransform();
				float[] v = { 0, 0, (float) androImage.getWidth(),
						(float) androImage.getHeight() };
				mx.mapPoints(v);
				this.s.addImage(androImage, new RectF(v[0], v[1], v[2], v[3]));
			}
			Drawable d = androImage.getDrawable();
			d.setBounds(0, 0, (int) image.getWidth(), (int) image.getHeight());
			this.c.drawRect(d.getBounds(), this.gs.fillPaint);
			d.draw(this.c);
			return;
		}
		image.drawTo(this);
	}

	public void fill(Path shape) {
		if (DEBUG) {
			System.err.println("fill:" + shape);
		}
		this.c.drawPath(shape, this.gs.fillPaint);
	}

	public void fill(RectF shape) {
		if (DEBUG) {
			System.err.println("fill:" + shape);
		}
		this.c.drawRect(shape, this.gs.fillPaint);
	}

	public void fillOval(RectF shape) {
		if (DEBUG) {
			System.err.println("fillOval:" + shape);
		}
		this.c.drawOval(shape, this.gs.fillPaint);
	}

	public void draw(Path shape) {
		if (DEBUG) {
			System.err.println("draw:" + shape);
		}
		this.c.drawPath(shape, this.gs.strokePaint);
	}

	public void draw(RectF shape) {
		if (DEBUG) {
			System.err.println("draw:" + shape);
		}
		this.c.drawRect(shape, this.gs.strokePaint);
	}

	public void drawOval(RectF shape) {
		if (DEBUG) {
			System.err.println("drawOval:" + shape);
		}
		this.c.drawOval(shape, this.gs.strokePaint);
	}

	public void draw(XLine line) {
		if (DEBUG) {
			System.err.println("draw:" + line);
		}
		this.c.drawLine(line.x1, line.y1, line.x2, line.y2, this.gs.strokePaint);
	}

	public void fillDraw(Path shape) {
		this.fill(shape);
		this.draw(shape);
	}

	public void fillDraw(RectF shape) {
		this.fill(shape);
		this.draw(shape);
	}

	public void fillDrawOval(RectF shape) {
		this.fillOval(shape);
		this.drawOval(shape);
	}

	public void drawText(Text text, double x, double y)
			throws GraphicsException {
		if (DEBUG) {
			System.err.println(text);
		}
		this.begin();
		this.transform(XMatrix.getTranslateInstance(x, y));
		Font font = ((FontMetricsImpl) text.getFontMetrics()).getFont();
		try {
			font.drawTo(this, text);
		} catch (IOException e) {
			throw new GraphicsException(e);
		}
		this.end();
	}
}