<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="/">
    <html>
      <body>
        <H2>
          <xsl:value-of select="TEI.2/teiHeader/fileDesc/titleStmt/title"/>
        </H2>&#60;key type="表記" title="###.%%%"&#62;###.%%%&#60;/key&#62;
        <xsl:apply-templates select=".//div1"/>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="div1/head">&#60;p&#62;<xsl:apply-templates/>&#60;/p&#62;</xsl:template>
  <xsl:template match="div1">
&#60;H3 id="<xsl:value-of select="@n"/>"&#62;Book <xsl:value-of select="@n"/> [###.%%%.<xsl:value-of select="@n"/>]&#60;/H3&#62;&#60;key type="表記" title="###.%%%.<xsl:value-of select="@n"/>"&#62;###.%%%.<xsl:value-of select="@n"/>&#60;/key&#62;<xsl:apply-templates/></xsl:template>

  <xsl:template match="div2/head">&#60;p&#62;<xsl:apply-templates/>&#60;/p&#62;</xsl:template>
  <xsl:template match="div2">
&#60;indent val="0"&#62;&#60;p id="<xsl:value-of select="ancestor::div1/@n"/>.<xsl:value-of select="@n"/>"&#62;&#60;dfn title="###.%%%.<xsl:value-of select="ancestor::div1/@n"/>.<xsl:value-of select="@n"/>"&#62;[###.%%%.<xsl:value-of select="ancestor::div1/@n"/>.<xsl:value-of select="@n"/>]&#60;/dfn&#62;&#60;/p&#62;&#60;indent val="1"&#62;<xsl:apply-templates/></xsl:template>

  <xsl:template match="p">&#60;p&#62;<xsl:apply-templates/>&#60;/p&#62;</xsl:template>

  <xsl:template match="argument">&#60;p&#62;<xsl:apply-templates/>&#60;/p&#62;</xsl:template>
  <xsl:template match="list">&#60;ul&#62;<xsl:apply-templates/>&#60;/ul&#62;</xsl:template>
  <xsl:template match="ref">&#60;a href="#<xsl:value-of select="substring(@target, 2, 1)"/>.<xsl:value-of select="substring(@target, 4)"/>"&#62;<xsl:apply-templates/>&#60;/a&#62;</xsl:template>
  <xsl:template match="item">&#60;li&#62;<xsl:apply-templates/>&#60;/li&#62;</xsl:template>

</xsl:stylesheet>
