/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.PartsAuthorInfo;
import charactermanaj.model.PartsManageData;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PartsInfoXMLWriter {
    public static final String NS_PARTSDEF = "http://charactermanaj.sourceforge.jp/schema/charactermanaj-partsdef";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePartsManageData(URI docBase, PartsManageData partsManageData) throws IOException {
        if (docBase == null || partsManageData == null) {
            throw new IllegalArgumentException();
        }
        if (!"file".equals(docBase.getScheme())) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u4ee5\u5916\u306f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093: " + docBase);
        }
        File docBaseFile = new File(docBase);
        File baseDir = docBaseFile.getParentFile();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.savePartsManageData(partsManageData, bos);
        }
        finally {
            bos.close();
        }
        File partsInfoXML = new File(baseDir, "parts-info.xml");
        FileOutputStream os = new FileOutputStream(partsInfoXML);
        try {
            os.write(bos.toByteArray());
        }
        finally {
            os.close();
        }
    }

    public void savePartsManageData(PartsManageData partsManageData, OutputStream outstm) throws IOException {
        Transformer tfmr;
        Document doc;
        if (partsManageData == null || outstm == null) {
            throw new IllegalArgumentException();
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Exception.", ex);
        }
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        Element root = doc.createElementNS(NS_PARTSDEF, "parts-definition");
        root.setAttribute("xmlns:xml", "http://www.w3.org/XML/1998/namespace");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:schemaLocation", "http://charactermanaj.sourceforge.jp/schema/charactermanaj-partsdef parts-definition.xsd");
        doc.appendChild(root);
        Collection<PartsAuthorInfo> partsAuthors = partsManageData.getAuthorInfos();
        for (PartsAuthorInfo partsAuthorInfo : partsAuthors) {
            List partsKeyGrp;
            String author = partsAuthorInfo.getAuthor();
            if (author == null || author.length() == 0) continue;
            Element nodeAuthor = doc.createElementNS(NS_PARTSDEF, "author");
            Element nodeAuthorName = doc.createElementNS(NS_PARTSDEF, "name");
            Attr attrLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
            attrLang.setValue(lang);
            nodeAuthorName.setAttributeNodeNS(attrLang);
            nodeAuthorName.setTextContent(author);
            nodeAuthor.appendChild(nodeAuthorName);
            String homepageURL = partsAuthorInfo.getHomePage();
            if (homepageURL != null && homepageURL.length() > 0) {
                Element nodeHomepage = doc.createElementNS(NS_PARTSDEF, "home-page");
                Attr attrHomepageLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attrHomepageLang.setValue(lang);
                nodeHomepage.setAttributeNodeNS(attrHomepageLang);
                nodeHomepage.setTextContent(homepageURL);
                nodeAuthor.appendChild(nodeHomepage);
            }
            root.appendChild(nodeAuthor);
            Collection<PartsManageData.PartsKey> partsKeys = partsManageData.getPartsKeysByAuthor(author);
            HashMap<String, ArrayList<PartsManageData.PartsKey>> downloadMap = new HashMap<String, ArrayList<PartsManageData.PartsKey>>();
            for (PartsManageData.PartsKey partsKey : partsKeys) {
                PartsManageData.PartsVersionInfo versionInfo = partsManageData.getVersionStrict(partsKey);
                String downloadURL = versionInfo.getDownloadURL();
                if (downloadURL == null) {
                    downloadURL = "";
                }
                if ((partsKeyGrp = (ArrayList<PartsManageData.PartsKey>)downloadMap.get(downloadURL)) == null) {
                    partsKeyGrp = new ArrayList<PartsManageData.PartsKey>();
                    downloadMap.put(downloadURL, (ArrayList<PartsManageData.PartsKey>)partsKeyGrp);
                }
                partsKeyGrp.add(partsKey);
            }
            ArrayList downloadURLs = new ArrayList(downloadMap.keySet());
            Collections.sort(downloadURLs);
            SimpleDateFormat dateTimeFmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            for (String downloadURL : downloadURLs) {
                partsKeyGrp = (List)downloadMap.get(downloadURL);
                Collections.sort(partsKeyGrp);
                Element nodeDownload = doc.createElementNS(NS_PARTSDEF, "download-url");
                nodeDownload.setTextContent(downloadURL);
                root.appendChild(nodeDownload);
                for (PartsManageData.PartsKey partsKey : partsKeyGrp) {
                    String localizedName;
                    PartsManageData.PartsVersionInfo versionInfo = partsManageData.getVersionStrict(partsKey);
                    Element nodeParts = doc.createElementNS(NS_PARTSDEF, "parts");
                    nodeParts.setAttribute("name", partsKey.getPartsName());
                    if (partsKey.getCategoryId() != null) {
                        nodeParts.setAttribute("category", partsKey.getCategoryId());
                    }
                    if (versionInfo.getVersion() > 0.0) {
                        nodeParts.setAttribute("version", Double.toString(versionInfo.getVersion()));
                    }
                    if (versionInfo.getLastModified() != null) {
                        nodeParts.setAttribute("lastModified", dateTimeFmt.format(versionInfo.getLastModified()));
                    }
                    if ((localizedName = partsManageData.getLocalizedName(partsKey)) != null && localizedName.trim().length() > 0) {
                        Element nodeLocalizedName = doc.createElementNS(NS_PARTSDEF, "local-name");
                        Attr attrLocalizedNameLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                        attrLocalizedNameLang.setValue(lang);
                        nodeLocalizedName.setAttributeNodeNS(attrLocalizedNameLang);
                        nodeLocalizedName.setTextContent(localizedName);
                        nodeParts.appendChild(nodeLocalizedName);
                    }
                    root.appendChild(nodeParts);
                }
            }
        }
        TransformerFactory txFactory = TransformerFactory.newInstance();
        txFactory.setAttribute("indent-number", 4);
        try {
            tfmr = txFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Failed.", ex);
        }
        tfmr.setOutputProperty("indent", "yes");
        String encoding = "UTF-8";
        tfmr.setOutputProperty("encoding", "UTF-8");
        try {
            tfmr.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(outstm, Charset.forName("UTF-8"))));
        }
        catch (TransformerException ex) {
            IOException ex2 = new IOException("XML Convert failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }
}

