/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.io.NullWatchAgentHandle;
import charactermanaj.model.io.PartsImageDirectoryWatchAgent;
import charactermanaj.model.io.PartsImageDirectoryWatchAgentHandle;
import charactermanaj.model.io.PartsImageDirectoryWatchAgentThread;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PartsImageDirectoryWatchAgentFactory {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static PartsImageDirectoryWatchAgentFactory inst = new PartsImageDirectoryWatchAgentFactory();
    private HashMap<URI, PartsImageDirectoryWatchAgentThread> agents = new HashMap();
    private final Object lock = new Object();

    private PartsImageDirectoryWatchAgentFactory() {
    }

    public static PartsImageDirectoryWatchAgentFactory getFactory() {
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartsImageDirectoryWatchAgent getAgent(CharacterData characterData) {
        PartsImageDirectoryWatchAgentThread agentImpl;
        if (characterData == null || !characterData.isValid()) {
            return new NullWatchAgentHandle(characterData);
        }
        URI docBase = characterData.getDocBase();
        Object object = this.lock;
        synchronized (object) {
            if (this.agents.containsKey(docBase)) {
                agentImpl = this.agents.get(docBase);
            } else {
                agentImpl = new PartsImageDirectoryWatchAgentThread(characterData);
                this.agents.put(docBase, agentImpl);
                this.logger.log(Level.FINE, "watch agent is cached. " + agentImpl);
            }
        }
        return new PartsImageDirectoryWatchAgentHandle(agentImpl);
    }
}

