/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2006 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

//XBSch̃hLg̊ǗsB
#include "stdafx.h"
//#include <qapplication.h>
//#include <qwidget.h>
//#include <SSize.h>
//#include <SPoint.h>
//#include <qclipboard.h>
#include <stdio.h>
#include <assert.h>
#include <string>
#include <list>
using namespace std;
#include "ce3io.h"
//#include "xbschobj.h"
//#include "xbschjunc.h"
//#include "xbschlabel.h"
//#include "xbschcomment.h"
//#include "xbschtag.h"
//#include "xbschcomponent.h"

//#include "xbschline.h"
//#include "xbschentry.h"
//#include "xbschdelobj.h"
//#include "xbschsheetinfo.h"
#include "SheetSizeInfo.h"
#include "xbschdoc.h"



SPointEmum::SPointEmum()
{
	m_list.clear();
}

SPointEmum::~SPointEmum()
{
	m_list.clear();
}

bool SPointEmum::addSPoint(SPoint point)
{
	SPointListIterator ite;
	ite = m_list.begin();
	while(ite !=m_list.end()){
		if( (ite->x()==point.x()) &&  (ite->y()==point.y()) ){
			TRACE("SPointEmum::addSPoint() returns false\n");
			return false;
		}
		ite++;
	}
	m_list.push_back(point);
	return true;
}
//
//	SPointPtrList m_list;
//};




SXBSchDoc::SXBSchDoc()
{
//	m_bDirty = false;
//	m_bTempDirty = false;
//	m_bTempNewPlace = false;
//	m_pView = NULL;
//	m_bSelectForDrag = false;
	m_sizeSheet = SSize(1500,1000);
	init();
}

SXBSchDoc::~SXBSchDoc()
{
	init();
}

bool SXBSchDoc::isEmpty()
{
	if( (m_listMain.size() > 0) || (m_listTemp.size() > 0 )) return false;
	else return true;
}


//#define SHEETSIZE_X_MIN		640
//#define SHEETSIZE_X_MAX		5000
//#define SHEETSIZE_Y_MIN		400
//#define SHEETSIZE_Y_MAX		4000

//V[gTCY̐ݒ
void SXBSchDoc::SetSheetSize(const SSize& size)
{
	if(   size.w()<SHEETSIZE_X_MIN
		||size.w()>SHEETSIZE_X_MAX
		||size.h()<SHEETSIZE_Y_MIN
		||size.h()>SHEETSIZE_Y_MAX) return;


	m_sizeSheet = size;
}

//20060603	//}ʗvf̒ǉ ԍԂ
//20060603	int SXBSchDoc::add(SXBSchObj* pObj)
//20060603	{
//20060603		if(pObj == NULL) return m_nOpCount;
//20060603		m_nOpCount++;
//20060603		m_bDirty = true;	
//20060603		pObj->setPlaceNum(m_nOpCount);	
//20060603		m_listMain.push_back(pObj);
//20060603		m_bFindCommandActive = false;
//20060603		return m_nOpCount;
//20060603	}

//IԂŒǉ}ʗvf̒ǉ ԍԂ
int  SXBSchDoc::addSelect(SXBSchObj* pObj)
{
	m_listTemp.push_back(pObj);
	setupRcTempArea();
	m_bTempNewPlace = true;
	m_bFindCommandActive = false;
	//m_bDirty = true;	
	return m_nOpCount;
}

//_w肵Ă̑I
//_w肵Ă̑Ił́A1̃IuWFNgI΂ȂB
int SXBSchDoc::select(const SPoint& pt,SelectOption& refSelOption)
{
	//resetSelect();		//2009/05/10 RgAEg
	SXBSchObj* pObjSelected = NULL;
	int maxSelectWeight=0;
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(pObjIte !=  m_listMain.end()){
		if( (*pObjIte)->layer() == m_editLayer
		  &&(*pObjIte)->refObj()==NULL	//QƃIuWFNĝ݂͖ł
		 && ( ((refSelOption.m_mask & OBJMASK_USEFILTER) == 0)||( (refSelOption.m_mask & (*pObjIte)->objectFilterValue()) == 0 ))
		){
			int SelectWeight = (*pObjIte)->qSelectWeight(pt) & 0xFFFF;
			if(SelectWeight > maxSelectWeight){
				maxSelectWeight = SelectWeight;
				pObjSelected = (*pObjIte);
			}
		}
		pObjIte++;
	}
	if(pObjSelected != NULL){
		SXBSchObj* pNewObj = pObjSelected->duplicate();
		pObjSelected->setRefObj(pNewObj);
		pNewObj->setRefObj(pObjSelected);
		pNewObj->setSelection(SXBSchObj::SELECT_ALL);
		m_listTemp.push_back(pNewObj);
		m_bFindCommandActive = false;
	}
	setupRcTempArea();
	setupRotateRect();
	m_bSelectForDrag = false;
	int selCount = m_listTemp.size();
	if(selCount>0){
		updateSelectedTypeFlag();
		discardRedo();
	}
	return selCount; 
}

//͈͂w肵Ă̑I
//IƂ́A
//  C̃XgŶA
//  ꎞIuWFNgɒǉ
//IԂ
int SXBSchDoc::select(const SRect& rc,SelectOption& refSelOption)
{
	//resetSelect();		//2009/05/10 RgAEg
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(pObjIte != m_listMain.end()){
		if( (*pObjIte)->layer() == m_editLayer
		 && (*pObjIte)->refObj()==NULL	//QƃIuWFNĝ݂͖ł
		 && ( ((refSelOption.m_mask & OBJMASK_USEFILTER) == 0)||( (refSelOption.m_mask & (*pObjIte)->objectFilterValue()) == 0 ))
		){
			unsigned nSelStatus = (*pObjIte)->testSelection(rc);
			if(nSelStatus){
				SXBSchObj* pNewObj = (*pObjIte)->duplicate();
				(*pObjIte)->setRefObj(pNewObj);
				pNewObj->setRefObj(*pObjIte);
				pNewObj->setSelection(nSelStatus);
				m_listTemp.push_back(pNewObj);
			}
		}
		*pObjIte++;
	}
	setupRcTempArea();
	setupRotateRect();
	m_bSelectForDrag = false;
	int n = m_listTemp.size();
	if(n>0){
		m_bFindCommandActive = false;
		updateSelectedTypeFlag();
		discardRedo();
	}
	return n;
}


//}ʗvfCXgpush_backB
void SXBSchDoc::pushBackToMainList(SXBSchObj* pObj,bool doTidyUp)
{
	//doTidyUp = false;
	if(m_bDoTidyUp && doTidyUp){
		if(		pObj->id()==SXBSchObj::ID_JUNCTION
			||  pObj->id()==SXBSchObj::ID_BENTRY
			||  pObj->id()==SXBSchObj::ID_ENTRY	){		//20090207 d`FbNɃGg[ǉ
			//if(checkRedundancyJunction((SXBSchJunc*)pObj)){
			if(checkRedundancy(pObj)){
				delete pObj;
				return;
			}
		}else if(pObj->id()==SXBSchObj::ID_WIRE || pObj->id()==SXBSchObj::ID_BUS){
			tidyUpWireBus((SXBSchLine*)pObj);
			return;
		}
	}
	m_listMain.push_back(pObj);
}

//C[,WNV̓  Xebv1
//WNV̏ꏊŌÂC[
void SXBSchDoc::tidyUpWireJunction_1(int opCount)
{
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(pObjIte != m_listMain.end()){
		if(   (*pObjIte)->placeNum()<opCount
			||(*pObjIte)->id() != SXBSchObj::ID_DELETEOBJ
			||(*pObjIte)->refObj() == NULL){
			pObjIte++;
			continue;
		}
		if((*pObjIte)->refObj()->id() != SXBSchObj::ID_JUNCTION){
			pObjIte++;
			continue;
		}

		SXBSchObj* pObj = (*pObjIte)->refObj(); //ꂽWNV
		int nLayer = pObj->layer();	//ꂽWNṼC[
		SPoint pj = pObj->p1();		//ꂽWNV̈ʒu
		XBSchObjListIterator pObjIteW = m_listMain.begin();
		SXBSchWire* pWireVl = NULL;
		SXBSchWire* pWireVr = NULL;
		SXBSchWire* pWireHl = NULL;
		SXBSchWire* pWireHr = NULL;
		while(pObjIteW != m_listMain.end()){
			if(   (*pObjIteW)->id() != SXBSchObj::ID_WIRE
				//||(*pObjIte)->placeNum()>=opCount
				||(*pObjIteW)->layer() != nLayer 
				||(*pObjIteW)->refObj()!=NULL){
				pObjIteW++;
				continue;
			}
			if((*pObjIteW)->p1()!=pj && (*pObjIteW)->p2()!=pj){
				pObjIteW++;
				continue;
			}
			bool horz = ((*pObjIteW)->y1() == (*pObjIteW)->y2());
			bool vert = ((*pObjIteW)->x1() == (*pObjIteW)->x2());
			if((!horz && !vert)||(horz && vert)){
				pObjIteW++;
				continue;
			}
			if(horz){
				if( ((*pObjIteW)->x1()+(*pObjIteW)->x2()) > pj.x()*2 ){
					pWireHr = (SXBSchWire*)(*pObjIteW);
				}else{
					pWireHl = (SXBSchWire*)(*pObjIteW);
				}
			}else{
				if( ((*pObjIteW)->y1()+(*pObjIteW)->y2()) > pj.y()*2 ){
					pWireVr = (SXBSchWire*)(*pObjIteW);
				}else{
					pWireVl = (SXBSchWire*)(*pObjIteW);
				}
			}
			pObjIteW++;
			continue;
		}
		if(pWireHr && pWireHl){
			SXBSchWire* pNewWire = (SXBSchWire*)(pWireHl->duplicate());
			pNewWire->setX1(pWireHl->x1()+pWireHl->x2()-pj.x());
			pNewWire->setX2(pWireHr->x1()+pWireHr->x2()-pj.x());
			pNewWire->setPlaceNum(opCount);
			m_listMain.push_back(pNewWire);
			SXBSchDelObj* pDelObj;
			pDelObj = new SXBSchDelObj;		//IuWFNg邽߂̏IuWFNg쐬
			pWireHl->setRefObj(pDelObj);					//IuWFNgɏIuWFNgݒ
			pDelObj->setRefObj(pWireHl);					//IuWFNgɋIuWFNgݒ
			pDelObj->setPlaceNum(opCount);				
			m_listMain.push_back(pDelObj);
			pDelObj = new SXBSchDelObj;						//IuWFNg邽߂̏IuWFNg쐬
			pWireHr->setRefObj(pDelObj);					//IuWFNgɏIuWFNgݒ
			pDelObj->setRefObj(pWireHr);					//IuWFNgɋIuWFNgݒ
			pDelObj->setPlaceNum(opCount);				
			m_listMain.push_back(pDelObj);
		}
		if(pWireVr && pWireVl){
			SXBSchWire* pNewWire = (SXBSchWire*)(pWireVl->duplicate());
			pNewWire->setY1(pWireVl->y1()+pWireVl->y2()-pj.y());
			pNewWire->setY2(pWireVr->y1()+pWireVr->y2()-pj.y());
			pNewWire->setPlaceNum(opCount);
			m_listMain.push_back(pNewWire);
			SXBSchDelObj* pDelObj;
			pDelObj = new SXBSchDelObj;		//IuWFNg邽߂̏IuWFNg쐬
			pWireVl->setRefObj(pDelObj);					//IuWFNgɏIuWFNgݒ
			pDelObj->setRefObj(pWireVl);					//IuWFNgɋIuWFNgݒ
			pDelObj->setPlaceNum(opCount);				
			m_listMain.push_back(pDelObj);
			pDelObj = new SXBSchDelObj;						//IuWFNg邽߂̏IuWFNg쐬
			pWireVr->setRefObj(pDelObj);					//IuWFNgɏIuWFNgݒ
			pDelObj->setRefObj(pWireVr);					//IuWFNgɋIuWFNgݒ
			pDelObj->setPlaceNum(opCount);				
			m_listMain.push_back(pDelObj);
		}
		pObjIte++;
		continue;
	}
}


//C[,WNV̓  Xebv2
//VKWNVŌÂC[̕sB
void SXBSchDoc::tidyUpWireJunction_2(int opCount)
{
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(pObjIte != m_listMain.end()){
		if(   (*pObjIte)->placeNum()<opCount
			||(*pObjIte)->id() != SXBSchObj::ID_JUNCTION
		    //||(*pObjIte)->layer() != m_editLayer 
			||(*pObjIte)->refObj()!=NULL){
			pObjIte++;
			continue;
		}
		int nLayer = (*pObjIte)->layer();
		SPoint pj = (*pObjIte)->p1();
		XBSchObjListIterator pObjIteW = m_listMain.begin();
		while(pObjIteW != m_listMain.end()){
			if(   (*pObjIteW)->placeNum() >= opCount
				||(*pObjIteW)->id() != SXBSchObj::ID_WIRE
				//||(*pObjIteW)->layer() != m_editLayer 
				||(*pObjIteW)->layer() != nLayer 
				||(*pObjIteW)->refObj()!=NULL){
				pObjIteW++;
				continue;
			}
			SPoint p1 = (*pObjIteW)->p1();
			SPoint p2 = (*pObjIteW)->p2();
			if(p1.x()==p2.x() && p1.x()== pj.x()){
				if( (p1.y() <= pj.y() && p2.y() <= pj.y())
				 || (p1.y() >= pj.y() && p2.y() >= pj.y())){
					pObjIteW++;
					continue;
				}
			}else if(p1.y()==p2.y() && p1.y()== pj.y()){
				if( (p1.x() <= pj.x() && p2.x() <= pj.x())
				 || (p1.x() >= pj.x() && p2.x() >= pj.x())){
					pObjIteW++;
					continue;
				}
			}else{
				pObjIteW++;
				continue;
			}
			SXBSchWire* pWire1 = (SXBSchWire*)((*pObjIteW)->duplicate());
			SXBSchWire* pWire2 = (SXBSchWire*)((*pObjIteW)->duplicate());
			pWire1->setP2(pj);
			pWire1->setPlaceNum(opCount);
			pWire2->setP1(pj);
			pWire1->setPlaceNum(opCount);
			pWire2->setPlaceNum(opCount);
			SXBSchDelObj* pDelObj = new SXBSchDelObj;		//IuWFNg邽߂̏IuWFNg쐬
			(*pObjIteW)->setRefObj(pDelObj);					//IuWFNgɏIuWFNgݒ
			pDelObj->setRefObj(*pObjIteW);					//IuWFNgɋIuWFNgݒ
			pDelObj->setPlaceNum(opCount);				
			m_listMain.push_back(pDelObj);
			m_listMain.push_back(pWire1);
			m_listMain.push_back(pWire2);
			pObjIteW++;
			continue;
		}
		pObjIte++;
		continue;
	}
}

//C[,WNV̓  Xebv3
//VKC[SWNVŕB
void SXBSchDoc::tidyUpWireJunction_3(int opCount)
{
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(pObjIte != m_listMain.end()){
		if(   (*pObjIte)->placeNum()<opCount
			||(*pObjIte)->id() != SXBSchObj::ID_WIRE
		    //||(*pObjIte)->layer() != m_editLayer 
			||(*pObjIte)->refObj()!=NULL){
			pObjIte++;
			continue;
		}
		int nLayer = (*pObjIte)->layer();
		SPoint p1 = (*pObjIte)->p1();
		SPoint p2 = (*pObjIte)->p2();
		XBSchObjListIterator pObjIteJ = m_listMain.begin();
		while(pObjIteJ != m_listMain.end()){
			if( //  (*pObjIteW)->placeNum() >= opCount
				  (*pObjIteJ)->id() != SXBSchObj::ID_JUNCTION
				//||(*pObjIteJ)->layer() != m_editLayer 
				||(*pObjIteJ)->layer() != nLayer 
				||(*pObjIteJ)->refObj()!=NULL){
				pObjIteJ++;
				continue;
			}
			SPoint pj = (*pObjIteJ)->p1();

			if(p1.x()==p2.x() && p1.x()== pj.x()){
				if( (p1.y() <= pj.y() && p2.y() <= pj.y())
				 || (p1.y() >= pj.y() && p2.y() >= pj.y())){
					pObjIteJ++;
					continue;
				}
			}else if(p1.y()==p2.y() && p1.y()== pj.y()){
				if( (p1.x() <= pj.x() && p2.x() <= pj.x())
				 || (p1.x() >= pj.x() && p2.x() >= pj.x())){
					pObjIteJ++;
					continue;
				}
			}else{
				pObjIteJ++;
				continue;
			}
			SXBSchWire* pWire1 = (SXBSchWire*)((*pObjIte)->duplicate());
			SXBSchWire* pWire2 = (SXBSchWire*)((*pObjIte)->duplicate());
			pWire1->setP2(pj);
			pWire1->setPlaceNum(opCount);
			pWire2->setP1(pj);
			pWire1->setPlaceNum(opCount);
			pWire2->setPlaceNum(opCount);
			SXBSchDelObj* pDelObj = new SXBSchDelObj;		//IuWFNg邽߂̏IuWFNg쐬
			(*pObjIte)->setRefObj(pDelObj);					//IuWFNgɏIuWFNgݒ
			pDelObj->setRefObj(*pObjIte);					//IuWFNgɋIuWFNgݒ
			pDelObj->setPlaceNum(opCount);				
			m_listMain.push_back(pDelObj);
			m_listMain.push_back(pWire1);
			m_listMain.push_back(pWire2);
			break;
		}
		pObjIte++;
		continue;
	}
}






//C[,oX̌
void SXBSchDoc::tidyUpWireBus(SXBSchLine* pObj)
{
	unsigned int targetID = pObj->id();
	bool horz = (pObj->y1() == pObj->y2()); 
	bool vert = (pObj->x1() == pObj->x2());
	if(horz && vert){
		delete pObj;
		return;
	}

	int k,pl,pr,n;
	if(horz){
		k=pObj->y1();
		pl = pObj->x1();
		pr = pObj->x2();
	}else if(vert){
		k=pObj->x1();
		pl = pObj->y1();
		pr = pObj->y2();
	}else{
		m_listMain.push_back(pObj);
		return;
	}
	if(pl>pr){
		n=pl;pl=pr;pr=n;
	}

	int nLayer = pObj->layer();

	
	//TRACE("Start tidyUpWireBus\n");

	bool bExecJoint = true;
	while(bExecJoint){	
		bExecJoint = false;
		XBSchObjListIterator pObjIte = m_listMain.begin();
		while(pObjIte != m_listMain.end()){
			if(   (*pObjIte)->id() == targetID
				//&&(*pObjIte)->layer() == m_editLayer 
				&&(*pObjIte)->layer() == nLayer 
				&&(*pObjIte)->refObj()==NULL){
				int plM,prM;
				SXBSchLine* pObjM = (SXBSchLine*)(*pObjIte);
				if(horz){
					if(pObjM->y1()!=k || pObjM->y2()!=k){
						pObjIte++;
						continue;
					}
					plM = pObjM->x1();
					prM = pObjM->x2();
					if(plM>prM){
						n=plM;plM=prM;prM=n;
					}
					if(prM<pl || pr<plM){
						pObjIte++;
						continue;
					}
					if(plM < pl) pl=plM;
					if(prM > pr) pr=prM;
					SXBSchDelObj* pDelObj = new SXBSchDelObj;		//IuWFNg邽߂̏IuWFNg쐬
					(*pObjIte)->setRefObj(pDelObj);					//IuWFNgɏIuWFNgݒ
					pDelObj->setRefObj(*pObjIte);					//IuWFNgɋIuWFNgݒ
					pDelObj->setPlaceNum(m_nOpCount);				
					m_listMain.push_back(pDelObj);
					bExecJoint = true;
				}else{
					if(pObjM->x1()!=k || pObjM->x2()!=k){
						pObjIte++;
						continue;
					}
					plM = pObjM->y1();
					prM = pObjM->y2();
					if(plM>prM){
						n=plM;plM=prM;prM=n;
					}
					if(prM<pl || pr<plM){
						pObjIte++;
						continue;
					}
					if(plM < pl) pl=plM;
					if(prM > pr) pr=prM;
					SXBSchDelObj* pDelObj = new SXBSchDelObj;		//IuWFNg邽߂̏IuWFNg쐬
					(*pObjIte)->setRefObj(pDelObj);					//IuWFNgɏIuWFNgݒ
					pDelObj->setRefObj(*pObjIte);					//IuWFNgɋIuWFNgݒ
					pDelObj->setPlaceNum(m_nOpCount);				
					m_listMain.push_back(pDelObj);
					bExecJoint = true;
				}
			}
			pObjIte++;
		}
	}
	if(horz){
		pObj->setX1(pl);
		pObj->setX2(pr);
	}else{
		pObj->setY1(pl);
		pObj->setY2(pr);
	}
	m_listMain.push_back(pObj);
}	


//WNVAGg[̏d`FbNs
bool SXBSchDoc::checkRedundancy(SXBSchObj* pObj)
{
	XBSchObjListIterator pObjIte = m_listMain.begin();
	//int nLayer = pObj->layer();
	while(pObjIte != m_listMain.end()){
		if( (*pObjIte)->id() == pObj->id() &&  (*pObjIte)->layer() == pObj->layer()  && (*pObjIte)->refObj()==NULL ) {
			switch((*pObjIte)->id()){
				case SXBSchObj::ID_JUNCTION:
					{
						SXBSchJunc* pObjM = (SXBSchJunc*)(*pObjIte);
						if(pObjM->p1()==pObj->p1()){
							TRACE("checkRedundancyJunction() true\n");
							return true;
						}
					}
					break;
				case SXBSchObj::ID_ENTRY:
				case SXBSchObj::ID_BENTRY:
					{
						SXBSchEntry* pObjM = (SXBSchEntry*)(*pObjIte);
						if(pObjM->p1()==((SXBSchEntry*)pObj)->p1() && pObjM->aspect() == ((SXBSchEntry*)pObj)->aspect()){
							return true;
						}
					}
					break;
			}
		}
		pObjIte++;
	}
	return false;
}


////WNV̏d`FbNs
//bool SXBSchDoc::checkRedundancyJunction(SXBSchJunc* pObj)
//{
//	XBSchObjListIterator pObjIte = m_listMain.begin();
//	int nLayer = pObj->layer();
//	while(pObjIte != m_listMain.end()){
//		if(   (*pObjIte)->id() == SXBSchObj::ID_JUNCTION
//		    //&&(*pObjIte)->layer() == m_editLayer 
//			&&(*pObjIte)->layer() == nLayer 
//			&&(*pObjIte)->refObj()==NULL){
//			SXBSchJunc* pObjM = (SXBSchJunc*)(*pObjIte);
//			if(pObjM->p1()==pObj->p1()){
//				TRACE("checkRedundancyJunction() true\n");
//				return true;
//			}
//		}
//		pObjIte++;
//	}
//	return false;
//}



bool SXBSchDoc::resetSelect_1(bool bDel)
{
	TRACE("SXBSchDoc::resetSelect_1(bool bDel)\n");
	m_selectedTypeFlag = 0;
	//ꎞIuWFNg̃XgȂ牽Ȃ
	if(m_listTemp.size() == 0){
		m_bTempDirty = false;
		m_bTempNewPlace = false;
		return false;
	}

	bool bModifyMain = false;

	XBSchObjListIterator pObjIte;
	discardRedo();

	if(m_bTempNewPlace){
		if(!bDel){		//VKǉf[^tBbNX
			m_nOpCount++;
			bModifyMain = true;
			pObjIte = m_listTemp.begin();
			while(pObjIte != m_listTemp.end()){
				//ꎞf[^C̃Xgɒǉ
				if((*pObjIte)->qValid()){
					(*pObjIte)->setPlaceNum(m_nOpCount);		//ԍXV
					(*pObjIte)->setRefObj(NULL);				//QƃIuWFNg͋ɂiLf[^ɂȂj
					(*pObjIte)->resetSelection();				//ItONAB
					pushBackToMainList(*pObjIte,true);
//20060604					m_listMain.push_back(*pObjIte);
				}
				*pObjIte++;
			}
		}else{			//VKǉf[^폜
			pObjIte = m_listTemp.begin();
			while(pObjIte != m_listTemp.end()){
				delete (*pObjIte);
				*pObjIte++;
			}
		}
		m_listTemp.clear();
		m_bTempDirty = false;
		m_bTempNewPlace = false;
	}else{
		if(!bDel && !m_bTempDirty){	//IAɂȂɂύXȂꍇ
			pObjIte = m_listTemp.begin();
			while(pObjIte != m_listTemp.end()){
				if((*pObjIte)->refObj()){ //ꎞIuWFNgQƃIuWFNgꍇAQƃIuWFNg͌̃f[^wB
					SXBSchObj* pOldObj = (*pObjIte)->refObj();
					pOldObj->setRefObj(NULL);
				}
				delete (*pObjIte);
				*pObjIte++;
			}
			m_listTemp.clear();
			m_bTempDirty = false;
		}else{				//If[^ɕύXꍇ
			m_nOpCount++;
			bModifyMain = true;
			pObjIte = m_listTemp.begin();
			while(pObjIte != m_listTemp.end()){
				if((*pObjIte)->refObj()){ //ꎞIuWFNgQƃIuWFNgꍇAQƃIuWFNg͌̃f[^wB
					SXBSchObj* pOldObj = (*pObjIte)->refObj();
					//폜IuWFNg̒ǉ
					SXBSchDelObj* pDelObj = new SXBSchDelObj;
					//qDebug("Add DeleteObj");
					pDelObj->setPlaceNum(m_nOpCount);	
					pDelObj->setRefObj(pOldObj); //폜IuWFNgrefObj()ɂ͑ΏۃIuWFNgւ̃|C^Zbg
					pOldObj->setRefObj(pDelObj); //̃IuWFNgɂ͍폜IuWFNgւ̃|C^Zbg
					m_listMain.push_back(pDelObj);
				}
				if(!bDel){
					//ꎞf[^C̃Xgɒǉ
					if((*pObjIte)->qValid()){
						(*pObjIte)->setPlaceNum(m_nOpCount);		//ԍXV
						(*pObjIte)->setRefObj(NULL);				//QƃIuWFNg͋ɂiLf[^ɂȂj
						(*pObjIte)->resetSelection();				//ItONAB
						pushBackToMainList(*pObjIte,true);
//20060604						m_listMain.push_back(*pObjIte);
					}
					else{
						//ꎞf[^
						delete (*pObjIte);
					}
				}else{
					//ꎞf[^
					delete (*pObjIte);
				}
				*pObjIte++;
			}
			m_listTemp.clear();
		}
	}

	if(bModifyMain && m_bDoTidyUp){
		tidyUpWireJunction_1(m_nOpCount);
		tidyUpWireJunction_2(m_nOpCount);
		tidyUpWireJunction_3(m_nOpCount);
	}

	m_bSelectForDrag = false;
	m_bTempDirty = false;
	m_bTempNewPlace = false;


	delOldData(m_nOpCount-50);		//Undo񐔂̐
	if(bModifyMain){
		m_bDirty = true;
		return true;
	}else{
		return false;
	}
}


//0.63.02
bool SXBSchDoc::isOnGrid(SPoint pt)
{
	return (pt.x()%10 == 0)&&(pt.y()%10 == 0);
}


//m_rcTempArea  m_ptTempSnapPoint ꎞIuWFNg̃Xgݒ肷B
void SXBSchDoc::setupRcTempArea()
{
	if(m_listTemp.size() == 0)return;
	m_rcTempArea = SRect(SPoint(INT_MAX,INT_MAX),SPoint(INT_MIN,INT_MIN));

	int tempCount = m_listTemp.size();

	XBSchObjListIterator pObjIte = m_listTemp.begin();
	//bool bFind1st = true;
	bool bFindOnGridObject = false;
	while(pObjIte != m_listTemp.end()){
		m_rcTempArea |= (*pObjIte)->area();

		//IIuWFNg̒ɃIObĥ̂΂Xibv|CgƂB0.63.02
		if(!bFindOnGridObject){
			m_ptTempSnapPoint = (*pObjIte)->snapPoint();
			if(isOnGrid(m_ptTempSnapPoint)){
				bFindOnGridObject = true;
			}
		}
		//if(bFind1st){
		//	m_ptTempSnapPoint = (*pObjIte)->snapPoint();
		//	bFind1st = false;
		//}
		pObjIte++;
	}

	//̃ItObhIuWFNg̏ꍇ́AItObhł邱Ƃێ 0.63.02
	if(!bFindOnGridObject && (tempCount>1)){
		m_ptTempSnapPoint.setX((m_ptTempSnapPoint.x()+5)/10*10);
		m_ptTempSnapPoint.setY((m_ptTempSnapPoint.y()+5)/10*10);
	}
}

void SXBSchDoc::setupRotateRect()
{
	if(m_listTemp.size() == 0)return;
	m_rcRotateRect = SRect(SPoint(INT_MAX,INT_MAX),SPoint(INT_MIN,INT_MIN));

	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		m_rcRotateRect |= (*pObjIte)->rotateRect();
		pObjIte++;
	}
	//qDebug("%d,%d\n",m_rcRotateRect.l(),m_rcRotateRect.r());
}



bool SXBSchDoc::writeMinimumLb3(SWriteCE3& wce3,XBSchObjList* pList,bool bOwnOnly)
{
//typedef list<SCompIndex*> SCompIndexList;
//typedef list<SCompIndex*>::iterator SCompIndexListIterator;

	return true;
}


bool SXBSchDoc::writeCe3(SWriteCE3& wce3,XBSchObjList* pList,bool bAllObj,const SPoint* pptOrigin)
{
	SRect rcSheet(0,0,m_sizeSheet.w(),m_sizeSheet.h());
	if(pList){
		XBSchObjListIterator pObjIte = pList->begin();
		while(pObjIte != pList->end()){
			if(bAllObj || !(*pObjIte)->refObj()){
				if(rcSheet.intersect((*pObjIte)->area())){
					(*pObjIte)->writeCe3(wce3,pptOrigin);
				}
			}
			pObjIte++;
		}
	}
	return true;
}


bool SXBSchDoc::readCe3(SReadCE3& rce3,
						XBSchObjList* pList,
						const SPoint* pptOrigin,
						SXBSchSheetInfo* pSheetInfo)
{

	assert(pList!=NULL);
	string str("");
	bool bFirstSheetInfo = true;
	SXBSchObj* pObj;
	while(rce3.ReadRecord(str)!=EOF){
		if(str == "") break;		//̃R[h͖
		pObj = NULL;
		if(str == "+SHEETINFO" && bFirstSheetInfo && pSheetInfo){
			bFirstSheetInfo = false;
			if(! pSheetInfo->readCe3(rce3,pptOrigin,this)) return false;
		}else if(str == "+JUNCTION"){
				pObj = new SXBSchJunc;
		}else if(str == "+LABEL"){
				pObj = new SXBSchLabel;
		}else if(str == "+COMMENT"){
				pObj = new SXBSchComment;
		}else if(str == "+TAG"){
				pObj = new SXBSchTag;
		}else if(str == "+WIRE"){
				pObj = new SXBSchWire;
		}else if(str == "+BUS"){
				pObj = new SXBSchBus;
		}else if(str == "+DASH"){
				pObj = new SXBSchDash;
		}else if(str == "+ALINE"){
				pObj = new SXBSchMarkerLine;
		}else if(str == "+ENTRY"){
				pObj = new SXBSchEntry;
		}else if(str == "+BENTRY"){
				pObj = new SXBSchBusEntry;
		}else if(str == "+COMPONENT"){
				pObj = new SXBSchComponent;
		}else if(str == "+IMAGEOBJECT"){
				pObj = new SXBSchImageObj;
		}else if(str == "-BSCH3_DATA_V.1.0"){
			return true;
		}else{
			if(str[0] != '+') return false;
			str[0]='-';
			if(rce3.SkipTo(str)==EOF) return false;
			//if(rce3.SkipTo(str.replace(1,1,"-")) != SCsvIStream::GETRECORD_NORMAL)return false;
		}
		if(pObj){
			if(pObj->readCe3(rce3,pptOrigin,this)){
				if(pObj->qValid()){
					pList->push_back(pObj);
				}else{
					delete pObj;
				}
			}else{
				delete pObj;
				return false;
			}
		}
	}
	return true;
}





//Ỉ
//ỈƂ́A
//  ꎞf[^w̃IuWFNgwu폜IuWFNgvC̃Xgɒǉ
//                      ꎞf[^C̃Xgɒǉ邱
bool SXBSchDoc::resetSelect()
{
	return resetSelect_1(false);
}


//
void SXBSchDoc::init()
{
	m_bDoTidyUp = true;
	m_bFindCommandActive = false;
	m_bSelectForDrag = false;
	m_bDirty = false;
	m_bTempDirty = false;
	m_bTempNewPlace = false;
	m_nOpCount = 0;
	m_nRedoActive = -1;
	m_nOldestOpCount = 0;
	m_visibleLayer =0xFF;
	m_editLayer = 0;
	m_strFind ="";
	m_bFindMatchWhole = true;
	m_bCaseSeinsitive = true;
	
	

	XBSchObjListIterator pObjIte;

	pObjIte = m_listMain.begin();

	while(pObjIte != m_listMain.end()){
		delete (*pObjIte);
		pObjIte++;
	}
	m_listMain.clear();

 	pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		delete (*pObjIte);
		pObjIte++;
	}
	m_listTemp.clear();
	discardRedo();

//printf("\n");
//printf("SXBSchDoc::init() m_listMain.count()=%d,m_listTemp.count()=%d\n",m_listMain.count(),m_listTemp.count());
}

//t@C̓ǂݍ
//I0Ԃ
//  1:t@Cǂݍ݃G[
//  2:BSCH3t@Cł͂Ȃ
int SXBSchDoc::readFile(FILE* fp)
{
	if(fp ==NULL) return 1;
	SReadCE3 rce3;
	rce3.Attach(fp);

	string str("");
	if(rce3.ReadRecord(str)==EOF){	//̃t@ĈƂ̏
		fclose(fp);
		return 0;
	}
	SXBSchSheetInfo sheetInfo;
	if(str != "+BSCH3_DATA_V.1.0") return 2;
//	if(readCe3(rce3,&m_listMain,NULL,&sheetInfo)){
	m_bTempNewPlace = true;
	if(readCe3(rce3,&m_listTemp,NULL,&sheetInfo)){
		resetSelect_1(false);
		m_sizeSheet.setW(sheetInfo.width());
		m_sizeSheet.setH(sheetInfo.height());
		m_editLayer = sheetInfo.editLayer();
		m_visibleLayer = sheetInfo.visbleLayer();
		m_nOldestOpCount = m_nOpCount;
		m_bDirty = false;
		m_bTempDirty = false;
		return 0;
	}else{
		resetSelect_1(true);
		fclose(fp);
		return 1;
	}
}



int SXBSchDoc::readFile(const char* fname)
{
	init();
	FILE* fp;
	if((fp = fopen(fname,"r"))==NULL) return 1;
	int retval = readFile(fp);
	fclose(fp);
	return retval;
}


int SXBSchDoc::writeFile(FILE* fp)
{
	if(fp ==NULL) return 1;
	SWriteCE3 wce3;
	wce3.Attach(fp);
	SXBSchSheetInfo sheetInfo;
	sheetInfo.setWidth( m_sizeSheet.w() );
	sheetInfo.setHeight( m_sizeSheet.h() );
	sheetInfo.setEditLayer(m_editLayer);
	sheetInfo.setVisbleLayer(m_visibleLayer);

	wce3.WriteRecord("+BSCH3_DATA_V.1.0");
	wce3.WriteEOL();
	sheetInfo.writeCe3(wce3,NULL);
	writeCe3(wce3,&m_listMain,false,NULL);
	wce3.WriteRecord("-BSCH3_DATA_V.1.0");
	if(wce3.WriteEOL()==EOF){
		return 1;
	}else{		
		return 0;
	}
}

//t@Cւ̏
//I0Ԃ
int SXBSchDoc::writeFile(const char* fname)
{
	resetSelect();
	FILE* fp;
	if((fp = fopen(fname,"w"))==NULL) return 1;
	int retval = writeFile(fp);
	fclose(fp);
	if(retval==0){
		init();
		readFile(fname);
	}
	return retval;
}


//폜
//hLgɕύXƂtrueԂ
bool SXBSchDoc::del()
{
	// >>> 2005/01/30 
	//     _[eBtO̐ݒ resetSelect_1()̒ōs悤ɕύX
	//	m_bDirty = true;	
	// <<< 2005/01/30
	return resetSelect_1(true);
}

//؂
//hLgɕύXƂtrueԂ
bool SXBSchDoc::cut()
{
	if(copy()){
		return del();
	}
	return false;
}


//Undo
//hLgɕύXƂtrueԂ
bool SXBSchDoc::undo()
{
//printf("SXBSchDoc::undo() %d %d\n",m_nOpCount, m_nOldestOpCount);
TRACE("SXBSchDoc::undo() %d %d\n",m_nOpCount, m_nOldestOpCount);
	bool bResult = 	resetSelect();
	if(m_nOpCount <= m_nOldestOpCount){
		TRACE("exit undo 1\n");
		return bResult;
	}

	int nCount = m_listMain.size();
	if(nCount==0){
		TRACE("exit undo 2\n");
		return bResult;
	}

	if(m_nRedoActive <0){
		m_nRedoActive = m_nOpCount;
	}

	//폜IuWFNg̕ƁAǉIuWFNg̎OʁXɍs߂
	//m_listMaiñXL2sĂB
	//1̃XLł_̂?

	XBSchObjListIterator pObjIte =m_listMain.begin();
	while(pObjIte!=m_listMain.end()){
		if((*pObjIte)->placeNum() == m_nOpCount){ //UndoΏۂ̃IuWFNgȂ...
			if((*pObjIte)->id() == SXBSchObj::ID_DELETEOBJ){		//   ꂪA폜IuWFNgȂ
				(*pObjIte)->refObj()->setRefObj(NULL);				//		폜IuWFNg̎QƂĂIuWFNg폜Ô
				SRedoInfo redoInfo;
				redoInfo.m_pObj = *pObjIte;
				redoInfo.m_undoCount = m_nOpCount;
				m_stackRedoInfo.push(redoInfo);
				//delete (*pObjIte);									//UndoΏۂ̃IuWFNg
				pObjIte = m_listMain.erase(pObjIte);				//erase()ŃJgm[h͈i
			}else{													
				pObjIte++;
			}
		}else{
			pObjIte++;
		}
	}

	pObjIte =m_listMain.begin();
	while(pObjIte!=m_listMain.end()){
		if((*pObjIte)->placeNum() == m_nOpCount){ //UndoΏۂ̃IuWFNgȂ...
			SRedoInfo redoInfo;
			redoInfo.m_pObj = *pObjIte;
			redoInfo.m_undoCount = m_nOpCount;
			m_stackRedoInfo.push(redoInfo);
			//delete (*pObjIte);										//UndoΏۂ̃IuWFNg
			pObjIte = m_listMain.erase(pObjIte);					//erase()ŃJgm[h͈i
		}else{
			pObjIte++;
		}
	}


	m_nOpCount--;
TRACE("exit undo 3\n");
	return true;
}

bool SXBSchDoc::redo()
{
	if(!canRedo()) return false;
	m_nOpCount++;
	while(!m_stackRedoInfo.empty()){
		SRedoInfo redoInfo = m_stackRedoInfo.top();
		if(redoInfo.m_undoCount!=m_nOpCount) break;
		m_stackRedoInfo.pop();
		SXBSchObj* pObj= redoInfo.m_pObj;
		if(pObj->id()== SXBSchObj::ID_DELETEOBJ){
			pObj->refObj()->setRefObj(pObj);
		}
		m_listMain.push_back(pObj);
	}
	if(m_nRedoActive == m_nOpCount){
		discardRedo();
	}
	return true;
}

void SXBSchDoc::discardRedo()
{
	int count = 0;
	while(!m_stackRedoInfo.empty()){
		SRedoInfo redoInfo = m_stackRedoInfo.top();
		m_stackRedoInfo.pop();
		SXBSchObj* pObj= redoInfo.m_pObj;
		delete pObj;
		count++;
	}

	TRACE("discardRedo() Count:%d  RedoActive:%d\n",count,m_nRedoActive);

	m_nRedoActive = -1;
}

bool SXBSchDoc::canRedo()
{
	return (m_nRedoActive>=0);
}

//i1PƂőIĂ邩
const SXBSchComponent* SXBSchDoc::isComponentSelectedSingly()
{
	int n=m_listTemp.size();
	if(n!=1) return false;
	XBSchObjListIterator pObjIte =m_listTemp.begin();
	if((*pObjIte)->id()==SXBSchObj::ID_COMPONENT){
		return (SXBSchComponent*)(*pObjIte);
	}else{
		return NULL;
	}
}

//J[\ȉɂ邩ǂ
const SXBSchComponent* SXBSchDoc::isOnComponent(const SPoint& pt)
{
	SXBSchObj* pObjSelected = NULL;

	int maxSelectWeight=0;
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(pObjIte !=  m_listMain.end()){
		if( (*pObjIte)->layer() == m_editLayer
		  &&(*pObjIte)->refObj()==NULL	//QƃIuWFNĝ݂͖ł
		  &&(*pObjIte)->id() == SXBSchObj::ID_COMPONENT){
			int SelectWeight = (*pObjIte)->qSelectWeight(pt) & 0xFFFF;
			if(SelectWeight > maxSelectWeight){
				maxSelectWeight = SelectWeight;
				pObjSelected = (*pObjIte);
			}
		}
		pObjIte++;
	}

	pObjIte =m_listTemp.begin();
		while(pObjIte !=  m_listTemp.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_COMPONENT){
			int SelectWeight = (*pObjIte)->qSelectWeight(pt) & 0xFFFF;
			if(SelectWeight > maxSelectWeight){
				maxSelectWeight = SelectWeight;
				pObjSelected = (*pObjIte);
			}
		}
		pObjIte++;
	}

	return(SXBSchComponent*)pObjSelected;
}

void SXBSchDoc::updateSelectedTypeFlag()
{
	m_selectedTypeFlag = 0;
	XBSchObjListIterator  pObjIte =m_listTemp.begin();
	while(pObjIte !=  m_listTemp.end()){
		switch((*pObjIte)->id()){
			case SXBSchObj::ID_TAG:
				m_selectedTypeFlag |= (unsigned)SELECTED_TYPE_TAG;
				break;
			case SXBSchObj::ID_LABEL:
				m_selectedTypeFlag |= (unsigned)SELECTED_TYPE_LABEL;
				break;
			case SXBSchObj::ID_COMMENT:
				m_selectedTypeFlag |= (unsigned)SELECTED_TYPE_COMMENT;
				break;
			case SXBSchObj::ID_COMPONENT:
				m_selectedTypeFlag |= (unsigned)SELECTED_TYPE_COMPONENT;
				break;
			case SXBSchObj::ID_MARKER:
				m_selectedTypeFlag |= (unsigned)SELECTED_TYPE_MARKER;
				break;
		}
		pObjIte++;
	}
}

//p[cIĂ邩
bool SXBSchDoc::isComponentSelected()
{
	if(m_listTemp.size()==0)return false;
	return (m_selectedTypeFlag & (unsigned)SELECTED_TYPE_COMPONENT);
}


//}[J[CIĂ邩
bool SXBSchDoc::isMarkerlineSelected()
{
	if(m_listTemp.size()==0)return false;
	return (m_selectedTypeFlag & (unsigned)SELECTED_TYPE_MARKER);
}

//^OIĂ邩
bool SXBSchDoc::isTagSelected()
{
	if(m_listTemp.size()==0)return false;
	return (m_selectedTypeFlag & (unsigned)SELECTED_TYPE_TAG);
}

//xIĂ邩
bool SXBSchDoc::isLabelSelected()
{
	if(m_listTemp.size()==0)return false;
	return (m_selectedTypeFlag & (unsigned)SELECTED_TYPE_LABEL);
}

//RgIĂ邩
bool SXBSchDoc::isCommentSelected()
{
	if(m_listTemp.size()==0)return false;
	return (m_selectedTypeFlag & (unsigned)SELECTED_TYPE_COMMENT);
}


//AttributeύX\?
bool SXBSchDoc::canAttribute()
{
	int n=m_listTemp.size();
	if(n!=1) return false;
	XBSchObjListIterator pObjIte =m_listTemp.begin();
	return (*pObjIte)->canAttribute();
}

//Rs[\H
bool SXBSchDoc::canCopy()
{
	return (m_listTemp.size()>0);
}

//폜\H
bool SXBSchDoc::canDel()
{
	return (m_listTemp.size()>0);
}

//؂\H
bool SXBSchDoc::canCut()
{
	return (m_listTemp.size()>0);
}


//Undo\H
bool SXBSchDoc::canUndo()
{
	return (m_nOpCount > m_nOldestOpCount);
}



//Rotate
bool SXBSchDoc::rotate()
{
	if(!canRotate()) return false;

	setupRotateRect();

	int n = m_listTemp.size();
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	if(n == 1){
		(*pObjIte)->rotate();
	}else{
		SPoint ptCenter = m_rcRotateRect.center();
		ptCenter.setX(((ptCenter.x()+5)/10)*10);
		ptCenter.setY(((ptCenter.y()+5)/10)*10);
		//int x=(m_rcRotateRect.l()+m_rcRotateRect.r())/2;
		//int y=(m_rcRotateRect.t()+m_rcRotateRect.bottom())/2;
		//SPoint ptCenter(x,y);
		while(pObjIte != m_listTemp.end()){
			(*pObjIte)->rotate(ptCenter);
			pObjIte++;
		}
	}
	setupRcTempArea();

	// >>> 2005/01/30 
	//	Ŝꎞf[^̃_[eBɕύX
	//m_bDirty = true;
	m_bTempDirty = true;
	// <<< 2005/01/30 
	
	return true;
}

//C[̈ړ
bool SXBSchDoc::moveToLayer(int nLayer)
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		(*pObjIte)->setLayer(nLayer);
		pObjIte++;
	}
	// >>> 2005/01/30 
	//	Ŝꎞf[^̃_[eBɕύX
	//m_bDirty = true;
	m_bTempDirty = true;
	// <<< 2005/01/30 
	return true;
}


//Mirror
bool SXBSchDoc::mirror()
{
	if(!canMirror()) return false;

	setupRotateRect();

	int n = m_listTemp.size();
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	if(n == 1){
		(*pObjIte)->mirrorH();
	}else{
		int nCenter = (m_rcRotateRect.l()+m_rcRotateRect.r())/2;
		while(pObjIte != m_listTemp.end()){
			(*pObjIte)->mirrorH(nCenter);
			pObjIte++;
		}
	}
	setupRcTempArea();

	// >>> 2005/01/30 
	//	Ŝꎞf[^̃_[eBɕύX
	//m_bDirty = true;
	m_bTempDirty = true;
	// <<< 2005/01/30 
	return true;
}


//Rotate\H
bool SXBSchDoc::canRotate()
{
	//if(m_bSelectForDrag) return false;

	int n=m_listTemp.size();
	if(n==0) return false;
	if(n==1){
		XBSchObjListIterator pObjIte =m_listTemp.begin();
		return (*pObjIte)->canRotateSingleSelected();
	}
	return true;
}

//Mirror\H
bool SXBSchDoc::canMirror()
{
	//if(m_bSelectForDrag) return false;

	int n=m_listTemp.size();
	if(n==0) return false;
	if(n==1){
		XBSchObjListIterator pObjIte =m_listTemp.begin();
		return (*pObjIte)->canMirrorSingleSelected();
	}
	return true;
}



//Âf[^̍폜
//   C̃Xg̐擪XLāAw肵l̑JEgl
// 菬Ȓlł̍폜sIuWFNgB
//   폜IuWFNgƂɑΉ폜IuWFNg̃Xgł
// ʒuɒڂƁAȂ炸A폜IuWFNg̕擪ɋ߂
// ɑ݂B
void SXBSchDoc::delOldData(int nOpCount)
{
	bool bDel;
	resetSelect();
	if(nOpCount <= m_nOldestOpCount) return;
	
	int nDelObj=0;
	int nDelDelObj=0;


	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(pObjIte!=m_listMain.end()){
		bDel = false;
		if((*pObjIte)->id() != SXBSchObj::ID_DELETEOBJ){
			if((*pObjIte)->refObj()!=NULL){
				SXBSchObj* pDelObj = (*pObjIte)->refObj();
				if(pDelObj->placeNum() < nOpCount){
					bDel = true;
					nDelObj++;
				}
			}
		}else{
			if((*pObjIte)->placeNum() < nOpCount){
				bDel = true;
				nDelDelObj++;
			}
		}
		if(bDel){
			delete (*pObjIte);						//UndoΏۂ̃IuWFNg
			pObjIte = m_listMain.erase(pObjIte);	//erase()ŃJgm[h͈i
		}else{
			pObjIte++;
		}
	}
	if(nOpCount > m_nOpCount) nOpCount = m_nOpCount;
	m_nOldestOpCount = nOpCount;



	return;
}

//w肵Wꎞf[^̏ォǂ
int SXBSchDoc::isOnTempData(const SPoint& pt)
{
	if(m_listTemp.size() == 0) return 0;
	if((m_listTemp.size() == 1)&&(m_bSelectForDrag==false)){
		XBSchObjListIterator pObjIte = m_listTemp.begin();
		int val= (*pObjIte)->qSelectWeight(pt) & (ON_OBJ|ON_NAME|ON_NUM|ON_COMMENTWIDTH);
		if(val)return val;
	}
	if(m_rcTempArea.intersect(pt)) 	return ON_OBJ;
	return 0;
}

//ꎞf[^ړ
void SXBSchDoc::moveTempData(int offsetx,int offsety)
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		(*pObjIte)->move(offsetx,offsety);
		pObjIte++;
	}
	m_rcTempArea+=SPoint(offsetx,offsety);
	m_ptTempSnapPoint.setX(m_ptTempSnapPoint.x()+offsetx);
	m_ptTempSnapPoint.setY(m_ptTempSnapPoint.y()+offsety);
	// >>> 2005/01/30 
	//	Ŝꎞf[^̃_[eBɕύX
	//m_bDirty = true;
	m_bTempDirty = true;
	// <<< 2005/01/30 
}

//w肵_ɃsAWNV[C[zu
bool SXBSchDoc::selectForDragPin(int scanMax,const SPoint pt)
{
//	if(!m_bDoTidyUp) return false;
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(scanMax>0 && pObjIte != m_listMain.end()){
		if(   (*pObjIte)->layer() == m_editLayer
		   //&& (*pObjIte)->id()!=SXBSchObj::ID_JUNCTION
		   && (*pObjIte)->id()!=SXBSchObj::ID_WIRE
		   && (*pObjIte)->refObj()==NULL){	//QƃIuWFNĝ݂͖ł
			bool bFind = false;
			if((*pObjIte)->id()==SXBSchObj::ID_JUNCTION){
				if((*pObjIte)->p1()==pt){
					bFind = true;
				}
			}else{
				int pincount=(*pObjIte)->pinCount();
				for(int n=0;n<pincount;n++){
					SPoint pinpt=(*pObjIte)->pinPosition(n);
					if(pinpt == pt){
						bFind = true;
						break;
					}
				}
			}
			if(bFind){
				SXBSchWire* pWire = new SXBSchWire;
				pWire->setP1(pt);
				pWire->setP2(pt);
				pWire->setLayer(m_editLayer);
				pWire->setSelection(SXBSchObj::SELECT_P1);
				m_listWorkWire.push_back(pWire);
				return true;
			}
		}
		pObjIte++;
		scanMax--;
	}
	return false;
}

//͈͓̐ڍ_̑I
void SXBSchDoc::selectForDragJunction(int scanMax,const SRect& rc)
{
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(scanMax>0 && pObjIte != m_listMain.end()){
		if(   (*pObjIte)->layer() == m_editLayer
		   && (*pObjIte)->id()==SXBSchObj::ID_JUNCTION 
		   && (*pObjIte)->refObj()==NULL){	//QƃIuWFNĝ݂͖ł
			unsigned nSelStatus = (*pObjIte)->testSelectionForDrag(rc);
			if(nSelStatus){
				SXBSchObj* pNewObj = (*pObjIte)->duplicate();	//IIuWFNg̕
				(*pObjIte)->setRefObj(pNewObj);					//IuWFNgɕIuWFNgݒ
				pNewObj->setRefObj(*pObjIte);					//VIuWFNgɌIuWFNgݒ
				pNewObj->setSelection(nSelStatus);				//VIuWFNgɑItOݒ
				m_listTemp.push_back(pNewObj);					//VIuWFNgꎞf[^ɕۊ
			}
		}
		*pObjIte++;
		scanMax--;
	}
}

//ׂĂ̐ڍ_ m_listWorkJunc ɒoB
void SXBSchDoc::pickupJunction(const SRect& )
{
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(pObjIte != m_listMain.end()){
		if(    (*pObjIte)->layer() == m_editLayer  
			&& (*pObjIte)->id()==SXBSchObj::ID_JUNCTION 
			&& (*pObjIte)->refObj()==NULL){	//QƃIuWFNĝ݂͖ł
			m_listWorkJunc.push_back(*pObjIte);					//IO̐ڍ_ƃGAɕۊ
		}
		*pObjIte++;
	}
}


void SXBSchDoc::setNcPinFlag()
{
	TRACE("**SXBSchDoc::setNcPinFlag()**\n");

	SPointList	wireEndList;
	SPoint pt;
	//ׂẴC[̒[_̗
	//NCstÕvZbg
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(pObjIte != m_listMain.end()){
		if((*pObjIte)->refObj()!=NULL){

		}else if((*pObjIte)->id()==SXBSchObj::ID_WIRE){
			pt=(*pObjIte)->p1();
			wireEndList.push_back(pt);
			pt=(*pObjIte)->p2();
			wireEndList.push_back(pt);
		}else if((*pObjIte)->id()==SXBSchObj::ID_COMPONENT){
			SXBSchComponent* pComp =(SXBSchComponent*)(*pObjIte);
			pComp->presetPinNC();
		}
		*pObjIte++;
	}

	pObjIte = m_listMain.begin();
	while(pObjIte != m_listMain.end()){
		if((*pObjIte)->refObj()==NULL && (*pObjIte)->id()==SXBSchObj::ID_COMPONENT){
			SXBSchComponent* pComp1 =(SXBSchComponent*)(*pObjIte);
			int pinCount = pComp1->pinCount();
			int i;
			for(i=0;i<pinCount;i++){
				if(!pComp1->pinNC(i)) continue;
				SPoint ptPinEnd = pComp1->pinPosition(i);
				SPointListIterator ptIte = wireEndList.begin();
				//C[[_Ƃ̏ƍ
				while(ptIte != wireEndList.end()){
					if(ptPinEnd == (*ptIte)){
						pComp1->setPinNC(i,false);
						break;
					}
					ptIte++;
				}
				//sm̏ƍ
				XBSchObjListIterator pObjIte2nd = pObjIte;
				pObjIte2nd++;
				while(pObjIte2nd != m_listMain.end()){
					if((*pObjIte2nd)->refObj()!=NULL){

					}else if((*pObjIte2nd)->id()==SXBSchObj::ID_COMPONENT){
						SXBSchComponent* pComp2 =(SXBSchComponent*)(*pObjIte2nd);
						int pinCount2nd = pComp2->pinCount();
						int j;
						for(j=0;j<pinCount2nd;j++){
							if(ptPinEnd == pComp2->pinPosition(j)){
								pComp1->setPinNC(i,false);
								pComp2->setPinNC(j,false);
								break;
							}
						}
					}else if((*pObjIte2nd)->id()==SXBSchObj::ID_TAG){
						SXBSchTag* pTag=(SXBSchTag*)(*pObjIte2nd);
						if(ptPinEnd == pTag->pinPosition(0)){
								pComp1->setPinNC(i,false);
						}else if(ptPinEnd == pTag->pinPosition(1)){
								pComp1->setPinNC(i,false);
						}
					}
					pObjIte2nd++;
				}
			}		
		}
		pObjIte++;
	}
}


//hbÔ߂̐ڍ_C[ȊȎI
void SXBSchDoc::selectForDragExceptJuncWire(int scanMax,const SRect& rc)
{
	int scan=0;
	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(scan<scanMax && pObjIte != m_listMain.end()){
		if( (*pObjIte)->layer() == m_editLayer
		  &&(*pObjIte)->id()!=SXBSchObj::ID_JUNCTION 
		  &&(*pObjIte)->id()!=SXBSchObj::ID_WIRE
		  &&(*pObjIte)->refObj()==NULL){
			unsigned nSelStatus = (*pObjIte)->testSelectionForDrag(rc);
			if(nSelStatus){
				SXBSchObj* pNewObj = (*pObjIte)->duplicate();	//IIuWFNg̕
				(*pObjIte)->setRefObj(pNewObj);					//IuWFNgɕIuWFNgݒ
				pNewObj->setRefObj(*pObjIte);					//VIuWFNgɌIuWFNgݒ
				pNewObj->setSelection(nSelStatus);				//VIuWFNgɑItOݒ
				m_listTemp.push_back(pNewObj);					//VIuWFNgꎞf[^ɕۊ
				if(pNewObj->id()==SXBSchObj::ID_TAG || pNewObj->id()==SXBSchObj::ID_COMPONENT){
					m_listWorkTagComponent.push_back(pNewObj);
				}
			}
		}
		*pObjIte++;
		scan++;
	}
}

//̑IɁAVȔ͈͂ǉIꂽ^OAĩsɐڑꂽI[_Ȃ`FbN
void SXBSchDoc::selectForDragReCheckSelectedLine(const SRect& rc)
{
	XBSchObjListIterator pTempObjIte = m_listTemp.begin();
	while(pTempObjIte != m_listTemp.end()){
		if( (*pTempObjIte)->id()==SXBSchObj::ID_WIRE || 
			(*pTempObjIte)->id()==SXBSchObj::ID_BUS  || 
			(*pTempObjIte)->id()==SXBSchObj::ID_DASH ||
			(*pTempObjIte)->id()==SXBSchObj::ID_MARKER){

			unsigned selFlag = (*pTempObjIte)->selection();
			unsigned newFlag = (*pTempObjIte)->testSelectionForDrag(rc);
			(*pTempObjIte)->setSelection(selFlag | newFlag);
		}
		pTempObjIte++;
	}



	XBSchObjListIterator pObjIte = m_listWorkTagComponent.begin();
	while(pObjIte != m_listWorkTagComponent.end()){
		int pincount=(*pObjIte)->pinCount();
		for(int n=0;n<pincount;n++){
			SPoint point=(*pObjIte)->pinPosition(n);
			pTempObjIte = m_listTemp.begin();
			while(pTempObjIte != m_listTemp.end()){
				if((*pTempObjIte)->id()==SXBSchObj::ID_WIRE){
					unsigned selFlag = (*pTempObjIte)->selection();
					if(((selFlag & SXBSchObj::SELECT_P1)==0) && (*pTempObjIte)->p1()==point){
						selFlag |= SXBSchObj::SELECT_P1;
					}
					if(((selFlag & SXBSchObj::SELECT_P2)==0) && (*pTempObjIte)->p2()==point){
						selFlag |= SXBSchObj::SELECT_P2;
					}
					(*pTempObjIte)->setSelection(selFlag);
				}

				pTempObjIte++;
			}
		}
		pObjIte++;
	}
}


//hbÔ߂̃sI
void SXBSchDoc::selectForDragPinConnection(int scanMax,const SRect& rrc,bool bCutOffPinWire)
{
	SRect rc;
	rc.setL(rrc.l()+14);
	rc.setT(rrc.t()+14);
	rc.setR(rrc.r()-14);
	rc.setB(rrc.b()-14);


	//I͈͊O̕iƐڑĂ\̂|Cg񋓂B
	SPointEmum pointEnum;
	SPoint point;
	
	XBSchObjListIterator pObjIte;

	if(!bCutOffPinWire){
		pObjIte = m_listWorkWire.begin();
		while(pObjIte != m_listWorkWire.end()){
			unsigned selflag = (*pObjIte)->selection();
			if(selflag & SXBSchObj::SELECT_P1){
				point = (*pObjIte)->p1();
				if(!rc.intersect(point)){
					pointEnum.addSPoint(point);
				}
			}
			if(selflag & SXBSchObj::SELECT_P2){
				point = (*pObjIte)->p2();
				if(!rc.intersect(point)){
					pointEnum.addSPoint(point);
				}
			}
			pObjIte++;
		}
	}

	int tempSize = m_listTemp.size();
//	pObjIte = m_listTemp.begin();
//	while(pObjIte != m_listTemp.end()){

	pObjIte = m_listWorkTagComponent.begin();
	while(pObjIte != m_listWorkTagComponent.end()){
		//if( (*pObjIte)->id()==SXBSchObj::ID_COMPONENT 
		//	||(*pObjIte)->id()==SXBSchObj::ID_TAG
		//	){
			int pincount=(*pObjIte)->pinCount();
			for(int n=0;n<pincount;n++){
				point=(*pObjIte)->pinPosition(n);
				if(!rc.intersect(point)){
					pointEnum.addSPoint(point);
				}
			}
		//}
		pObjIte++;
	}


	SPointListIterator itePoint=pointEnum.m_list.begin();
	while(itePoint!=pointEnum.m_list.end()){
		point = (*itePoint); 

		if(m_bDoTidyUp){
			if(!selectForDragPin(scanMax,point)){
				SRect rcPin(point,point);
				selectForDragWire(scanMax,rcPin);
			}
		}else{
			SRect rcPin(point,point);
			selectForDragJunction(scanMax,rcPin);
			selectForDragWire(scanMax,rcPin);
		}
		itePoint++;
	}

//	int tempSize = m_listTemp.size();
//	XBSchObjListIterator pObjIte = m_listTemp.begin();
//	int scan = 0;
//	while(scan<tempSize && pObjIte != m_listTemp.end()){
//		if( (*pObjIte)->id()!=SXBSchObj::ID_JUNCTION 
//			&&(*pObjIte)->id()!=SXBSchObj::ID_WIRE){
//
//			int pincount=(*pObjIte)->pinCount();
//			//qDebug("SXBSchDoc::selectForDragExceptJuncWire()  PINCOUNT=%d",pincount);
//			for(int n=0;n<pincount;n++){
//				SPoint pt=(*pObjIte)->pinPosition(n);
//				if(!rc.intersect(pt)){
//					if(m_bDoTidyUp){
//						if(!selectForDragPin(scanMax,pt)){
//							SRect rcPin(pt,pt);
//							//selectForDragJunction(scanMax,rcPin);
//							selectForDragWire(scanMax,rcPin);
//						}
//					}else{
//						SRect rcPin(pt,pt);
//						selectForDragJunction(scanMax,rcPin);
//						selectForDragWire(scanMax,rcPin);
//					}
//				}
//			}
//		}
//		pObjIte++;
//		scan++;
//	}
}


//hbÔ߂̃C[IB
void SXBSchDoc::selectForDragWire(int scanMax,const SRect& rc)
{
	SXBSchWire* pNewWire[5];

	int workWireCount= m_listWorkWire.size();	//m_listWorkWire͑邪A rcŒǉ͍̂ăXLȂB
												//selectForDragōŏ͈͎̔wł̃C[IłworkWireCount0ɂȂB

	XBSchObjListIterator pObjIte = m_listMain.begin();
	while(scanMax>0 && pObjIte != m_listMain.end()){
		if( (*pObjIte)->layer() == m_editLayer
		  &&(*pObjIte)->id()==SXBSchObj::ID_WIRE 
		  &&(*pObjIte)->refObj()==NULL){	//QƃIuWFNĝ݂͖ł
			SXBSchWire* pObj= (SXBSchWire*)(*pObjIte);
			int divcount = divideWire(pObj,rc,pNewWire);
			if(divcount>0){
				SXBSchDelObj* pDelObj = new SXBSchDelObj;		//IuWFNg邽߂̏IuWFNg쐬
				(*pObjIte)->setRefObj(pDelObj);					//IuWFNgɏIuWFNgݒ
				pDelObj->setRefObj(*pObjIte);					//IuWFNgɋIuWFNgݒ
				pDelObj->setPlaceNum(m_nOpCount+1);				
				pushBackToMainList(pDelObj,false);
//20060604				m_listMain.push_back(pDelObj);					//IuWFNgCf[^ɕۊ
				for(int n=0;n<divcount;n++){
					m_listWorkWire.push_back(pNewWire[n]);
				}
			}
		}
		pObjIte++;
		scanMax--;
	}

	pObjIte = m_listWorkWire.begin();
	while(workWireCount>0 && pObjIte != m_listWorkWire.end()){
		if((*pObjIte)->refObj()==NULL){	//QƃIuWFNĝ݂͖ł
			SXBSchWire* pObj= (SXBSchWire*)(*pObjIte);
			int divcount = divideWire(pObj,rc,pNewWire);
			if(divcount>0){
				(*pObjIte)->setRefObj(pNewWire[0]);
				for(int n=0;n<divcount;n++){
					m_listWorkWire.push_back(pNewWire[n]);
				}
			}
		}
		pObjIte++;
		workWireCount--;
	}

}


//hbOIł̓C[̕duplicate()ł͂ȂAdivideWire()ōsB
// ꂽIuWFNgɂ͑ItOݒ肳B
//C[hbOΏۂłȂꍇ͕ȂB
//hbOΏۂƔhbOΏۂɕꍇ̓hbOΏۂ̂̂擪Ɋi[B
int SXBSchDoc::divideWire(SXBSchWire* swire,const SRect& rc,SXBSchWire** dwire)
{
	int retval=0;
	bool vFlag;
	int fixval,jfix,jp;
	int p0,p1,p2,p3,p4,p5;
	int	boundaryMin,boundaryMax;
	unsigned int nSelStatus;
	unsigned int nOldSelStatus;
	int nLayer = swire->layer();

	if(!swire->qValid()) return 0;

	nOldSelStatus = (swire->selection() & (SXBSchObj::SELECT_P1|SXBSchObj::SELECT_P2));
	nSelStatus = swire->testSelectionForDrag(rc);

	//xÎăXL邷ꍇ̃`FbN
	if(nOldSelStatus){
		swire->setSelection(nOldSelStatus | nSelStatus);
		return 0;
	}

	nSelStatus = swire->testSelectionForDrag(rc);
	if((nSelStatus&(SXBSchObj::SELECT_P1|SXBSchObj::SELECT_P2)) ==SXBSchObj::SELECT_ALL){	//[_͈͓̂Ƃ
		dwire[0] = (SXBSchWire*)(swire->duplicate());
		dwire[0]->setSelection(nSelStatus);
		return 1;
	}
	if(swire->x1()==swire->x2()){	//̂Ƃ
		if(swire->x1()<rc.l() || swire->x1()>rc.r()) return 0;	//E͈͊O
		if(swire->y1()<rc.t() && swire->y2()<rc.t()) return 0;	//ɔ͈͊O
		if(swire->y1()>rc.b() && swire->y2()>rc.b()) return 0;	//ɔ͈͊O
		vFlag = true;
		fixval = swire->x1();
		p0 = swire->y1();
		p5 = swire->y2();
		boundaryMin = rc.t();
		boundaryMax = rc.b();
	}else if(swire->y1()==swire->y2()){	//̂Ƃ
		if(swire->y1()<rc.t() || swire->y1()>rc.b()) return 0;	//㉺͈͊O
		if(swire->x1()<rc.l() && swire->x2()<rc.l()) return 0;	//ɔ͈͊O
		if(swire->x1()>rc.r() && swire->x2()>rc.r()) return 0;	//Eɔ͈͊O
		vFlag = false;
		fixval = swire->y1();
		p0 = swire->x1();
		p5 = swire->x2();
		boundaryMin = rc.l();
		boundaryMax = rc.r();
	}else{	//΂ߐ̂Ƃ͕ȂB
		if(nSelStatus!=0){
			dwire[0]=(SXBSchWire*)(swire->duplicate());
			dwire[0]->setSelection(nSelStatus);
			return 1;
		}else{
			return 0;
		}
	}
	if(p0>p5){ int i=p5; p5=p0; p0=i; }

	p3=p1=p0;
	p2=p4=p5;

	if(p0>=boundaryMin) p2=p0;
	if(p5<=boundaryMax) p3=p5;
	XBSchObjListIterator pObjIte = m_listWorkJunc.begin();
	while(pObjIte != m_listWorkJunc.end()){
		SXBSchJunc* pJunc = (SXBSchJunc*)(*pObjIte);
		if(vFlag){  jfix = pJunc->x1();	jp	 = pJunc->y1();	}
		else{		jfix = pJunc->y1();	jp	 = pJunc->x1();	}
		if(jfix==fixval && jp>p1 && jp<p4){
			if(jp<boundaryMin){			//p1XV`FbN(boundaryMin菬čő)
				p1=jp;
			}else if(jp>boundaryMax){	//p4XV`FbN(boundaryMax傫čŏ)
				p4=jp;
			}else{	//ڍ_͔͈͓
				if(jp>p3) p3=jp;
				if(jp<p2) p2=jp;
			}
		}
		pObjIte++;
	}
	if(p2>p3){//͈͓ɒ[_ڍ_Ȃꍇ͕Ȃ
		return 0;
	}
	if(p2<p3){//͈͓ɗ[_C[
		dwire[retval]=new SXBSchWire;
		if(vFlag){
			dwire[retval]->setP1(SPoint(fixval,p2));
			dwire[retval]->setP2(SPoint(fixval,p3));
		}else{
			dwire[retval]->setP1(SPoint(p2,fixval));
			dwire[retval]->setP2(SPoint(p3,fixval));
		}
		dwire[retval]->setSelection(SXBSchObj::SELECT_ALL);
		dwire[retval]->setLayer(nLayer);
		retval++;
	}
	if(p1<p2){//͈͓P2[_C[
		dwire[retval]=new SXBSchWire;
		if(vFlag){
			dwire[retval]->setP1(SPoint(fixval,p1));
			dwire[retval]->setP2(SPoint(fixval,p2));
		}else{
			dwire[retval]->setP1(SPoint(p1,fixval));
			dwire[retval]->setP2(SPoint(p2,fixval));
		}
		dwire[retval]->setSelection(SXBSchObj::SELECT_P2);
		dwire[retval]->setLayer(nLayer);
		retval++;
	}
	if(p3<p4){//͈͓P1[_C[
		dwire[retval]=new SXBSchWire;
		if(vFlag){
			dwire[retval]->setP1(SPoint(fixval,p3));
			dwire[retval]->setP2(SPoint(fixval,p4));
		}else{
			dwire[retval]->setP1(SPoint(p3,fixval));
			dwire[retval]->setP2(SPoint(p4,fixval));
		}
		dwire[retval]->setSelection(SXBSchObj::SELECT_P1);
		dwire[retval]->setLayer(nLayer);
		retval++;
	}
	if(p0<p1){//͈͊OɃC[
		dwire[retval]=new SXBSchWire;
		if(vFlag){
			dwire[retval]->setP1(SPoint(fixval,p0));
			dwire[retval]->setP2(SPoint(fixval,p1));
		}else{
			dwire[retval]->setP1(SPoint(p0,fixval));
			dwire[retval]->setP2(SPoint(p1,fixval));
		}
		dwire[retval]->setLayer(nLayer);
		retval++;
	}
	if(p4<p5){//͈͊OɃC[
		dwire[retval]=new SXBSchWire;
		if(vFlag){
			dwire[retval]->setP1(SPoint(fixval,p4));
			dwire[retval]->setP2(SPoint(fixval,p5));
		}else{
			dwire[retval]->setP1(SPoint(p4,fixval));
			dwire[retval]->setP2(SPoint(p5,fixval));
		}
		dwire[retval]->setLayer(nLayer);
		retval++;
	}
	return retval;
}


int SXBSchDoc::selectForDrag(const SRect& rc,bool bCutOffPinWire)
{
	//ꎞf[^̉
	//resetSelect();

	bool bAppendSelect = (m_listTemp.size()>0);

	m_listWorkJunc.clear();
	m_listWorkWire.clear();
	m_listWorkTagComponent.clear();

	int scanMax = m_listMain.size();

	//ڍ_̑Iƒo
	pickupJunction(rc);
	selectForDragJunction(scanMax,rc);

	//C[̑I
	//͈͓Oɂ܂̂̓WNVɂ镪s
	selectForDragWire(scanMax,rc);

	//ڍ_AC[ȊȎI
	selectForDragExceptJuncWire(scanMax,rc);


	//̑IɁAVȔ͈͂ǉIꂽ^OAĩsɐڑꂽI[_Ȃ`FbN
	if(bAppendSelect){
		selectForDragReCheckSelectedLine(rc);
	}




	//sɐڑꂽC[̑I
	selectForDragPinConnection(scanMax,rc,bCutOffPinWire);

	
	XBSchObjListIterator pObjIte = m_listWorkWire.begin();
	while(pObjIte != m_listWorkWire.end()){
		if((*pObjIte)->refObj()==NULL){	//QƃIuWFNgȂ̂L
			if((*pObjIte)->selection()!=0){	//ItOtĂ͈̂ꎞf[^ɃRs[
				m_listTemp.push_back(*pObjIte);
			}else{
				(*pObjIte)->setPlaceNum(m_nOpCount+1);
				pushBackToMainList(*pObjIte,false);
//20060603				m_listMain.push_back(*pObjIte);
			}
		}else{
			delete(*pObjIte);
		}
		pObjIte++;
	}
	

	
	setupRcTempArea();
	setupRotateRect();
	m_listWorkJunc.clear();
	m_listWorkWire.clear();
	m_listWorkTagComponent.clear();

	int nSelectCount = m_listTemp.size();
	if(nSelectCount >0){
		m_bSelectForDrag = true;
		m_bTempDirty = true;
		m_bFindCommandActive = false;
		discardRedo();
	}else{
		m_bSelectForDrag = false;
	}
	return nSelectCount;
//	m_bSelectForDrag = true;
//	return m_listTemp.size();
}

bool SXBSchDoc::findStringCompare(const char* szTarget,const char* sz,bool bMatchWhole,bool bCaseSensitive)
{
	if(szTarget==NULL || sz==NULL)return false;
	if(*szTarget=='\0' || *sz=='\0') return false;

	if(bMatchWhole){
		return !(strcmp(szTarget,sz));
	}else{
		return (strstr(szTarget,sz)!=NULL);
	}
}

bool SXBSchDoc::findStart(const char* sz,bool bMatchWhole,bool bCaseSeinsitive,unsigned int targetFlags)
{
	resetSelect();
	m_strFind = sz;
	m_bFindMatchWhole = bMatchWhole;
	m_bCaseSeinsitive = bCaseSeinsitive;
	m_nTargetFlags = targetFlags;
	return find(true);
}

bool SXBSchDoc::find(bool bStart /*=false*/)
{
	SXBSchObj* pObj = NULL;
	SXBSchObj* pObjSelected = NULL;
	resetSelect();

	if(bStart){
	    m_reviteFind = m_listMain.rbegin();
		m_bFindCommandActive = true;
	}else{
		if(!m_bFindCommandActive)return false;
		m_reviteFind++;
	}

	while(m_reviteFind != m_listMain.rend()){
		if( (*m_reviteFind)->layer() == m_editLayer
		  &&(*m_reviteFind)->refObj()==NULL){	//QƃIuWFNĝ݂͖ł
			pObj = *m_reviteFind;
			int nId = pObj->id();
			switch(nId){
				case SXBSchObj::ID_COMPONENT:
					if(m_nTargetFlags & FINDTGT_NAME){
						if(findStringCompare(((SXBSchComponent*)pObj)->name(),m_strFind.c_str(),m_bFindMatchWhole,m_bCaseSeinsitive)){
							pObjSelected = pObj;
							break;
						}
					}
					if(m_nTargetFlags & FINDTGT_NAMELIB){
						if(findStringCompare(((SXBSchComponent*)pObj)->orgname(),m_strFind.c_str(),m_bFindMatchWhole,m_bCaseSeinsitive)){
							pObjSelected = pObj;
							break;
						}
					}
					if(m_nTargetFlags & FINDTGT_NUM){
						if(findStringCompare(((SXBSchComponent*)pObj)->refnum(),m_strFind.c_str(),m_bFindMatchWhole,m_bCaseSeinsitive)){
							pObjSelected = pObj;
							break;
						}
					}
					if(m_nTargetFlags & FINDTGT_MANUFACTURE){
						if(findStringCompare(((SXBSchComponent*)pObj)->mfr(),m_strFind.c_str(),m_bFindMatchWhole,m_bCaseSeinsitive)){
							pObjSelected = pObj;
							break;
						}
					}
					if(m_nTargetFlags & FINDTGT_MANUFACTUREPN){
						if(findStringCompare(((SXBSchComponent*)pObj)->mfrpnum(),m_strFind.c_str(),m_bFindMatchWhole,m_bCaseSeinsitive)){
							pObjSelected = pObj;
							break;
						}
					}
					if(m_nTargetFlags & FINDTGT_PACKAGE){
						if(findStringCompare(((SXBSchComponent*)pObj)->packagename(),m_strFind.c_str(),m_bFindMatchWhole,m_bCaseSeinsitive)){
							pObjSelected = pObj;
							break;
						}
					}
					if(m_nTargetFlags & FINDTGT_NOTE){
						if(findStringCompare(((SXBSchComponent*)pObj)->note(),m_strFind.c_str(),m_bFindMatchWhole,m_bCaseSeinsitive)){
							pObjSelected = pObj;
							break;
						}
					}


					break;
				case SXBSchObj::ID_TAG:
					if(m_nTargetFlags & FINDTGT_TAG){
						if(findStringCompare(((SXBSchTag*)pObj)->text(),m_strFind.c_str(),m_bFindMatchWhole,m_bCaseSeinsitive)){
							pObjSelected = pObj;
							break;
						}
					}
					break;
				case SXBSchObj::ID_LABEL:
					if(m_nTargetFlags & FINDTGT_LABEL){
						if(findStringCompare(((SXBSchLabel*)pObj)->text(),m_strFind.c_str(),m_bFindMatchWhole,m_bCaseSeinsitive)){
							pObjSelected = pObj;
							break;
						}
					}
					break;
				case SXBSchObj::ID_COMMENT:
					if(m_nTargetFlags & FINDTGT_COMMENT){
						if(findStringCompare(((SXBSchComment*)pObj)->text(),m_strFind.c_str(),m_bFindMatchWhole,m_bCaseSeinsitive)){
							pObjSelected = pObj;
							break;
						}
					}
					break;
				default:
					break;
			}
		}
		if(pObjSelected != NULL) break;
		m_reviteFind++;
	}
	if(pObjSelected != NULL){
		SXBSchObj* pNewObj = pObjSelected->duplicate();
		pObjSelected->setRefObj(pNewObj);
		pNewObj->setRefObj(pObjSelected);
		pNewObj->setSelection(SXBSchObj::SELECT_ALL);
		m_listTemp.push_back(pNewObj);
	}else{
		m_bFindCommandActive = false;
	}
	setupRcTempArea();
	setupRotateRect();
	m_bSelectForDrag = false;
	return (pObjSelected!=NULL);
}

//oNAgr[g i̒u
void SXBSchDoc::bulkAttributeReplaceComponentInfo(const SCompIndex* pPartIndex)
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_COMPONENT){
			SXBSchComponent* pObj = (SXBSchComponent*)*pObjIte;
			pObj->setCompInfoIndex(pPartIndex);
		}
		pObjIte++;
	}
	//updateSelectedTypeFlag();
	setupRcTempArea();
	m_bTempDirty = true;
}


//oNAgr[g i̔\ݒ
void SXBSchDoc::bulkAttributeHideComponentVal(bool hide)
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_COMPONENT){
			SXBSchComponent* pObj = (SXBSchComponent*)*pObjIte;
			pObj->SetHideVal(hide);
		}
		pObjIte++;
	}
	m_bTempDirty = true;
}

//oNAgr[g iԍ̔\ݒ
void SXBSchDoc::bulkAttributeHideComponentNum(bool hide)
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_COMPONENT){
			SXBSchComponent* pObj = (SXBSchComponent*)*pObjIte;
			pObj->SetHideNum(hide);
		}
		pObjIte++;
	}
	m_bTempDirty = true;
}


//oNAgr[g RgtHg̕ύX
void SXBSchDoc::bulkAttributeCommentFont(SXBSchComment& refComment)
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_COMMENT){
			SXBSchComment* pObj = (SXBSchComment*)*pObjIte;
			pObj->setFontName(refComment.fontName());
			pObj->setFontSize(refComment.fontSize());
			pObj->setFontBold(refComment.fontBold());
			pObj->setFontItalic(refComment.fontItalic());
		}
		pObjIte++;
	}
	//updateSelectedTypeFlag();
	setupRcTempArea();
	m_bTempDirty = true;
}



//oNAgr[g }[J[C̕ύX
void SXBSchDoc::bulkAttributeMarkerLine(int width,unsigned nColor)
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_MARKER){
			SXBSchMarkerLine* pObj = (SXBSchMarkerLine*)*pObjIte;
			pObj->m_nColor = nColor;
			pObj->m_width = width;
		}
		pObjIte++;
	}
	//updateSelectedTypeFlag();
	setupRcTempArea();
	m_bTempDirty = true;
}



//oNAgr[g ^Og̕ύX
void SXBSchDoc::bulkAttributeChangeTagFrameTo(int n)
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_TAG){
			SXBSchTag* pObj = (SXBSchTag*)*pObjIte;
			pObj->setTagType(n);
		}
		pObjIte++;
	}
	//updateSelectedTypeFlag();
	setupRcTempArea();
	m_bTempDirty = true;
}



//x^O𐶐
SXBSchTag* SXBSchDoc::generateTagFromLabel(SXBSchLabel* pObj)
{
	SXBSchTag* pNewObj=new SXBSchTag;
	pNewObj->setP1(pObj->p1());
	pNewObj->setText(pObj->text());

	pNewObj->setLayer(pObj->layer());
	pNewObj->setRefObj(pObj->refObj());
	pNewObj->setPlaceNum(pObj->placeNum());
	pNewObj->setSelection(SXBSchObj::SELECT_ALL);
	return pNewObj;
}


//x^Oɕϊ
void SXBSchDoc::bulkConvertLabel2Tag()
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_LABEL){
			SXBSchObj* pObj = *pObjIte;
			SXBSchObj* pNewObj = generateTagFromLabel((SXBSchLabel*)pObj);
			*pObjIte = pNewObj;
			delete pObj;
		}
		pObjIte++;
	}
	updateSelectedTypeFlag();
	setupRcTempArea();
	m_bTempDirty = true;
}

//xRg𐶐
SXBSchComment* SXBSchDoc::generateCommentFromLabel(SXBSchLabel* pObj)
{	
	SXBSchComment* pNewObj=new SXBSchComment;
	pNewObj->setP1(pObj->p1());
	pNewObj->setText(pObj->text());

	pNewObj->setLayer(pObj->layer());
	pNewObj->setRefObj(pObj->refObj());
	pNewObj->setPlaceNum(pObj->placeNum());
	pNewObj->setSelection(SXBSchObj::SELECT_ALL);
	return pNewObj;
}
//xRgɕϊ
void SXBSchDoc::bulkConvertLabel2Comment()
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_LABEL){
			SXBSchObj* pObj = *pObjIte;
			SXBSchObj* pNewObj = generateCommentFromLabel((SXBSchLabel*)pObj);
			*pObjIte = pNewObj;
			delete pObj;
		}
		pObjIte++;
	}
	updateSelectedTypeFlag();
	setupRcTempArea();
	m_bTempDirty = true;
}


//^O烉x𐶐
SXBSchLabel* SXBSchDoc::generateLabelFromTag(SXBSchTag* pObj)
{	
	SXBSchLabel* pNewObj=new SXBSchLabel;
	pNewObj->setP1(pObj->p1());
	pNewObj->setText(pObj->text());
	pNewObj->setLayer(pObj->layer());
	pNewObj->setRefObj(pObj->refObj());
	pNewObj->setPlaceNum(pObj->placeNum());
	pNewObj->setSelection(SXBSchObj::SELECT_ALL);
	return pNewObj;
}

//^Oxɕϊ
void SXBSchDoc::bulkConvertTag2Label()
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_TAG){
			SXBSchObj* pObj = *pObjIte;
			SXBSchObj* pNewObj = generateLabelFromTag((SXBSchTag*)pObj);
			*pObjIte = pNewObj;
			delete pObj;
		}
		pObjIte++;
	}
	updateSelectedTypeFlag();
	setupRcTempArea();
	m_bTempDirty = true;
}


//^ORg𐶐
SXBSchComment* SXBSchDoc::generateCommentFromTag(SXBSchTag* pObj)
{	
	SXBSchComment* pNewObj=new SXBSchComment;
	pNewObj->setP1(pObj->p1());
	pNewObj->setText(pObj->text());

	pNewObj->setLayer(pObj->layer());
	pNewObj->setRefObj(pObj->refObj());
	pNewObj->setPlaceNum(pObj->placeNum());
	pNewObj->setSelection(SXBSchObj::SELECT_ALL);
	return pNewObj;
}


//^ORgɕϊ
void SXBSchDoc::bulkConvertTag2Comment()
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_TAG){
			SXBSchObj* pObj = *pObjIte;
			SXBSchObj* pNewObj = generateCommentFromTag((SXBSchTag*)pObj);
			*pObjIte = pNewObj;
			delete pObj;
		}
		pObjIte++;
	}
	updateSelectedTypeFlag();
	setupRcTempArea();
	m_bTempDirty = true;
}


//Rgxɕϊ
void SXBSchDoc::bulkConvertComment2Label()
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_COMMENT){
			SXBSchComment* pObj = (SXBSchComment*)*pObjIte;
			int x = pObj->p1().x();
			int y = pObj->p1().y();


			string strText = pObj->text();
			int len = strText.length();
			int s=0;
			bool firstLine = true;
			for(int e=0;e<len;e++){
				if(strText[e]=='\r'||strText[e]=='\n'||(e==(len-1))){
					if(s<e){
						int copyLen;
						if(strText[e]=='\r'||strText[e]=='\n'){
							copyLen = e-s;
						}else{
							copyLen = e-s+1;
						}
						string newStr = strText.substr(s,copyLen);

						SXBSchLabel* pNewObj=new SXBSchLabel;
						pNewObj->setP1(SPoint(x,y));
						y+=10;
						pNewObj->setText(newStr.c_str());
						pNewObj->setLayer(pObj->layer());
						pNewObj->setRefObj((firstLine? pObj->refObj():NULL));
						pNewObj->setPlaceNum(pObj->placeNum());
						pNewObj->setSelection(SXBSchObj::SELECT_ALL);
						
						if(firstLine){
							*pObjIte = pNewObj;
						}else{
							m_listTemp.push_front(pNewObj);
						}

						firstLine = false;

					}
					s=e+1;
				}
			}
			delete pObj;
		}
		pObjIte++;
	}
	updateSelectedTypeFlag();
	setupRcTempArea();
	m_bTempDirty = true;
}


//Rg^Oɕϊ
void SXBSchDoc::bulkConvertComment2Tag()
{
	XBSchObjListIterator pObjIte = m_listTemp.begin();
	while(pObjIte != m_listTemp.end()){
		if((*pObjIte)->id()==SXBSchObj::ID_COMMENT){
			SXBSchComment* pObj = (SXBSchComment*)*pObjIte;
			int x = pObj->p1().x();
			int y = pObj->p1().y();


			string strText = pObj->text();
			int len = strText.length();
			int s=0;
			bool firstLine = true;
			for(int e=0;e<len;e++){
				if(strText[e]=='\r'||strText[e]=='\n'||(e==(len-1))){
					if(s<e){
						int copyLen;
						if(strText[e]=='\r'||strText[e]=='\n'){
							copyLen = e-s;
						}else{
							copyLen = e-s+1;
						}
						string newStr = strText.substr(s,copyLen);

						SXBSchTag* pNewObj=new SXBSchTag;
						pNewObj->setP1(SPoint(x,y));
						y+=10;
						pNewObj->setText(newStr.c_str());
						pNewObj->setLayer(pObj->layer());
						pNewObj->setRefObj((firstLine? pObj->refObj():NULL));
						pNewObj->setPlaceNum(pObj->placeNum());
						pNewObj->setSelection(SXBSchObj::SELECT_ALL);
						
						if(firstLine){
							*pObjIte = pNewObj;
						}else{
							m_listTemp.push_front(pNewObj);
						}

						firstLine = false;

					}
					s=e+1;
				}
			}
			delete pObj;
		}
		pObjIte++;
	}
	updateSelectedTypeFlag();
	setupRcTempArea();
	m_bTempDirty = true;
}
