/*
 * Copyright  2008-2009 INRIA/SensTools
 * 
 * <dev-team@sentools.info>
 * 
 * This software is a set of libraries designed to develop applications
 * for the WSN430 embedded hardware platform.
 * 
 * This software is governed by the CeCILL license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info". 
 * 
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software&apos;s author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability. 
 * 
 * In this respect, the user&apos;s attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and f that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software&apos;s suitability as regards their
 * requirements in conditions enabling the security of their systems and/or 
 * data to be ensured and,  more generally, to use and operate it in the 
 * same conditions as regards security. 
 * 
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL license and that you accept its terms.
 */

#include <avr/io.h>
#include <avr/signal.h>
#include <avr/interrupt.h>
//#include <avr/iomx8p.h>
//#include <avr/stdint.h>


#include "spi1.h"

#include "cc1100.h"
#include "cc1100_gdo.h"
#include "cc1100_globals.h"
#include "macro.h"

static uint16_t (*gdo0_cb)(void);
static uint16_t (*gdo2_cb)(void);



void u100delay(u8 usec);
void mdelay(u16 msec);
void cc1101_8PATABLE_write_reg(u8 * reg);
uint8_t cc1100_read_reg_uartout(uint8_t addr);



void cc1100_reinit(void)
{
    spi1_init();
}

void cc1100_init(void)
{

	//volatile unsigned char test_val1 = 0;
	//volatile unsigned char test_val2 = 0;
	//volatile unsigned char test_val3 = 0;
	//u8 pt_data[] = {0xC0,0x50,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7};

	gdo0_cb = 0x0;
	gdo2_cb = 0x0;
  
	spi1_init();
	GDO_INIT();
  
	spi1_select(SPI1_CC1100);
	spi1_deselect(SPI1_CC1100);
	spi1_select(SPI1_CC1100);
	spi1_deselect(SPI1_CC1100);
	//udelay(80);
	//u100delay(1);
	mdelay(1);
	spi1_select(SPI1_CC1100);
	while (spi1_read_somi()) ;
	spi1_write_single(CC1100_STROBE_SRES | CC1100_ACCESS_STROBE);
	while (spi1_read_somi()) ;
	spi1_deselect(SPI1_CC1100);

	mdelay(1);


	//setup 426.361755MHz
	cc1100_write_reg(CC1100_REG_FREQ2, 0x10);
	//cc1100_write_reg(CC1100_REG_FREQ2, 0x10);
	cc1100_write_reg(CC1100_REG_FREQ1, 0x66);
	cc1100_write_reg(CC1100_REG_FREQ0, 0x07);





	//cc1100_write_reg((CC1100_PATABLE_ADDR |CC1100_ACCESS_WRITE_BURST), 0xC0);	//TX_power -5dB 

	#if 0
	cc1101_8PATABLE_write_reg(pt_data);
	#endif

	#if 0
	cc1100_write_reg(CC1100_REG_FREND0,(cc1100_read_reg(CC1100_REG_FREND0) | 0x01));
	#endif


	#if 1

	cc1100_read_reg_uartout(CC1100_REG_FREQ2);
	cc1100_read_reg_uartout(CC1100_REG_FREQ1);
	cc1100_read_reg_uartout(CC1100_REG_FREQ0);


	#endif
}

uint8_t cc1100_read_reg(uint8_t addr)
{
	uint8_t reg;
	spi1_select(SPI1_CC1100);
	spi1_write_single(addr | CC1100_ACCESS_READ);
	reg = spi1_read_single();
	spi1_deselect(SPI1_CC1100);
	return reg;
}

void cc1100_write_reg(uint8_t addr, uint8_t value)
{
	spi1_select(SPI1_CC1100);
	spi1_write_single(addr | CC1100_ACCESS_WRITE);
	spi1_write_single(value);
	spi1_deselect(SPI1_CC1100);
}

uint8_t cc1100_strobe_cmd(uint8_t cmd)
{
	uint8_t ret;
	spi1_select(SPI1_CC1100);
	while(spi1_read_somi());
	//mdelay(3);
	ret = spi1_write_single(cmd | CC1100_ACCESS_STROBE);
	spi1_deselect(SPI1_CC1100);
	return ret;
}

/*add 20100113 blackz*/
uint8_t cc1100_sleep_strobe_cmd(uint8_t cmd)
{
	uint8_t ret;
	//spi1_select(SPI1_CC1100);
	//while(spi1_read_somi());
	//mdelay(3);
	ret = spi1_write_single(cmd | CC1100_ACCESS_STROBE);
	//spi1_deselect(SPI1_CC1100);
	return ret;
}

void cc1100_fifo_put(uint8_t* buffer, uint16_t length)
{
  spi1_select(SPI1_CC1100);
  spi1_write_single(CC1100_DATA_FIFO_ADDR | CC1100_ACCESS_WRITE_BURST);
  spi1_write(buffer, length);
  spi1_deselect(SPI1_CC1100);
}

//void cc1100_fifo_get(uint8_t* buffer, uint16_t length)
void cc1100_fifo_get(uint8_t* buffer, uint16_t length)
{
	spi1_select(SPI1_CC1100);
	spi1_write_single(CC1100_DATA_FIFO_ADDR | CC1100_ACCESS_READ_BURST);
	spi1_read(buffer, length);
	spi1_deselect(SPI1_CC1100);
}

//uint8_t cc1100_read_status(uint8_t addr)
uint8_t cc1100_read_status(uint8_t addr)
{
	uint8_t temp;

	temp = cc1100_read_reg(addr | CC1100_ACCESS_STATUS);

	#if 0

	puthex(addr);
	putc(0x5c);
	puthex(cc1100_read_reg(CC1100_REG_IOCFG2));
	putc(0x0d);
	putc(0x0a);

	#endif

	return temp;
}


void cc1100_gdo0_register_callback(uint16_t (*cb)(void))
{
	gdo0_cb = cb;
}

void cc1100_gdo2_register_callback(uint16_t (*cb)(void))
{
	gdo2_cb = cb;
}

#define STATE_IDLE    0
#define STATE_RX      1
#define STATE_TX      2
#define STATE_FSTXON  3
#define STATE_CALIB   4
#define STATE_SETTL   5
#define STATE_RXOVER  6
#define STATE_TXUNDER 7

#define WAIT_STATUS(status) \
	while ( ((cc1100_cmd_nop()>>4) & 0x7) != status) ;

void cc1100_cmd_calibrate(void)
{
	cc1100_cmd_idle();
	cc1100_strobe_cmd(CC1100_STROBE_SCAL);
	WAIT_STATUS(STATE_IDLE);
}

void cc1100_cmd_idle(void)
{
	switch ((cc1100_cmd_nop() >> 4) & 0x7)
	{
		case STATE_RXOVER:
			cc1100_cmd_flush_rx();
			break;
		case STATE_TXUNDER:
			cc1100_cmd_flush_tx();
			break;
		default:
		cc1100_strobe_cmd(CC1100_STROBE_SIDLE);
	}
	WAIT_STATUS(STATE_IDLE);
}

#if 0




//interrupt(PORT1_VECTOR) port1irq(void)
void port1irq(void)
{
	uint8_t get_irq=0;

	get_irq = PORTC;

	if(get_irq & ~0x02)
	{
		GDO0_INT_CLEAR();

		if(status == CHK_INPUT)
	{
	status = DATA_SEND;


}

if(status == DATA_SEND)
{
status = CHK_DATA_SEND;


}


if(status == CHK_DATA_SEND)
{
status = CHK_INPUT;

}




#if 0
if (gdo0_cb != 0x0)
{
if (gdo0_cb())
{
    LPM4_EXIT;
}
}
	#endif
}

if(get_irq & 0x04)
{
GDO2_INT_CLEAR();

#if 0
if (gdo2_cb != 0x0)
{
if (gdo2_cb())
{
LPM4_EXIT;
}
}
#endif
} 
}




ISR(PCINT0_vect)
{

	port1irq();

}






#endif






