#include "stdafx.h"

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <string>
#include <list>
using namespace std;
#include "ce3io.h"
#include "xbschobj.h"
#include "xbschjunc.h"
#include "xbschlabel.h"
#include "xbschcomment.h"
#include "xbschtag.h"
#include "xbschcomponent.h"

#include "xbschline.h"
#include "xbschentry.h"
#include "xbschdelobj.h"
#include "xbschsheetinfo.h"
#include "xbschdoc.h"

#include "ce2to3cmd.h"


SCe2to3Param::SCe2to3Param()
{
	init();
}

void SCe2to3Param::init()
{
	srcFileName   = "";
	destFileName  = "";
	largeFontName = "";
	largeFontSize = 16;
	smallFontName = "";
	smallFontSize = 10;
}


static int makeInt(char upperbyte,char lowewbyte)
{
	int ret = upperbyte << 8;
	ret += *(unsigned char*)(&lowewbyte);
	return ret;
}

SXBSchSheetInfo*	readCE2SheetInfo(FILE* pCE2)
{
//+0	BYTE	byteRes;		// 0x20 (==Space   )
//+1	char	szId[32];		// "CE DATA FILE $0001\x1a" 
//+33	BYTE	byteSize;		// }ʃTCY0`4,FREE_SHEETSIZEB0xFF̂Ƃ̓Nbv{[hB
//+34	short int left;			// byteSizeFREE_SHEETSIZE,0xFF̂ƂɗLBshort int 2oCgz
//+36	short int top;			//                          
//+38	short int right;		//                          
//+40	short int bottom;		//                          
//+42	WORD	wShowLayer;		// \C[
//+44	WORD	nEditLayer;		// ҏWC[
//+46	char	reserved[13];	// \
	char buff[64];
	static int widthTabel[]		={	640,1000, 1600, 2000, 3000};
	static int heightTabel[]	={	480, 750, 1200, 1500, 2000};
	static char* szID=" CE DATA FILE $0001\x1a";
	if(fread(buff,59,1,pCE2)==0)			return NULL;
	if(strncmp(szID,buff,strlen(szID))!=0)	return NULL;
	int width=0;
	int height=0;
	int sizeID = *(unsigned char*)(&buff[33]);
	if(sizeID>=0 && sizeID<=4){
		width	= widthTabel[sizeID];
		height	= heightTabel[sizeID];
	}else{
		width	= makeInt(buff[39],buff[38]);
		height	= makeInt(buff[41],buff[40]);
	}
	unsigned int visibleLayer = makeInt(buff[43],buff[42]);
	int			 editLayer    = makeInt(buff[45],buff[44]);
	SXBSchSheetInfo* pObj = new SXBSchSheetInfo;
	pObj->setWidth(width);
	pObj->setHeight(height);
	pObj->setVisbleLayer(visibleLayer);
	pObj->setEditLayer(editLayer);
	return pObj;
}


SXBSchLine*			readCE2Line(FILE* pCE2,int id)
{
// atrb Ɋ܂܂郌C[͖
//+0    BYTE            atrb;    /*        */
//+1    short int       x1;      /* n_wW */
//+3    short int       y1;      /* n_xW */
//+5    short int       x2;      /* I_wW */
//+7    short int       y2;      /* I_xW */
	char buff[16];
	if(fread(buff,9,1,pCE2)==0)			return NULL;
	SPoint p1(makeInt(buff[2],buff[1]),makeInt(buff[4],buff[3]));
	SPoint p2(makeInt(buff[6],buff[5]),makeInt(buff[8],buff[7]));
	SXBSchLine* pObj=NULL;
	switch(id){
	case 2:
		pObj = new SXBSchBus;
		break;
	case 3:
		pObj = new SXBSchWire;
		break;
	case 4:
		pObj = new SXBSchDash;
		break;
	default: return NULL;
	}
	int layer = (buff[0]>>4)&7;
	pObj->setLayer(layer);
	pObj->setP1(p1);
	pObj->setP2(p2);
	return pObj;
}


SXBSchJunc*			readCE2Junction(FILE* pCE2)
{
// atrb Ɋ܂܂郌C[͖
//+0        BYTE            atrb;    /*    */
//+1        short int       x;       /* wW */
//+3        short int       y;       /* xW */
	char buff[16];
	if(fread(buff,5,1,pCE2)==0)			return NULL;
	SPoint p1(makeInt(buff[2],buff[1]),makeInt(buff[4],buff[3]));
	SXBSchJunc* pObj= new SXBSchJunc;
	int layer = (buff[0]>>4)&7;
	pObj->setLayer(layer);
	pObj->setP1(p1);
	return pObj;
}


SXBSchEntry*		readCE2Entry(FILE* pCE2)
{
// atrb Ɋ܂܂郌C[͖
//+0        BYTE            atrb;    /*    */
//+1        short int       x;       /* wW */
//+3        short int       y;       /* xW */
	char buff[16];
	if(fread(buff,5,1,pCE2)==0)			return NULL;
	SPoint p1(makeInt(buff[2],buff[1]),makeInt(buff[4],buff[3]));
	SXBSchEntry* pObj;
	if(buff[0] & 2){
		pObj = new SXBSchEntry;
	}else{
		pObj = new SXBSchBusEntry;
	}
	int layer = (buff[0]>>4)&7;
	pObj->setLayer(layer);
	pObj->setP1(p1);
	pObj->setAspect(( (buff[0] & 1) ? SXBSchEntry::RIGHT_DOWN : SXBSchEntry::LEFT_DOWN));
	return pObj;
}


SXBSchLabel*		readCE2Label(FILE* pCE2)
{
// atrb Ɋ܂܂郌C[͖
//+0        BYTE            atrb;    /*    */
//+1        short int       x;       /* wW */
//+3        short int       y;       /* xW */
//+5        char            str[12]; /*  */
	char buff[32];
	if(fread(buff,17,1,pCE2)==0)			return NULL;
	SPoint p1(makeInt(buff[2],buff[1]),makeInt(buff[4],buff[3]));
	int len = buff[5];
	if(len > 11)	len = 11;
	else if(len<0)	len = 0;
	buff[6+len]='\0';
	SXBSchLabel* pObj = new SXBSchLabel;
	int layer = (buff[0]>>4)&7;
	pObj->setLayer(layer);
	pObj->setP1(p1);
	pObj->setText(&(buff[6]));
	pObj->setHorizontal((buff[0]&8) ==0);
	return pObj;
}

SXBSchTag*	readCE2Tag(FILE* pCE2)
{
// atrb Ɋ܂܂郌C[͖
//+0        BYTE            atrb;    /*    */
//+1        short int       x;       /* wW */
//+3        short int       y;       /* xW */
//+5        char            str[12]; /*  */
	char buff[32];
	if(fread(buff,17,1,pCE2)==0)			return NULL;
	SPoint p1(makeInt(buff[2],buff[1]),makeInt(buff[4],buff[3]));
	int len = buff[5];
	if(len > 11)	len = 11;
	else if(len<0)	len = 0;
	buff[6+len]='\0';
	SXBSchTag* pObj = new SXBSchTag;
	int layer = (buff[0]>>4)&7;
	pObj->setLayer(layer);
	pObj->setP1(p1);
	pObj->setText(&(buff[6]));
	pObj->setHorizontal(true);	//CE2̃^O͏ɐ
	pObj->setTagType(buff[0]&3);
	return pObj;
}

SXBSchComment*	readCE2CommentV2(FILE* pCE2,const SCe2to3Param& param)
{
//+0        BYTE            atrb;   /* don't care          */
//+1        short int       x;      /* ʒu                */
//+3        short int       y;      /* ʒu                */
//+5        short int       x2;     /* don't care          */
//+7        short int       y2;     /* don't care          */
//+9        short int       dsize;  /* \̑Ŝ̃TCY  */
//+11        char            type;   /* 0̂ƂACEtHg̃Rg       */
//+12        char            str[1]; /* ɍő63i64oCg)̕ */
// atrb Ɋ܂܂郌C[͖
	char buff[16];
	char buff2[80];
	if(fread(buff,11,1,pCE2)==0)			return NULL;
	int remainSize = makeInt(buff[10],buff[9]) - 12;
	if(remainSize<2 || remainSize>65)		return NULL;
	if(fread(buff2,remainSize,1,pCE2)==0)	return NULL;
	SPoint p1(makeInt(buff[2],buff[1]),makeInt(buff[4],buff[3]));
	int len = buff2[1];
	if(len > 63)	len = 63;
	else if(len<0)	len = 0;
	buff2[2+len]='\0';
	SXBSchComment* pObj = new SXBSchComment;
	int layer = (buff[0]>>4)&7;
	pObj->setLayer(layer);
	pObj->setP1(p1);
	pObj->setText(&(buff2[2]));
	if(buff2[0]==0){
		pObj->setFontName(param.smallFontName.c_str());
		pObj->setFontSize(param.smallFontSize);
	}else{
		pObj->setFontName(param.largeFontName.c_str());
		pObj->setFontSize(param.largeFontSize);
	}
	return pObj;
}


SXBSchComponent*	readCE2Component(FILE* pCE2)
{
//+0        BYTE            atrb;     /*                        */
//+1        short int       x;        /* wW                     */
//+3        short int       y;        /* xW                     */
//+5        WORD            libn;     /* don't care                 */
//+7        WORD            indx;     /* don't care                 */
//+9        BYTE            dire;     /* p[č               */
//+10       BYTE            devn;     /* foCX/pbP[W̔ԍ  */
//+11       char            name[16]; /* ҏWꂽp[c         */
//+27       short int       name_x;   /* p[cwW             */
//+29       short int       name_y;   /* p[cxW             */
//+31       char            num[8];   /* ҏWꂽp[cԍ       */
//+39       short int       num_x;    /* p[cԍwW         */
//+41       short int       num_y;    /* p[cԍxW         */
//+43       char            dname[16];/* ftHgp[c         */
	char buff[64];
	int len ;
	if(fread(buff,59,1,pCE2)==0)			return NULL;
	SPoint p1(makeInt(buff[2],buff[1]),makeInt(buff[4],buff[3]));
	SPoint pVOffset(makeInt(buff[28],buff[27]),makeInt(buff[30],buff[29]));
	SPoint pROffset(makeInt(buff[40],buff[39]),makeInt(buff[42],buff[41]));
	len = buff[11];
	if(len<0)	len=0;
	else if(len>15) len=15;
	buff[12+len]='\0';
	len = buff[31];
	if(len<0)	len=0;
	else if(len>7) len=7;
	buff[32+len]='\0';
	SXBSchComponent* pObj= new SXBSchComponent;
	int layer = (buff[0]>>4)&7;
	pObj->setLayer(layer);
	pObj->setP1(p1);
	pObj->setNamePos(pVOffset);
	pObj->setRefnumPos(pROffset);
	pObj->setName(&buff[12]);
	pObj->setRefnum(&buff[32]);
	pObj->setOrgName(&buff[43]);
	pObj->setBlock(buff[10]);
	pObj->setDir(buff[9]&7);
	return pObj;
}

int ce2to3(FILE* pCE2, SXBSchDoc* pDoc, const SCe2to3Param& param)
{
	SXBSchObj* pObj;
	SXBSchSheetInfo* pInfo = NULL;
	char cc;
	int retvalue=0;	
	while(fread(&cc,1,1,pCE2)==1){
		//printf("%d:%d\n",retvalue,cc);
		switch(cc){
		case 9:
			pInfo = readCE2SheetInfo(pCE2);
			if(pInfo!=NULL){
				if(retvalue==0){
					pDoc->SetSheetSize(SSize(pInfo->width(),pInfo->height()));
				}	
				delete pInfo;
				continue;
			}else{
				pObj = NULL;			
				break;
			}
		case 0:
			pObj = readCE2Junction(pCE2);
			break;
		case 1:
			pObj = readCE2Entry(pCE2);
			break;
		case 2:
		case 3:
		case 4:
			pObj = readCE2Line(pCE2,cc);
			break;
		case 5:
			pObj = readCE2Label(pCE2);
			break;
		case 6:
			pObj = readCE2Tag(pCE2);
			break;
		case 8:
			pObj = readCE2Component(pCE2);
			break;
		case 16:
			pObj = readCE2CommentV2(pCE2,param);
			break;

		default:
			pObj = NULL;
		}
		if(pObj==NULL) break;
		pDoc->add(pObj);
		retvalue++;
	}
	
	return retvalue;
}

