/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// SetLayer.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "bsch.h"
#include "SetLayer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetLayer _CAO


CSetLayer::CSetLayer(CWnd* pParent /*=NULL*/)
	: CDialog(CSetLayer::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetLayer)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
	m_wShow=0xFFFF;
	m_nEdit=0;
	m_fEditHigh=FALSE;
}


void CSetLayer::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetLayer)
                //  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetLayer, CDialog)
	//{{AFX_MSG_MAP(CSetLayer)
	ON_BN_CLICKED(IDC_D0, OnD0)
	ON_BN_CLICKED(IDC_D1, OnD1)
	ON_BN_CLICKED(IDC_D2, OnD2)
	ON_BN_CLICKED(IDC_D3, OnD3)
	ON_BN_CLICKED(IDC_D4, OnD4)
	ON_BN_CLICKED(IDC_D5, OnD5)
	ON_BN_CLICKED(IDC_D6, OnD6)
	ON_BN_CLICKED(IDC_D7, OnD7)
	ON_BN_CLICKED(IDC_E0, OnE0)
	ON_BN_CLICKED(IDC_E1, OnE1)
	ON_BN_CLICKED(IDC_E2, OnE2)
	ON_BN_CLICKED(IDC_E3, OnE3)
	ON_BN_CLICKED(IDC_E4, OnE4)
	ON_BN_CLICKED(IDC_E5, OnE5)
	ON_BN_CLICKED(IDC_E6, OnE6)
	ON_BN_CLICKED(IDC_E7, OnE7)
	ON_BN_CLICKED(IDC_CHECK_EDIT_HIGHLIGHT, OnCheckEditHighlight)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


WORD CSetLayer::GetBit(int nLayer)
{
	static WORD table[]={
		0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80
	};
	if(nLayer<0 || nLayer>7) return 1;
	return table[nLayer];
}



/////////////////////////////////////////////////////////////////////////////
// CSetLayer bZ[W nh

BOOL CSetLayer::OnInitDialog() 
{
	CDialog::OnInitDialog();


	// TODO: ̈ʒuɏ̕⑫ǉĂ
	WORD wBit;
	int  n;
	int  nID;

	if(m_wShow==0) m_wShow=0xFF;
	if(!(m_wShow & GetBit(m_nEdit))){
		wBit=0x01;
		n=0;
		while(!(wBit & m_wShow)){ wBit<<=1; n++; }
		m_nEdit=n;
	}
	//IDC_D0`IDC_D7͘AlɂȂ悤Ƀ\[XGfB^Őݒ肵Ă
	//IDC_E0`IDC_E7͘AlɂȂ悤Ƀ\[XGfB^Őݒ肵Ă
	CButton* pButton;
	nID=IDC_D0;
	wBit=1;
	for(n=0;n<8;n++){
		pButton=(CButton*)GetDlgItem(nID);
		pButton->SetCheck((wBit & m_wShow)!=0);
		nID++;
		wBit<<=1;
	}
	nID=IDC_E0;
	for(n=0;n<8;n++){
		pButton=(CButton*)GetDlgItem(nID);
		pButton->SetCheck(n==m_nEdit);
		nID++;
	}
	pButton=(CButton*)GetDlgItem(IDC_CHECK_EDIT_HIGHLIGHT);
	pButton->SetCheck(m_fEditHigh!=FALSE);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CSetLayer::OnDCheck(int n)
{
	CButton* pButton=(CButton*)GetDlgItem(IDC_D0+n);
	if(pButton->GetCheck()){	//݂`FbN`FbNOFFɂB݂̕ҏWΏۂ̃C[OFFɂłȂB
		CButton* pEButton=(CButton*)GetDlgItem(IDC_E0+n);
		if(!pEButton->GetCheck())	pButton->SetCheck(0);
	}else{
		pButton->SetCheck(1);
	}
}

void CSetLayer::OnECheck(int n)
{
	CButton* pButton=(CButton*)GetDlgItem(IDC_D0+n);
	pButton->SetCheck(1);	//YC[͋Iɕ\Ԃɂ
	int i;
	for(i=0;i<8;i++){
		CButton* pEButton=(CButton*)GetDlgItem(IDC_E0+i);
		pEButton->SetCheck(i==n);
	}
}


void CSetLayer::OnD0() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnDCheck(0);
}

void CSetLayer::OnD1() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnDCheck(1);
}

void CSetLayer::OnD2() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnDCheck(2);
}

void CSetLayer::OnD3() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnDCheck(3);
}

void CSetLayer::OnD4() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnDCheck(4);
}

void CSetLayer::OnD5() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnDCheck(5);
}

void CSetLayer::OnD6() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnDCheck(6);
}

void CSetLayer::OnD7() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnDCheck(7);
}

void CSetLayer::OnE0() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnECheck(0);
}

void CSetLayer::OnE1() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnECheck(1);
}

void CSetLayer::OnE2() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnECheck(2);
}

void CSetLayer::OnE3() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnECheck(3);
}

void CSetLayer::OnE4() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnECheck(4);
}

void CSetLayer::OnE5() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnECheck(5);
}

void CSetLayer::OnE6() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnECheck(6);
}

void CSetLayer::OnE7() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	OnECheck(7);
}

void CSetLayer::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ

	//IDC_D0`IDC_D7͘AlɂȂ悤Ƀ\[XGfB^Őݒ肵Ă
	//IDC_E0`IDC_E7͘AlɂȂ悤Ƀ\[XGfB^Őݒ肵Ă
	int n;
	CButton* pButton;
	WORD wBit=1;
	m_wShow=0;
	for(n=0;n<8;n++){
		pButton=(CButton*)GetDlgItem(IDC_D0+n);
		if(pButton->GetCheck()) m_wShow |= wBit;
		wBit<<=1;
	}
	for(n=0;n<8;n++){
		pButton=(CButton*)GetDlgItem(IDC_E0+n);
		if(pButton->GetCheck()){
			m_nEdit=n;
			break;
		}
	}
	pButton=(CButton*)GetDlgItem(IDC_CHECK_EDIT_HIGHLIGHT);
	m_fEditHigh=pButton->GetCheck();


	CDialog::OnOK();
}

void CSetLayer::OnCheckEditHighlight() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CButton* pButton=(CButton*)GetDlgItem(IDC_CHECK_EDIT_HIGHLIGHT);
	pButton->SetCheck(pButton->GetCheck()==FALSE);
}
