
// Microsoft Visual Studio compiles this Windows native code into SystemUtilities.dll
// LimeWire uses these functions from the class com.limegroup.gnutella.util.SystemUtils

// Windows Firewall, only available in Windows XP Service Pack 2 or later
#include <netfw.h>

// Headers generated by Java for functions Java code can call
#ifndef _Included_org_limewire_util_SystemUtils_Firewall
#define _Included_org_limewire_util_SystemUtils_Firewall
#ifdef __cplusplus
extern "C" {
#endif

	// Functions in Firewall.cpp
	JNIEXPORT jboolean JNICALL Java_org_limewire_util_SystemUtils_firewallPresentNative(JNIEnv *e, jclass c);
	JNIEXPORT jboolean JNICALL Java_org_limewire_util_SystemUtils_firewallEnabledNative(JNIEnv *e, jclass c);
	JNIEXPORT jboolean JNICALL Java_org_limewire_util_SystemUtils_firewallExceptionsNotAllowedNative(JNIEnv *e, jclass c);
	JNIEXPORT jboolean JNICALL Java_org_limewire_util_SystemUtils_firewallIsProgramListedNative(JNIEnv *e, jclass c, jstring path);
	JNIEXPORT jboolean JNICALL Java_org_limewire_util_SystemUtils_firewallIsProgramEnabledNative(JNIEnv *e, jclass c, jstring path);
	JNIEXPORT jboolean JNICALL Java_org_limewire_util_SystemUtils_firewallAddNative(JNIEnv *e, jclass c, jstring path, jstring name);
	JNIEXPORT jboolean JNICALL Java_org_limewire_util_SystemUtils_firewallRemoveNative(JNIEnv *e, jclass c, jstring path);

#ifdef __cplusplus
}
#endif
#endif

// Wraps a BSTR, a COM string, taking care of memory allocation
class CBstr {
public:

	// The BSTR
	BSTR B;

	// Make a new CBstr object
	CBstr()          { B = NULL; }         // With no BSTR allocated
	CBstr(LPCTSTR t) { B = NULL; Set(t); } // From the given text
	~CBstr()         { Clear(); }          // It frees its memory when you delete it

	// Use AllocSysString and SysFreeString to allocate and free the BSTR
	void Set(CString s) { Clear(); B = s.AllocSysString(); }
	void Clear() { if (B) { SysFreeString(B); B = NULL; } }
};

// Add an application to the Windows Firewall exceptions list
class CWindowsFirewall {
public:

	// COM interfaces
	INetFwMgr*                    Manager;
	INetFwPolicy*                 Policy;
	INetFwProfile*                Profile;
	INetFwAuthorizedApplications* ProgramList;
	INetFwAuthorizedApplication*  Program;

	// Make a new CWindowsFirewall object
	CWindowsFirewall() {

		// Set the COM interface pointers to NULL so we'll know if we've initialized them
		Manager     = NULL;
		Policy      = NULL;
		Profile     = NULL;
		ProgramList = NULL;
		Program     = NULL;
	}

	// Delete the CWindowsFirewall object
	~CWindowsFirewall() {

		// Release the COM interfaces that we got access to
		if (Program)     { Program->Release();     Program     = NULL; } // Release them in reverse order
		if (ProgramList) { ProgramList->Release(); ProgramList = NULL; }
		if (Profile)     { Profile->Release();     Profile     = NULL; }
		if (Policy)      { Policy->Release();      Policy      = NULL; }
		if (Manager)     { Manager->Release();     Manager     = NULL; }
	}

	// Methods to adjust the settings of Windows Firewall
	bool Access();
	bool FirewallEnabled(bool *enabled);
	bool ExceptionsNotAllowed(bool *notallowed);
	bool IsProgramListed(LPCTSTR path, bool *listed);
	bool IsProgramEnabled(LPCTSTR path, bool *enabled);
	bool AddProgram(LPCTSTR path, LPCTSTR name);
	bool EnableProgram(LPCTSTR path);
	bool RemoveProgram(LPCTSTR path);
};

// Functions in Firewall.cpp
bool WindowsFirewallPresent();
bool WindowsFirewallEnabled();
bool WindowsFirewallExceptionsNotAllowed();
bool WindowsFirewallIsProgramListed(LPCTSTR path);
bool WindowsFirewallIsProgramEnabled(LPCTSTR path);
bool WindowsFirewallAdd(LPCTSTR path, LPCTSTR name);
bool WindowsFirewallRemove(LPCTSTR path);
