/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.http.impl.nio.reactor.ChannelEntry;
import org.apache.http.impl.nio.reactor.IOSessionImpl;
import org.apache.http.impl.nio.reactor.SessionClosedCallback;
import org.apache.http.impl.nio.reactor.SessionRequestImpl;
import org.apache.http.nio.reactor.IOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.nio.reactor.IOSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIOReactor
implements IOReactor {
    private volatile IOReactorStatus status;
    private final Object shutdownMutex;
    private final long selectTimeout;
    private final Selector selector;
    private final Set<IOSession> sessions;
    private final Queue<IOSession> closedSessions;
    private final Queue<ChannelEntry> newChannels;

    public AbstractIOReactor(long selectTimeout) throws IOReactorException {
        if (selectTimeout <= 0L) {
            throw new IllegalArgumentException("Select timeout may not be negative or zero");
        }
        this.selectTimeout = selectTimeout;
        this.sessions = Collections.synchronizedSet(new HashSet());
        this.closedSessions = new ConcurrentLinkedQueue<IOSession>();
        this.newChannels = new ConcurrentLinkedQueue<ChannelEntry>();
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new IOReactorException("Failure opening selector", ex);
        }
        this.shutdownMutex = new Object();
        this.status = IOReactorStatus.INACTIVE;
    }

    protected abstract void acceptable(SelectionKey var1);

    protected abstract void connectable(SelectionKey var1);

    protected abstract void readable(SelectionKey var1);

    protected abstract void writable(SelectionKey var1);

    protected abstract void timeoutCheck(SelectionKey var1, long var2);

    protected abstract void validate(Set<SelectionKey> var1);

    protected abstract void keyCreated(SelectionKey var1, IOSession var2);

    protected abstract IOSession keyCancelled(SelectionKey var1);

    protected abstract void sessionClosed(IOSession var1);

    @Override
    public IOReactorStatus getStatus() {
        return this.status;
    }

    public void addChannel(ChannelEntry channelEntry) {
        if (channelEntry == null) {
            throw new IllegalArgumentException("Channel entry may not be null");
        }
        this.newChannels.add(channelEntry);
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws InterruptedIOException, IOReactorException {
        this.status = IOReactorStatus.ACTIVE;
        try {
            do {
                int readyCount;
                try {
                    readyCount = this.selector.select(this.selectTimeout);
                }
                catch (InterruptedIOException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    throw new IOReactorException("Unexpected selector failure", ex);
                }
                if (this.status == IOReactorStatus.SHUT_DOWN) break;
                if (this.status == IOReactorStatus.SHUTTING_DOWN) {
                    this.closeSessions();
                    this.closeNewChannels();
                }
                if (readyCount > 0) {
                    this.processEvents(this.selector.selectedKeys());
                }
                this.validate(this.selector.keys());
                this.processClosedSessions();
                if (this.status != IOReactorStatus.ACTIVE) continue;
                this.processNewChannels();
            } while (this.status.compareTo(IOReactorStatus.ACTIVE) <= 0 || !this.sessions.isEmpty());
            this.closeActiveChannels();
        }
        catch (ClosedSelectorException closedSelectorException) {
            Object object = this.shutdownMutex;
            synchronized (object) {
                this.status = IOReactorStatus.SHUT_DOWN;
                this.shutdownMutex.notifyAll();
            }
        }
        finally {
            Object readyCount = this.shutdownMutex;
            synchronized (readyCount) {
                this.status = IOReactorStatus.SHUT_DOWN;
                this.shutdownMutex.notifyAll();
            }
        }
    }

    private void processEvents(Set<SelectionKey> selectedKeys) {
        for (SelectionKey key : selectedKeys) {
            this.processEvent(key);
        }
        selectedKeys.clear();
    }

    protected void processEvent(SelectionKey key) {
        try {
            if (key.isAcceptable()) {
                this.acceptable(key);
            }
            if (key.isConnectable()) {
                this.connectable(key);
            }
            if (key.isReadable()) {
                this.readable(key);
            }
            if (key.isWritable()) {
                this.writable(key);
            }
        }
        catch (CancelledKeyException ex) {
            IOSession session = this.keyCancelled(key);
            if (session != null) {
                this.closedSessions.add(session);
            }
            key.attach(null);
        }
    }

    private void processNewChannels() throws IOReactorException {
        ChannelEntry entry;
        while ((entry = this.newChannels.poll()) != null) {
            SelectionKey key;
            SocketChannel channel;
            try {
                channel = entry.getChannel();
                channel.configureBlocking(false);
                key = channel.register(this.selector, 0);
            }
            catch (IOException ex) {
                throw new IOReactorException("Failure registering channel with the selector", ex);
            }
            IOSessionImpl session = new IOSessionImpl(key, new SessionClosedCallback(){

                public void sessionClosed(IOSession session) {
                    AbstractIOReactor.this.closedSessions.add(session);
                }
            });
            int timeout = 0;
            try {
                timeout = channel.socket().getSoTimeout();
            }
            catch (IOException ex) {
                // empty catch block
            }
            session.setAttribute("http.session.attachment", entry.getAttachment());
            session.setSocketTimeout(timeout);
            this.sessions.add(session);
            try {
                this.keyCreated(key, session);
                SessionRequestImpl sessionRequest = entry.getSessionRequest();
                if (sessionRequest == null) continue;
                sessionRequest.completed(session);
            }
            catch (CancelledKeyException ex) {
                this.closedSessions.add(session);
                key.attach(null);
            }
        }
    }

    private void processClosedSessions() {
        IOSession session;
        while ((session = this.closedSessions.poll()) != null) {
            if (!this.sessions.remove(session)) continue;
            this.sessionClosed(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSessions() {
        Set<IOSession> set = this.sessions;
        synchronized (set) {
            for (IOSession session : this.sessions) {
                session.close();
            }
        }
    }

    protected void closeNewChannels() throws IOReactorException {
        ChannelEntry entry;
        while ((entry = this.newChannels.poll()) != null) {
            SessionRequestImpl sessionRequest = entry.getSessionRequest();
            if (sessionRequest != null) {
                sessionRequest.cancel();
            }
            SocketChannel channel = entry.getChannel();
            try {
                channel.close();
            }
            catch (IOException ignore) {}
        }
    }

    protected void closeActiveChannels() throws IOReactorException {
        Set<SelectionKey> keys = this.selector.keys();
        Iterator<SelectionKey> it = keys.iterator();
        while (it.hasNext()) {
            try {
                SelectionKey key = it.next();
                SelectableChannel channel = key.channel();
                if (channel == null) continue;
                channel.close();
            }
            catch (IOException iOException) {}
        }
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void gracefulShutdown() {
        if (this.status != IOReactorStatus.ACTIVE) {
            return;
        }
        this.status = IOReactorStatus.SHUTTING_DOWN;
        this.selector.wakeup();
    }

    public void hardShutdown() throws IOReactorException {
        if (this.status == IOReactorStatus.SHUT_DOWN) {
            return;
        }
        this.status = IOReactorStatus.SHUT_DOWN;
        this.closeNewChannels();
        this.closeActiveChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitShutdown(long timeout) throws InterruptedException {
        Object object = this.shutdownMutex;
        synchronized (object) {
            long deadline = System.currentTimeMillis() + timeout;
            long remaining = timeout;
            while (this.status != IOReactorStatus.SHUT_DOWN) {
                this.shutdownMutex.wait(remaining);
                if (timeout <= 0L || (remaining = deadline - System.currentTimeMillis()) > 0L) continue;
            }
        }
    }

    @Override
    public void shutdown(long gracePeriod) throws IOReactorException {
        if (this.status != IOReactorStatus.INACTIVE) {
            this.gracefulShutdown();
            try {
                this.awaitShutdown(gracePeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.status != IOReactorStatus.SHUT_DOWN) {
            this.hardShutdown();
        }
    }

    @Override
    public void shutdown() throws IOReactorException {
        this.shutdown(1000L);
    }
}

