/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jarbundler;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jarbundler.AppBundleProperties;
import net.sourceforge.jarbundler.DocumentType;
import org.apache.tools.ant.BuildException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyListWriter {
    private AppBundleProperties bundleProperties;
    private double version = 1.3;
    private Document document = null;

    public PropertyListWriter(AppBundleProperties appBundleProperties) {
        this.bundleProperties = appBundleProperties;
        this.setJavaVersion(appBundleProperties.getJVMVersion());
    }

    private void setJavaVersion(String string) {
        if (string == null) {
            return;
        }
        this.version = Double.valueOf(string.substring(0, 3));
    }

    public void writeFile(File file) throws BuildException {
        Writer writer = null;
        try {
            this.document = this.createDOM();
            this.buildDOM();
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setMethod("xml");
            outputFormat.setIndenting(true);
            outputFormat.setIndent(2);
            outputFormat.setLineWidth(0);
            XMLSerializer xMLSerializer = new XMLSerializer(writer, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(this.document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BuildException((Throwable)parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to write  \"" + file + "\"");
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    throw new BuildException((Throwable)iOException);
                }
            }
        }
    }

    private Document createDOM() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        org.w3c.dom.DocumentType documentType = dOMImplementation.createDocumentType("plist", "-/Apple Computer/DTD PLIST 1.0/EN", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
        return dOMImplementation.createDocument(null, "plist", documentType);
    }

    private void buildDOM() {
        Hashtable hashtable;
        List list;
        Element element = this.document.getDocumentElement();
        element.setAttribute("version", "1.0");
        Node node = this.createNode("dict", element);
        this.writeKeyStringPair("CFBundleName", this.bundleProperties.getCFBundleName(), node);
        this.writeKeyStringPair("CFBundleShortVersionString", this.bundleProperties.getCFBundleShortVersionString(), node);
        this.writeKeyStringPair("CFBundleGetInfoString", this.bundleProperties.getCFBundleGetInfoString(), node);
        this.writeKeyStringPair("CFBundleAllowMixedLocalizations", this.bundleProperties.getCFBundleAllowMixedLocalizations() ? "true" : "false", node);
        this.writeKeyStringPair("CFBundleInfoDictionaryVersion", this.bundleProperties.getCFBundleInfoDictionaryVersion(), node);
        this.writeKeyStringPair("CFBundleExecutable", this.bundleProperties.getCFBundleExecutable(), node);
        this.writeKeyStringPair("CFBundleDevelopmentRegion", this.bundleProperties.getCFBundleDevelopmentRegion(), node);
        this.writeKeyStringPair("CFBundlePackageType", this.bundleProperties.getCFBundlePackageType(), node);
        this.writeKeyStringPair("CFBundleSignature", this.bundleProperties.getCFBundleSignature(), node);
        if (this.bundleProperties.getCFBundleVersion() != null) {
            this.writeKeyStringPair("CFBundleVersion", this.bundleProperties.getCFBundleVersion(), node);
        }
        if (this.bundleProperties.getCFBundleIconFile() != null) {
            this.writeKeyStringPair("CFBundleIconFile", this.bundleProperties.getCFBundleIconFile(), node);
        }
        if (this.bundleProperties.getCFBundleIdentifier() != null) {
            this.writeKeyStringPair("CFBundleIdentifier", this.bundleProperties.getCFBundleIdentifier(), node);
        }
        if (this.bundleProperties.getCFBundleHelpBookFolder() != null) {
            this.writeKeyStringPair("CFBundleHelpBookFolder", this.bundleProperties.getCFBundleHelpBookFolder(), node);
        }
        if (this.bundleProperties.getCFBundleHelpBookName() != null) {
            this.writeKeyStringPair("CFBundleHelpBookName", this.bundleProperties.getCFBundleHelpBookName(), node);
        }
        if ((list = this.bundleProperties.getDocumentTypes()).size() > 0) {
            this.writeDocumentTypes(list, node);
        }
        this.writeKey("Java", node);
        Node node2 = this.createNode("dict", node);
        this.writeKeyStringPair("MainClass", this.bundleProperties.getMainClass(), node2);
        if (this.bundleProperties.getJVMVersion() != null) {
            this.writeKeyStringPair("JVMVersion", this.bundleProperties.getJVMVersion(), node2);
        }
        List list2 = this.bundleProperties.getClassPath();
        List list3 = this.bundleProperties.getExtraClassPath();
        if (list2.size() > 0 || list3.size() > 0) {
            this.writeClasspath(list2, list3, node2);
        }
        if (this.bundleProperties.getVMOptions() != null) {
            this.writeKeyStringPair("VMOptions", this.bundleProperties.getVMOptions(), node2);
        }
        if (this.bundleProperties.getWorkingDirectory() != null) {
            this.writeKeyStringPair("WorkingDirectory", this.bundleProperties.getWorkingDirectory(), node2);
        }
        if (this.bundleProperties.getArguments() != null) {
            this.writeKeyStringPair("Arguments", this.bundleProperties.getArguments(), node2);
        }
        if (!(hashtable = this.bundleProperties.getJavaProperties()).isEmpty()) {
            this.writeJavaProperties(hashtable, node2);
        }
    }

    private void writeDocumentTypes(List list, Node node) {
        this.writeKey("CFBundleDocumentTypes", node);
        Node node2 = this.createNode("array", node);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2;
            List list3;
            List list4;
            DocumentType documentType = (DocumentType)iterator.next();
            Node node3 = this.createNode("dict", node2);
            this.writeKeyStringPair("CFBundleTypeName", documentType.getName(), node3);
            this.writeKeyStringPair("CFBundleTypeRole", documentType.getRole(), node3);
            File file = documentType.getIconFile();
            if (file != null) {
                this.writeKeyStringPair("CFBundleTypeIconFile", file.getName(), node3);
            }
            if (!(list4 = documentType.getExtensions()).isEmpty()) {
                this.writeKey("CFBundleTypeExtensions", node3);
                this.writeArray(list4, node3);
            }
            if (!(list3 = documentType.getOSTypes()).isEmpty()) {
                this.writeKey("CFBundleTypeOSTypes", node3);
                this.writeArray(list3, node3);
            }
            if (!(list2 = documentType.getMimeTypes()).isEmpty()) {
                this.writeKey("CFBundleTypeMIMETypes", node3);
                this.writeArray(list2, node3);
            }
            if (!documentType.isBundle()) continue;
            this.writeKeyStringPair("LSTypeIsPackage", "true", node3);
        }
    }

    private void writeClasspath(List list, List list2, Node node) {
        this.writeKey("ClassPath", node);
        list.addAll(list2);
        this.writeArray(list, node);
    }

    private void writeJavaProperties(Hashtable hashtable, Node node) {
        this.writeKey("Properties", node);
        Node node2 = this.createNode("dict", node);
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.startsWith("com.apple.") && this.version >= 1.4) {
                System.out.println("Deprecated as of 1.4: " + string);
                continue;
            }
            this.writeKeyStringPair(string, (String)hashtable.get(string), node2);
        }
    }

    private Node createNode(String string, Node node) {
        Element element = this.document.createElement(string);
        node.appendChild(element);
        return element;
    }

    private void writeKeyStringPair(String string, String string2, Node node) {
        if (string2 == null) {
            return;
        }
        this.writeKey(string, node);
        this.writeString(string2, node);
    }

    private void writeKey(String string, Node node) {
        Element element = this.document.createElement("key");
        node.appendChild(element);
        element.appendChild(this.document.createTextNode(string));
    }

    private void writeString(String string, Node node) {
        Element element = this.document.createElement("string");
        element.appendChild(this.document.createTextNode(string));
        node.appendChild(element);
    }

    private void writeArray(List list, Node node) {
        Node node2 = this.createNode("array", node);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.writeString((String)iterator.next(), node2);
        }
    }
}

