/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.id3.ID3v22Frames;
import org.jaudiotagger.tag.id3.ID3v23Frame;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyDeprecated;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;

public class ID3v22Frame
extends AbstractID3v2Frame {
    Pattern validFrameIdentifier = Pattern.compile("[A-Z][0-9A-Z]{2}");
    protected static final int FRAME_ID_SIZE = 3;
    protected static final int FRAME_SIZE_SIZE = 3;
    protected static final int FRAME_HEADER_SIZE = 6;

    public ID3v22Frame() {
    }

    public ID3v22Frame(AbstractID3v2FrameBody body) {
        super(body);
    }

    public ID3v22Frame(String identifier) {
        String bodyIdentifier = identifier;
        this.identifier = identifier;
        if (ID3Tags.isID3v22FrameIdentifier(bodyIdentifier) && ID3Tags.forceFrameID22To23(bodyIdentifier) == null) {
            if (bodyIdentifier.equals("TYE") || bodyIdentifier.equals("TIM")) {
                bodyIdentifier = "TDRC";
            } else if (ID3Tags.isID3v22FrameIdentifier(bodyIdentifier)) {
                bodyIdentifier = ID3Tags.convertFrameID22To23(bodyIdentifier);
            }
        }
        try {
            Class<?> c = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + bodyIdentifier);
            this.frameBody = (AbstractID3v2FrameBody)c.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            this.frameBody = new FrameBodyUnsupported(identifier);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        this.frameBody.setHeader(this);
    }

    public ID3v22Frame(ID3v22Frame frame) {
        super(frame);
    }

    private void createV22FrameFromV23Frame(ID3v23Frame frame) throws InvalidFrameException {
        this.identifier = ID3Tags.convertFrameID23To22(frame.getIdentifier());
        if (this.identifier != null) {
            this.frameBody = (AbstractID3v2FrameBody)ID3Tags.copyObject(frame.getBody());
            return;
        }
        if (ID3Tags.isID3v23FrameIdentifier(frame.getIdentifier())) {
            this.identifier = ID3Tags.forceFrameID23To22(frame.getIdentifier());
            if (this.identifier != null) {
                this.frameBody = this.readBody(this.identifier, (AbstractID3v2FrameBody)frame.getBody());
                return;
            }
            throw new InvalidFrameException("Unable to convert v23 frame:" + frame.getIdentifier() + " to a v22 frame");
        }
        if (frame.getBody() instanceof FrameBodyDeprecated) {
            if (!ID3Tags.isID3v22FrameIdentifier(frame.getIdentifier())) {
                this.frameBody = new FrameBodyDeprecated((FrameBodyDeprecated)frame.getBody());
                this.identifier = frame.getIdentifier();
                return;
            }
        } else {
            this.frameBody = new FrameBodyUnsupported((FrameBodyUnsupported)frame.getBody());
            this.identifier = frame.getIdentifier();
            return;
        }
        this.frameBody = (FrameBodyDeprecated)frame.getBody();
        this.identifier = frame.getIdentifier();
    }

    public ID3v22Frame(AbstractID3v2Frame frame) throws InvalidFrameException {
        if (frame instanceof ID3v22Frame && !(frame instanceof ID3v23Frame)) {
            throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
        }
        if (frame instanceof ID3v24Frame) {
            ID3v23Frame v23Frame = new ID3v23Frame(frame);
            this.createV22FrameFromV23Frame(v23Frame);
        } else if (frame instanceof ID3v23Frame) {
            this.createV22FrameFromV23Frame((ID3v23Frame)frame);
        }
        this.frameBody.setHeader(this);
    }

    public ID3v22Frame(ByteBuffer byteBuffer, String loggingFilename) throws InvalidFrameException {
        this.setLoggingFilename(loggingFilename);
        this.read(byteBuffer);
    }

    public ID3v22Frame(ByteBuffer byteBuffer) throws InvalidFrameException {
        this(byteBuffer, "");
    }

    public int getSize() {
        return this.frameBody.getSize() + 6;
    }

    public void read(ByteBuffer byteBuffer) throws InvalidFrameException {
        byte[] buffer = new byte[3];
        if (byteBuffer.position() + 6 >= byteBuffer.limit()) {
            throw new InvalidFrameException(" No space to find another frame");
        }
        byteBuffer.get(buffer, 0, 3);
        this.identifier = new String(buffer);
        if (!this.isValidID3v2FrameIdentifier(this.identifier)) {
            byteBuffer.position(byteBuffer.position() - 2);
            throw new InvalidFrameIdentifierException(String.valueOf(this.identifier) + " is not a valid ID3v2.20 frame");
        }
        byteBuffer.get(buffer, 0, 3);
        this.frameSize = this.decodeSize(buffer);
        if (this.frameSize < 0) {
            throw new InvalidFrameException(String.valueOf(this.identifier) + " has invalid size of:" + this.frameSize);
        }
        if (this.frameSize == 0) {
            throw new EmptyFrameException(String.valueOf(this.identifier) + " is empty frame");
        }
        if (this.frameSize > byteBuffer.remaining()) {
            throw new InvalidFrameException(String.valueOf(this.identifier) + " is invalid frame");
        }
        String id = ID3Tags.convertFrameID22To24(this.identifier);
        if (id == null && (id = ID3Tags.convertFrameID22To23(this.identifier)) == null) {
            id = ID3Tags.isID3v22FrameIdentifier(this.identifier) ? this.identifier : "Unsupported";
        }
        ByteBuffer frameBodyBuffer = byteBuffer.slice();
        frameBodyBuffer.limit(this.frameSize);
        try {
            this.frameBody = this.readBody(id, frameBodyBuffer, this.frameSize);
        }
        finally {
            byteBuffer.position(byteBuffer.position() + this.frameSize);
        }
    }

    private int decodeSize(byte[] buffer) {
        BigInteger bi = new BigInteger(buffer);
        int tmpSize = bi.intValue();
        return tmpSize;
    }

    public void write(ByteArrayOutputStream tagBuffer) {
        ByteBuffer headerBuffer = ByteBuffer.allocate(6);
        ByteArrayOutputStream bodyOutputStream = new ByteArrayOutputStream();
        ((AbstractID3v2FrameBody)this.frameBody).write(bodyOutputStream);
        headerBuffer.put(Utils.getDefaultBytes(this.getIdentifier(), "ISO-8859-1"), 0, 3);
        this.encodeSize(headerBuffer, this.frameBody.getSize());
        try {
            tagBuffer.write(headerBuffer.array());
            tagBuffer.write(bodyOutputStream.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void encodeSize(ByteBuffer headerBuffer, int size) {
        headerBuffer.put((byte)((size & 0xFF0000) >> 16));
        headerBuffer.put((byte)((size & 0xFF00) >> 8));
        headerBuffer.put((byte)(size & 0xFF));
    }

    public boolean isValidID3v2FrameIdentifier(String identifier) {
        Matcher m = this.validFrameIdentifier.matcher(identifier);
        return m.matches();
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("frame", this.getIdentifier());
        MP3File.getStructureFormatter().addElement("frameSize", this.frameSize);
        this.frameBody.createStructure();
        MP3File.getStructureFormatter().closeHeadingElement("frame");
    }

    public boolean isCommon() {
        return ID3v22Frames.getInstanceOf().isCommon(this.getId());
    }

    public boolean isBinary() {
        return ID3v22Frames.getInstanceOf().isBinary(this.getId());
    }
}

