/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;

public abstract class Type
implements Serializable {
    protected byte type;
    protected String signature;
    public static final BasicType VOID = new BasicType(12);
    public static final BasicType BOOLEAN = new BasicType(4);
    public static final BasicType INT = new BasicType(10);
    public static final BasicType SHORT = new BasicType(9);
    public static final BasicType BYTE = new BasicType(8);
    public static final BasicType LONG = new BasicType(11);
    public static final BasicType DOUBLE = new BasicType(7);
    public static final BasicType FLOAT = new BasicType(6);
    public static final BasicType CHAR = new BasicType(5);
    public static final ObjectType OBJECT = new ObjectType("java.lang.Object");
    public static final ObjectType CLASS = new ObjectType("java.lang.Class");
    public static final ObjectType STRING = new ObjectType("java.lang.String");
    public static final ObjectType STRINGBUFFER = new ObjectType("java.lang.StringBuffer");
    public static final ObjectType THROWABLE = new ObjectType("java.lang.Throwable");
    public static final Type[] NO_ARGS = new Type[0];
    public static final ReferenceType NULL = new ReferenceType(){};
    public static final Type UNKNOWN = new Type(15, "<unknown object>"){};
    private static ThreadLocal consumed_chars = new ThreadLocal(){

        protected Object initialValue() {
            return new Integer(0);
        }
    };

    protected Type(byte t, String s) {
        this.type = t;
        this.signature = s;
    }

    public int hashCode() {
        return this.type ^ this.signature.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Type) {
            Type t = (Type)o;
            return this.type == t.type && this.signature.equals(t.signature);
        }
        return false;
    }

    public String getSignature() {
        return this.signature;
    }

    public byte getType() {
        return this.type;
    }

    public int getSize() {
        switch (this.type) {
            case 7: 
            case 11: {
                return 2;
            }
            case 12: {
                return 0;
            }
        }
        return 1;
    }

    public String toString() {
        return this.equals(NULL) || this.type >= 15 ? this.signature : Utility.signatureToString(this.signature, false);
    }

    public static String getMethodSignature(Type return_type, Type[] arg_types) {
        StringBuffer buf = new StringBuffer("(");
        int length = arg_types == null ? 0 : arg_types.length;
        int i = 0;
        while (i < length) {
            buf.append(arg_types[i].getSignature());
            ++i;
        }
        buf.append(')');
        buf.append(return_type.getSignature());
        return buf.toString();
    }

    private static int unwrap(ThreadLocal tl) {
        return (Integer)tl.get();
    }

    private static void wrap(ThreadLocal tl, int value) {
        tl.set(new Integer(value));
    }

    public static final Type getType(String signature) throws StringIndexOutOfBoundsException {
        byte type = Utility.typeOfSignature(signature);
        if (type <= 12) {
            Type.wrap(consumed_chars, 1);
            return BasicType.getType(type);
        }
        if (type == 13) {
            int dim = 0;
            while (signature.charAt(++dim) == '[') {
            }
            Type t = Type.getType(signature.substring(dim));
            int _temp = Type.unwrap(consumed_chars) + dim;
            Type.wrap(consumed_chars, _temp);
            return new ArrayType(t, dim);
        }
        int index = signature.indexOf(59);
        if (index < 0) {
            throw new ClassFormatException("Invalid signature: " + signature);
        }
        Type.wrap(consumed_chars, index + 1);
        return new ObjectType(signature.substring(1, index).replace('/', '.'));
    }

    public static Type getReturnType(String signature) {
        try {
            int index = signature.lastIndexOf(41) + 1;
            return Type.getType(signature.substring(index));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
    }

    public static Type[] getArgumentTypes(String signature) {
        ArrayList<Type> vec = new ArrayList<Type>();
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                vec.add(Type.getType(signature.substring(index)));
                index += Type.unwrap(consumed_chars);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature);
        }
        Type[] types = new Type[vec.size()];
        vec.toArray(types);
        return types;
    }

    public static Type getType(Class cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (cl.isArray()) {
            return Type.getType(cl.getName());
        }
        if (cl.isPrimitive()) {
            if (cl == Integer.TYPE) {
                return INT;
            }
            if (cl == Void.TYPE) {
                return VOID;
            }
            if (cl == Double.TYPE) {
                return DOUBLE;
            }
            if (cl == Float.TYPE) {
                return FLOAT;
            }
            if (cl == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (cl == Byte.TYPE) {
                return BYTE;
            }
            if (cl == Short.TYPE) {
                return SHORT;
            }
            if (cl == Byte.TYPE) {
                return BYTE;
            }
            if (cl == Long.TYPE) {
                return LONG;
            }
            if (cl == Character.TYPE) {
                return CHAR;
            }
            throw new IllegalStateException("Ooops, what primitive type is " + cl);
        }
        return new ObjectType(cl.getName());
    }

    public static Type[] getTypes(Class[] classes) {
        Type[] ret = new Type[classes.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = Type.getType(classes[i]);
            ++i;
        }
        return ret;
    }

    public static String getSignature(Method meth) {
        StringBuffer sb = new StringBuffer("(");
        Class<?>[] params = meth.getParameterTypes();
        int j = 0;
        while (j < params.length) {
            sb.append(Type.getType(params[j]).getSignature());
            ++j;
        }
        sb.append(")");
        sb.append(Type.getType(meth.getReturnType()).getSignature());
        return sb.toString();
    }
}

