/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.stat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.stat.Metric;
import test.net.sourceforge.pmd.stat.MockStatisticalRule;

public class StatisticalRuleTest
extends TestCase {
    private static final int POINTS = 100;
    private DataPoint[] points = new DataPoint[100];
    private MockStatisticalRule IUT = null;
    private String testName = null;
    private Random random = new Random();
    public static final double MAX_MINIMUM = 100.0;
    public static final double NO_MINIMUM = -1.0;
    public static final double MAX_SIGMA = 5.0;
    public static final double NO_SIGMA = -1.0;
    public static final int MIN_TOPSCORE = 0;
    public static final int NO_TOPSCORE = -1;
    public static final double MEAN = 49.5;
    public static final double SIGMA = 29.0115;
    public static final int NUM_TESTS = 1;
    public static final double DELTA = 0.005;

    public StatisticalRuleTest(String name) {
        super(name);
        this.testName = name;
    }

    public void setUp() {
        this.IUT = new MockStatisticalRule();
        if (this.testName.endsWith("0")) {
            int i = 0;
            while (i < 100) {
                this.points[i] = new DataPoint();
                this.points[i].setScore(1.0 * (double)i);
                this.points[i].setLineNumber(i);
                this.points[i].setMessage("DataPoint[" + Integer.toString(i) + "]");
                this.IUT.addDataPoint(this.points[i]);
                ++i;
            }
        } else if (this.testName.endsWith("1")) {
            int i = 99;
            while (i >= 0) {
                this.points[i] = new DataPoint();
                this.points[i].setScore(1.0 * (double)i);
                this.points[i].setLineNumber(i);
                this.points[i].setMessage("DataPoint[" + Integer.toString(i) + "]");
                this.IUT.addDataPoint(this.points[i]);
                --i;
            }
        } else {
            ArrayList<DataPoint> lPoints = new ArrayList<DataPoint>();
            int i = 0;
            while (i < 100) {
                DataPoint point = new DataPoint();
                point.setScore(1.0 * (double)i);
                point.setLineNumber(i);
                point.setMessage("DataPoint[" + Integer.toString(i) + "]");
                lPoints.add(point);
                ++i;
            }
            Collections.shuffle(lPoints);
            int i2 = 0;
            while (i2 < 100) {
                this.IUT.addDataPoint((DataPoint)lPoints.get(i2));
                ++i2;
            }
        }
    }

    public void testMetrics() throws Throwable {
        Report report = this.makeReport(this.IUT);
        Iterator metrics = report.metrics();
        Assert.assertTrue((boolean)metrics.hasNext());
        Object o = metrics.next();
        Assert.assertTrue((boolean)(o instanceof Metric));
        Metric m = (Metric)o;
        Assert.assertEquals((String)"test.net.sourceforge.pmd.stat.MockStatisticalRule", (String)m.getMetricName());
        Assert.assertEquals((double)0.0, (double)m.getLowValue(), (double)0.05);
        Assert.assertEquals((double)99.0, (double)m.getHighValue(), (double)0.05);
        Assert.assertEquals((double)49.5, (double)m.getAverage(), (double)0.05);
        Assert.assertEquals((double)29.0115, (double)m.getStandardDeviation(), (double)0.05);
    }

    public double randomSigma() {
        return this.random.nextDouble() * 1.0;
    }

    public double randomSigma(int minimum) {
        double minSigma = ((double)(99 - minimum) - 49.5) / 29.0115;
        if (minSigma <= 0.0 || minSigma > 2.0) {
            return this.randomSigma();
        }
        return minSigma + this.random.nextDouble() * (2.0 - minSigma);
    }

    public int expectedSigma(double sigma) {
        long expectedMin = Math.round(49.5 + sigma * 29.0115);
        if (99L - expectedMin < 0L) {
            return 0;
        }
        return 99 - (int)expectedMin;
    }

    public double randomMinimum() {
        return this.random.nextDouble() * 99.0;
    }

    public double randomMinimum(int minimum) {
        double diffTarget = 1.0 * (double)(99 - minimum);
        return this.random.nextDouble() * (double)minimum + diffTarget;
    }

    public int expectedMinimum(double minimum) {
        Double d = new Double(minimum);
        return 99 - d.intValue();
    }

    public void testExpectedMinimum() {
        int i = 0;
        while (i < 99) {
            Assert.assertEquals((String)"Integer Min", (int)(99 - i), (int)this.expectedMinimum((double)i * 1.0));
            Assert.assertEquals((String)"Double Min", (int)(99 - i), (int)this.expectedMinimum((double)i * 1.0 + 0.5));
            ++i;
        }
    }

    public int randomTopScore() {
        return this.random.nextInt(99);
    }

    public int randomTopScore(double target) {
        if (target < 0.0) {
            return 0;
        }
        return this.random.nextInt(new Double(target).intValue());
    }

    public int expectedTopScore(int target) {
        return target;
    }

    public void testSingleDatapoint() {
        MockStatisticalRule IUT = new MockStatisticalRule();
        DataPoint point = new DataPoint();
        point.setScore(101.0);
        point.setLineNumber(101);
        point.setMessage("SingleDataPoint");
        IUT.addProperty("minimum", Integer.toString(100));
        IUT.addDataPoint(point);
        Report report = this.makeReport(IUT);
        Assert.assertEquals((String)"Expecting only one result.", (int)1, (int)report.size());
    }

    public void testS() throws Throwable {
        this.verifyResults(5.0, -1.0, -1, 0, 2);
        int i = 0;
        while (i < 1) {
            double sigma = this.randomSigma();
            this.verifyResults(sigma, -1.0, -1, this.expectedSigma(sigma), 2);
            ++i;
        }
    }

    public void testS1() throws Throwable {
        this.testS();
    }

    public void testS2() throws Throwable {
        this.testS();
    }

    public void testS3() throws Throwable {
        this.testS();
    }

    public void testS4() throws Throwable {
        this.testS();
    }

    public void testS5() throws Throwable {
        this.testS();
    }

    public void testT() throws Throwable {
        this.verifyResults(-1.0, -1.0, 0, 0, 0);
        int i = 0;
        while (i < 1) {
            int topScore = this.randomTopScore();
            this.verifyResults(-1.0, -1.0, topScore, this.expectedTopScore(topScore), 0);
            ++i;
        }
    }

    public void testT1() throws Throwable {
        this.testT();
    }

    public void testT2() throws Throwable {
        this.testT();
    }

    public void testT3() throws Throwable {
        this.testT();
    }

    public void testT4() throws Throwable {
        this.testT();
    }

    public void testT5() throws Throwable {
        this.testT();
    }

    public void testM() throws Throwable {
        this.verifyResults(-1.0, 100.0, -1, 0, 0);
        int i = 0;
        while (i < 1) {
            double minimum = this.randomMinimum();
            this.verifyResults(-1.0, minimum, -1, this.expectedMinimum(minimum), 0);
            ++i;
        }
    }

    public void testM1() throws Throwable {
        this.testM();
    }

    public void testM2() throws Throwable {
        this.testM();
    }

    public void testM3() throws Throwable {
        this.testM();
    }

    public void testM4() throws Throwable {
        this.testM();
    }

    public void testM5() throws Throwable {
        this.testM();
    }

    public void testST() throws Throwable {
        this.verifyResults(this.randomSigma(), -1.0, 0, 0, 0);
        int i = 0;
        while (i < 1) {
            double sigma = this.randomSigma();
            int topScore = this.randomTopScore(this.expectedSigma(sigma));
            this.verifyResults(sigma, -1.0, topScore, this.expectedTopScore(topScore), 0);
            ++i;
        }
    }

    public void testST1() throws Throwable {
        this.testST();
    }

    public void testST2() throws Throwable {
        this.testST();
    }

    public void testST3() throws Throwable {
        this.testST();
    }

    public void testST4() throws Throwable {
        this.testST();
    }

    public void testST5() throws Throwable {
        this.testST();
    }

    public void testTS() throws Throwable {
        this.verifyResults(5.0, -1.0, this.randomTopScore(), 0, 0);
        int i = 0;
        while (i < 1) {
            int topScore = this.randomTopScore();
            double sigma = this.randomSigma(this.expectedTopScore(topScore));
            this.verifyResults(sigma, -1.0, topScore, this.expectedSigma(sigma), 2);
            ++i;
        }
    }

    public void testTS1() throws Throwable {
        this.testTS();
    }

    public void testTS2() throws Throwable {
        this.testTS();
    }

    public void testTS3() throws Throwable {
        this.testTS();
    }

    public void testTS4() throws Throwable {
        this.testTS();
    }

    public void testTS5() throws Throwable {
        this.testTS();
    }

    public void testSM() throws Throwable {
        this.verifyResults(this.randomSigma(), 100.0, -1, 0, 0);
        int i = 0;
        while (i < 1) {
            double sigma = this.randomSigma();
            double minimum = this.randomMinimum(this.expectedSigma(sigma));
            this.verifyResults(sigma, minimum, -1, this.expectedMinimum(minimum), 0);
            ++i;
        }
    }

    public void testSM1() throws Throwable {
        this.testSM();
    }

    public void testSM2() throws Throwable {
        this.testSM();
    }

    public void testSM3() throws Throwable {
        this.testSM();
    }

    public void testSM4() throws Throwable {
        this.testSM();
    }

    public void testSM5() throws Throwable {
        this.testSM();
    }

    public void testMS() throws Throwable {
        this.verifyResults(5.0, this.randomMinimum(), -1, 0, 0);
        int i = 0;
        while (i < 1) {
            double minimum = this.randomMinimum();
            double sigma = this.randomSigma(this.expectedMinimum(minimum));
            this.verifyResults(sigma, minimum, -1, this.expectedSigma(sigma), 2);
            ++i;
        }
    }

    public void testMS1() throws Throwable {
        this.testMS();
    }

    public void testMS2() throws Throwable {
        this.testMS();
    }

    public void testMS3() throws Throwable {
        this.testMS();
    }

    public void testMS4() throws Throwable {
        this.testMS();
    }

    public void testMS5() throws Throwable {
        this.testMS();
    }

    public void testTM() throws Throwable {
        this.verifyResults(-1.0, 100.0, this.randomTopScore(), 0, 0);
        int i = 0;
        while (i < 1) {
            int topScore = this.randomTopScore();
            double minimum = this.randomMinimum(this.expectedTopScore(topScore));
            this.verifyResults(-1.0, minimum, topScore, this.expectedMinimum(minimum), 0);
            ++i;
        }
    }

    public void testTM1() throws Throwable {
        this.testTM();
    }

    public void testTM2() throws Throwable {
        this.testTM();
    }

    public void testTM3() throws Throwable {
        this.testTM();
    }

    public void testTM4() throws Throwable {
        this.testTM();
    }

    public void testTM5() throws Throwable {
        this.testTM();
    }

    public void testMT() throws Throwable {
        this.verifyResults(-1.0, this.randomMinimum(), 0, 0, 0);
        int i = 0;
        while (i < 1) {
            double minimum = this.randomMinimum();
            int topScore = this.randomTopScore(this.expectedMinimum(minimum));
            this.verifyResults(-1.0, minimum, topScore, this.expectedTopScore(topScore), 0);
            ++i;
        }
    }

    public void testMT1() throws Throwable {
        this.testMT();
    }

    public void testMT2() throws Throwable {
        this.testMT();
    }

    public void testMT3() throws Throwable {
        this.testMT();
    }

    public void testMT4() throws Throwable {
        this.testMT();
    }

    public void testMT5() throws Throwable {
        this.testMT();
    }

    public void testSTM() throws Throwable {
        double sigma = this.randomSigma();
        this.verifyResults(sigma, 100.0, this.randomTopScore(this.expectedSigma(sigma)), 0, 0);
        int i = 0;
        while (i < 1) {
            sigma = this.randomSigma();
            int topScore = this.randomTopScore(this.expectedSigma(sigma));
            double minimum = this.randomMinimum(this.expectedTopScore(topScore));
            this.verifyResults(sigma, minimum, topScore, this.expectedMinimum(minimum), 0);
            ++i;
        }
    }

    public void testSTM1() throws Throwable {
        this.testSTM();
    }

    public void testSTM2() throws Throwable {
        this.testSTM();
    }

    public void testSTM3() throws Throwable {
        this.testSTM();
    }

    public void testSTM4() throws Throwable {
        this.testSTM();
    }

    public void testSTM5() throws Throwable {
        this.testSTM();
    }

    public void testSMT() throws Throwable {
        double sigma = this.randomSigma();
        this.verifyResults(sigma, this.randomMinimum(this.expectedSigma(sigma)), 0, 0, 0);
        int i = 0;
        while (i < 1) {
            sigma = this.randomSigma();
            double minimum = this.randomMinimum(this.expectedSigma(sigma));
            int topScore = this.randomTopScore(this.expectedMinimum(minimum));
            this.verifyResults(sigma, minimum, topScore, this.expectedTopScore(topScore), 0);
            ++i;
        }
    }

    public void testSMT1() throws Throwable {
        this.testSMT();
    }

    public void testSMT2() throws Throwable {
        this.testSMT();
    }

    public void testSMT3() throws Throwable {
        this.testSMT();
    }

    public void testSMT4() throws Throwable {
        this.testSMT();
    }

    public void testSMT5() throws Throwable {
        this.testSMT();
    }

    public void testTSM() throws Throwable {
        int topScore = this.randomTopScore();
        this.verifyResults(this.randomSigma(this.expectedTopScore(topScore)), 100.0, topScore, 0, 0);
        int i = 0;
        while (i < 1) {
            topScore = this.randomTopScore();
            double sigma = this.randomSigma(this.expectedTopScore(topScore));
            double minimum = this.randomMinimum(this.expectedSigma(sigma));
            this.verifyResults(sigma, minimum, topScore, this.expectedMinimum(minimum), 0);
            ++i;
        }
    }

    public void testTSM1() throws Throwable {
        this.testTSM();
    }

    public void testTSM2() throws Throwable {
        this.testTSM();
    }

    public void testTSM3() throws Throwable {
        this.testTSM();
    }

    public void testTSM4() throws Throwable {
        this.testTSM();
    }

    public void testTSM5() throws Throwable {
        this.testTSM();
    }

    public void testTMS() throws Throwable {
        int topScore = this.randomTopScore();
        this.verifyResults(5.0, this.randomMinimum(this.expectedTopScore(topScore)), topScore, 0, 0);
        int i = 0;
        while (i < 1) {
            topScore = this.randomTopScore();
            double minimum = this.randomMinimum(this.expectedTopScore(topScore));
            double sigma = this.randomSigma(this.expectedMinimum(minimum));
            this.verifyResults(sigma, minimum, topScore, this.expectedSigma(sigma), 2);
            ++i;
        }
    }

    public void testTMS1() throws Throwable {
        this.testTMS();
    }

    public void testTMS2() throws Throwable {
        this.testTMS();
    }

    public void testTMS3() throws Throwable {
        this.testTMS();
    }

    public void testTMS4() throws Throwable {
        this.testTMS();
    }

    public void testTMS5() throws Throwable {
        this.testTMS();
    }

    public void verifyResults(double sigma, double minimum, int topScore, int expected, int delta) {
        try {
            this.setUp();
            if (sigma >= 0.0) {
                this.IUT.addProperty("sigma", Double.toString(sigma));
            }
            if (minimum >= 0.0) {
                this.IUT.addProperty("minimum", Double.toString(minimum));
            }
            if (topScore >= 0) {
                this.IUT.addProperty("topscore", Integer.toString(topScore));
            }
            Report report = this.makeReport(this.IUT);
            if (delta == 0) {
                Assert.assertEquals((String)("Unexpected number of results: sigma= " + Double.toString(sigma) + " min= " + Double.toString(minimum) + " topscore= " + Integer.toString(topScore)), (int)expected, (int)report.size());
            } else {
                String assertStr = "Unexpected number of results: sigma= " + Double.toString(sigma) + " min= " + Double.toString(minimum) + " topscore= " + Integer.toString(topScore) + " expected= " + Integer.toString(expected) + " +/- " + Integer.toString(delta) + " actual-result= " + report.size();
                Assert.assertTrue((String)assertStr, (report.size() >= expected - delta ? 1 : 0) != 0);
                Assert.assertTrue((String)assertStr, (report.size() <= expected + delta ? 1 : 0) != 0);
            }
        }
        catch (AssertionFailedError afe) {
            System.err.println("******** " + this.testName + " ***********");
            if (sigma != -1.0) {
                System.err.println("SIGMA: " + Double.toString(sigma) + " EXPECT: " + Integer.toString(this.expectedSigma(sigma)));
            }
            if (minimum != -1.0) {
                System.err.println("MIN: " + Double.toString(minimum) + " EXPECT: " + Integer.toString(this.expectedMinimum(minimum)));
            }
            if (topScore != -1) {
                System.err.println("TOP: " + Integer.toString(topScore) + " EXPECT: " + Integer.toString(this.expectedTopScore(topScore)));
            }
            throw afe;
        }
    }

    public Report makeReport(Rule IUT) {
        ArrayList list = new ArrayList();
        Report report = new Report();
        RuleContext ctx = new RuleContext();
        ctx.setReport(report);
        ctx.setSourceCodeFilename(this.testName);
        IUT.apply(list, ctx);
        return report;
    }
}

