/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.rules;

import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.rules.AvoidDuplicateLiteralsRule;
import test.net.sourceforge.pmd.rules.RuleTst;

public class AvoidDuplicateLiteralsRuleTest
extends RuleTst {
    public static final String TEST1 = "public class Foo {" + CPD.EOL + " private void bar() {" + CPD.EOL + "    buz(\"Howdy\");" + CPD.EOL + "    buz(\"Howdy\");" + CPD.EOL + "    buz(\"Howdy\");" + CPD.EOL + "    buz(\"Howdy\");" + CPD.EOL + " }" + CPD.EOL + " private void buz(String x) {}" + CPD.EOL + "}";
    public static final String TEST2 = "public class Foo {" + CPD.EOL + " private void bar() {" + CPD.EOL + "    buz(2);" + CPD.EOL + " }" + CPD.EOL + " private void buz(int x) {}" + CPD.EOL + "}";
    public static final String TEST3 = "public class Foo {" + CPD.EOL + " private static final String FOO = \"foo\";" + CPD.EOL + "}";
    private AvoidDuplicateLiteralsRule rule;

    public void setUp() {
        this.rule = new AvoidDuplicateLiteralsRule();
        this.rule.setMessage("avoid ''{0}'' and ''{1}''");
        this.rule.addProperty("threshold", "2");
    }

    public void testTwoLiteralStringArgs() throws Throwable {
        this.runTestFromString(TEST1, 1, this.rule);
    }

    public void testLiteralIntArg() throws Throwable {
        this.runTestFromString(TEST2, 0, this.rule);
    }

    public void testLiteralFieldDecl() throws Throwable {
        this.runTestFromString(TEST3, 0, this.rule);
    }
}

