/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.cpd;

import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.XMLRenderer;

public class XMLRendererTest
extends TestCase {
    public void testRender_NoMatches() {
        XMLRenderer renderer = new XMLRenderer();
        ArrayList list = new ArrayList();
        String report = renderer.render(list.iterator());
        Assert.assertEquals((String)"<?xml version=\"1.0\"?><pmd-cpd></pmd-cpd>", (String)report);
    }

    public void testRender_Match() {
        XMLRenderer renderer = new XMLRenderer();
        ArrayList<Match> list = new ArrayList<Match>();
        Match match = new Match(75, new Mark(1, "/var/Foo.java", 1, 48), new Mark(2, "/var/Foo.java", 2, 73));
        match.setLineCount(6);
        match.setSourceCodeSlice("code fragment");
        list.add(match);
        String report = renderer.render(list.iterator());
        Assert.assertEquals((String)("<?xml version=\"1.0\"?><pmd-cpd><duplication lines=\"6\" tokens=\"75\"><file line=\"48\" path=\"/var/Foo.java\"/><file line=\"73\" path=\"/var/Foo.java\"/><codefragment><![CDATA[" + CPD.EOL + "code fragment" + CPD.EOL + "]]></codefragment></duplication></pmd-cpd>"), (String)report);
    }

    public void testRender_MultipleMatch() {
        XMLRenderer renderer = new XMLRenderer();
        ArrayList<Match> list = new ArrayList<Match>();
        Match match1 = new Match(75, new Mark(1, "/var/Foo.java", 1, 48), new Mark(2, "/var/Foo.java", 2, 73));
        match1.setLineCount(6);
        match1.setSourceCodeSlice("code fragment");
        Match match2 = new Match(76, new Mark(2, "/var/Foo2.java", 2, 49), new Mark(3, "/var/Foo2.java", 3, 74));
        match2.setLineCount(7);
        match2.setSourceCodeSlice("code fragment 2");
        list.add(match1);
        list.add(match2);
        String report = renderer.render(list.iterator());
        Assert.assertEquals((String)("<?xml version=\"1.0\"?><pmd-cpd><duplication lines=\"6\" tokens=\"75\"><file line=\"48\" path=\"/var/Foo.java\"/><file line=\"73\" path=\"/var/Foo.java\"/><codefragment><![CDATA[" + CPD.EOL + "code fragment" + CPD.EOL + "]]></codefragment></duplication><duplication lines=\"7\" tokens=\"76\"><file line=\"49\" path=\"/var/Foo2.java\"/><file line=\"74\" path=\"/var/Foo2.java\"/><codefragment><![CDATA[" + CPD.EOL + "code fragment 2" + CPD.EOL + "]]></codefragment></duplication></pmd-cpd>"), (String)report);
    }
}

