/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.ast;

import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import test.net.sourceforge.pmd.ast.ParserTst;

public class MethodDeclTest
extends ParserTst {
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;

    public void testPublic() throws Throwable {
        String[] access = new String[]{"public"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be public.", (boolean)amd.isPublic());
    }

    public void testPrivate() throws Throwable {
        String[] access = new String[]{"private"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be private.", (boolean)amd.isPrivate());
    }

    public void testProtected() throws Throwable {
        String[] access = new String[]{"protected"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be protected.", (boolean)amd.isProtected());
    }

    public void testFinal() throws Throwable {
        String[] access = new String[]{"public", "final"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be final.", (boolean)amd.isFinal());
        Assert.assertTrue((String)"Expecting method to be public.", (boolean)amd.isPublic());
    }

    public void testSynchronized() throws Throwable {
        String[] access = new String[]{"public", "synchronized"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be synchronized.", (boolean)amd.isSynchronized());
        Assert.assertTrue((String)"Expecting method to be public.", (boolean)amd.isPublic());
    }

    public void testAbstract() throws Throwable {
        String[] access = new String[]{"public", "abstract"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be abstract.", (boolean)amd.isAbstract());
        Assert.assertTrue((String)"Expecting method to be public.", (boolean)amd.isPublic());
    }

    public void testNative() throws Throwable {
        String[] access = new String[]{"private", "native"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be native.", (boolean)amd.isNative());
        Assert.assertTrue((String)"Expecting method to be private.", (boolean)amd.isPrivate());
    }

    public void testStrict() throws Throwable {
        String[] access = new String[]{"public", "strictfp"};
        ASTMethodDeclaration amd = this.getMethodDecl(access);
        Assert.assertTrue((String)"Expecting method to be strict.", (boolean)amd.isStrict());
        Assert.assertTrue((String)"Expecting method to be public.", (boolean)amd.isPublic());
    }

    public ASTMethodDeclaration getMethodDecl(String[] access) throws Throwable {
        String javaCode = "public class Test { ";
        int i = 0;
        while (i < access.length) {
            javaCode = javaCode + access[i] + " ";
            ++i;
        }
        javaCode = javaCode + " void stuff() { } }";
        Set methods = this.getNodes(class$net$sourceforge$pmd$ast$ASTMethodDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTMethodDeclaration = MethodDeclTest.class$("net.sourceforge.pmd.ast.ASTMethodDeclaration")) : class$net$sourceforge$pmd$ast$ASTMethodDeclaration, javaCode);
        Assert.assertEquals((String)"Wrong number of methods", (int)1, (int)methods.size());
        Iterator i2 = methods.iterator();
        return (ASTMethodDeclaration)i2.next();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

