/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.ast;

import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import net.sourceforge.pmd.ast.ASTClassDeclaration;
import test.net.sourceforge.pmd.ast.ParserTst;

public class ClassDeclTest
extends ParserTst {
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassDeclaration;

    public void testPublic() throws Throwable {
        String[] access = new String[]{"public"};
        ASTClassDeclaration acd = this.getClassDecl(access);
        this.verifyFlags(acd, true, false, false, false);
    }

    public void testAbstract() throws Throwable {
        String[] access = new String[]{"abstract"};
        ASTClassDeclaration acd = this.getClassDecl(access);
        this.verifyFlags(acd, false, true, false, false);
    }

    public void testFinal() throws Throwable {
        String[] access = new String[]{"final"};
        ASTClassDeclaration acd = this.getClassDecl(access);
        this.verifyFlags(acd, false, false, true, false);
    }

    public void testStrict() throws Throwable {
        String[] access = new String[]{"strictfp"};
        ASTClassDeclaration acd = this.getClassDecl(access);
        this.verifyFlags(acd, false, false, false, true);
    }

    public void testPublicFinal() throws Throwable {
        String[] access = new String[]{"public", "final"};
        ASTClassDeclaration acd = this.getClassDecl(access);
        this.verifyFlags(acd, true, false, true, false);
    }

    public void verifyFlags(ASTClassDeclaration acd, boolean bPublic, boolean bAbstract, boolean bFinal, boolean bStrict) {
        Assert.assertEquals((String)"Public: ", (boolean)bPublic, (boolean)acd.isPublic());
        Assert.assertEquals((String)"Abstract: ", (boolean)bAbstract, (boolean)acd.isAbstract());
        Assert.assertEquals((String)"Final: ", (boolean)bFinal, (boolean)acd.isFinal());
        Assert.assertEquals((String)"Strict: ", (boolean)bStrict, (boolean)acd.isStrict());
    }

    public ASTClassDeclaration getClassDecl(String[] access) throws Throwable {
        String javaCode = "";
        int i = 0;
        while (i < access.length) {
            javaCode = javaCode + access[i] + " ";
            ++i;
        }
        javaCode = javaCode + " class Test { } ";
        Set classes = this.getNodes(class$net$sourceforge$pmd$ast$ASTClassDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTClassDeclaration = ClassDeclTest.class$("net.sourceforge.pmd.ast.ASTClassDeclaration")) : class$net$sourceforge$pmd$ast$ASTClassDeclaration, javaCode);
        Assert.assertEquals((String)"Wrong number of classes", (int)1, (int)classes.size());
        Iterator i2 = classes.iterator();
        return (ASTClassDeclaration)i2.next();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

