/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import test.net.sourceforge.pmd.MockRule;

public class RuleViolationTest
extends TestCase {
    public void testConstructor1() {
        MockRule rule = new MockRule("name", "desc", "msg");
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("filename");
        RuleViolation r = new RuleViolation(rule, 2, ctx);
        Assert.assertEquals((String)"object mismatch", (Object)rule, (Object)r.getRule());
        Assert.assertEquals((String)"line number is wrong", (int)2, (int)r.getLine());
        Assert.assertEquals((String)"filename is wrong", (String)"filename", (String)r.getFilename());
    }

    public void testConstructor2() {
        MockRule rule = new MockRule("name", "desc", "msg");
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("filename");
        RuleViolation r = new RuleViolation(rule, 2, "description", ctx);
        Assert.assertEquals((String)"object mismatch", (Object)rule, (Object)r.getRule());
        Assert.assertEquals((String)"line number is wrong", (int)2, (int)r.getLine());
        Assert.assertEquals((String)"filename is wrong", (String)"filename", (String)r.getFilename());
        Assert.assertEquals((String)"description is wrong", (String)"description", (String)r.getDescription());
    }

    public void testComparatorWithDifferentFilenames() {
        MockRule rule = new MockRule("name", "desc", "msg");
        RuleViolation.RuleViolationComparator comp = new RuleViolation.RuleViolationComparator();
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("filename1");
        RuleViolation r1 = new RuleViolation(rule, 10, "description", ctx);
        ctx.setSourceCodeFilename("filename2");
        RuleViolation r2 = new RuleViolation(rule, 20, "description", ctx);
        Assert.assertEquals((int)-1, (int)comp.compare(r1, r2));
        Assert.assertEquals((int)1, (int)comp.compare(r2, r1));
    }

    public void testComparatorWithSameFileDifferentLines() {
        MockRule rule = new MockRule("name", "desc", "msg");
        RuleViolation.RuleViolationComparator comp = new RuleViolation.RuleViolationComparator();
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("filename");
        RuleViolation r1 = new RuleViolation(rule, 10, "description", ctx);
        RuleViolation r2 = new RuleViolation(rule, 20, "description", ctx);
        Assert.assertTrue((comp.compare(r1, r2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(r2, r1) > 0 ? 1 : 0) != 0);
    }

    public void testComparatorWithSameFileSameLines() {
        MockRule rule = new MockRule("name", "desc", "msg");
        RuleViolation.RuleViolationComparator comp = new RuleViolation.RuleViolationComparator();
        RuleContext ctx = new RuleContext();
        ctx.setSourceCodeFilename("filename");
        RuleViolation r1 = new RuleViolation(rule, 10, "description", ctx);
        RuleViolation r2 = new RuleViolation(rule, 10, "description", ctx);
        Assert.assertEquals((int)0, (int)comp.compare(r1, r2));
        Assert.assertEquals((int)0, (int)comp.compare(r2, r1));
    }
}

