/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd;

import java.io.ByteArrayInputStream;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;

public class RuleSetFactoryTest
extends TestCase {
    private static final String EOL = System.getProperty("line.separator", "\n");
    private static final String EMPTY_RULE_SET = "<?xml version=\"1.0\"?>" + EOL + "<ruleset name=\"test\">" + EOL + "<description>testdesc</description>" + EOL + "</ruleset>";
    private static final String SINGLE_RULE_SET = "<?xml version=\"1.0\"?>" + EOL + "<ruleset name=\"test\">" + EOL + "<description>" + EOL + "testdesc" + EOL + "</description>" + EOL + "<rule " + EOL + "name=\"MockRuleName\" " + EOL + "message=\"avoid the mock rule\" " + EOL + "class=\"test.net.sourceforge.pmd.MockRule\">" + "</rule></ruleset>";
    private static final String MULTIPLE_RULE_SET = "<?xml version=\"1.0\"?>" + EOL + "<ruleset name=\"test\">" + EOL + "<description>" + EOL + "testdesc" + EOL + "</description>" + EOL + "<rule name=\"MockRuleName1\" " + EOL + "message=\"avoid the mock rule\" " + EOL + "class=\"test.net.sourceforge.pmd.MockRule\">" + EOL + "</rule>" + EOL + "<rule name=\"MockRuleName2\" " + EOL + "message=\"avoid the mock rule\" " + EOL + "class=\"test.net.sourceforge.pmd.MockRule\">" + EOL + "</rule></ruleset>";
    private static final String RULE_WITH_PROPERTIES = "<?xml version=\"1.0\"?>" + EOL + "<ruleset name=\"test\">" + EOL + "<description>" + EOL + "testdesc" + EOL + "</description>" + EOL + "<rule name=\"MockRuleName\" " + EOL + "message=\"avoid the mock rule\" " + EOL + "class=\"test.net.sourceforge.pmd.MockRule\">" + EOL + "<description>" + EOL + "testdesc2" + EOL + "</description>" + EOL + "<properties>" + EOL + "<property name=\"fooBoolean\" value=\"true\"/>" + EOL + "<property name=\"fooDouble\" value=\"1.0\" />" + EOL + "<property name=\"foo\" value=\"bar\"/>" + EOL + "<property name=\"fooint\" value=\"2\"/>" + EOL + "</properties>" + EOL + "</rule></ruleset>";
    private static final String RULE_WITH_XPATH = "<?xml version=\"1.0\"?>" + EOL + "<ruleset name=\"test\">" + EOL + "<description>" + EOL + "testdesc" + EOL + "</description>" + EOL + "<priority>3</priority>" + EOL + "<rule name=\"MockRuleName\" " + EOL + "message=\"avoid the mock rule\" " + EOL + "class=\"test.net.sourceforge.pmd.MockRule\">" + EOL + "<description>" + EOL + "testdesc2" + EOL + "</description>" + EOL + "<properties>" + EOL + "<property name=\"xpath\">" + EOL + "<value>" + EOL + "<![CDATA[ //Block ]]>" + EOL + "</value>" + EOL + "</property>" + EOL + "</properties>" + EOL + "</rule></ruleset>";
    private static final String SINGLE_RULE_SET_WITH_PRIORITY = "<?xml version=\"1.0\"?>" + EOL + "<ruleset name=\"test\">" + EOL + "<description>" + EOL + "testdesc" + EOL + "</description>" + EOL + "<rule " + EOL + "name=\"MockRuleName\" " + EOL + "message=\"avoid the mock rule\" " + EOL + "class=\"test.net.sourceforge.pmd.MockRule\">" + "<priority>3</priority>" + EOL + "</rule></ruleset>";

    public void testSingleRuleWithPriority() {
        RuleSetFactory rsf = new RuleSetFactory();
        RuleSet rs = rsf.createRuleSet(new ByteArrayInputStream(SINGLE_RULE_SET_WITH_PRIORITY.getBytes()));
        Rule r = (Rule)rs.getRules().iterator().next();
        Assert.assertEquals((int)3, (int)r.getPriority());
    }

    public void testRuleSetNotFound() {
        RuleSetFactory rsf = new RuleSetFactory();
        try {
            rsf.createRuleSet("fooooo");
            throw new RuntimeException("Should have thrown a RuleSetNotFoundException");
        }
        catch (RuleSetNotFoundException rsnfe) {
            return;
        }
    }

    public void testCreateEmptyRuleSet() {
        RuleSetFactory rsf = new RuleSetFactory();
        RuleSet rs = rsf.createRuleSet(new ByteArrayInputStream(EMPTY_RULE_SET.getBytes()));
        Assert.assertEquals((String)"test", (String)rs.getName());
        Assert.assertEquals((int)0, (int)rs.size());
    }

    public void testSingleRule() {
        RuleSetFactory rsf = new RuleSetFactory();
        RuleSet rs = rsf.createRuleSet(new ByteArrayInputStream(SINGLE_RULE_SET.getBytes()));
        Assert.assertEquals((int)1, (int)rs.size());
        Rule r = (Rule)rs.getRules().iterator().next();
        Assert.assertEquals((String)"MockRuleName", (String)r.getName());
        Assert.assertEquals((String)"avoid the mock rule", (String)r.getMessage());
    }

    public void testMultipleRules() {
        RuleSetFactory rsf = new RuleSetFactory();
        RuleSet rs = rsf.createRuleSet(new ByteArrayInputStream(MULTIPLE_RULE_SET.getBytes()));
        Assert.assertEquals((int)2, (int)rs.size());
        HashSet<String> expected = new HashSet<String>();
        expected.add("MockRuleName1");
        expected.add("MockRuleName2");
        Iterator i = rs.getRules().iterator();
        while (i.hasNext()) {
            Assert.assertTrue((boolean)expected.contains(((Rule)i.next()).getName()));
        }
    }

    public void testProps() {
        RuleSetFactory rsf = new RuleSetFactory();
        RuleSet rs = rsf.createRuleSet(new ByteArrayInputStream(RULE_WITH_PROPERTIES.getBytes()));
        Rule r = (Rule)rs.getRules().iterator().next();
        Assert.assertTrue((boolean)r.hasProperty("foo"));
        Assert.assertEquals((String)"bar", (String)r.getStringProperty("foo"));
        Assert.assertEquals((int)2, (int)r.getIntProperty("fooint"));
        Assert.assertTrue((boolean)r.hasProperty("fooBoolean"));
        Assert.assertTrue((boolean)r.getBooleanProperty("fooBoolean"));
        Assert.assertTrue((boolean)r.hasProperty("fooDouble"));
        Assert.assertEquals((double)1.0, (double)r.getDoubleProperty("fooDouble"), (double)0.05);
        Assert.assertTrue((!r.hasProperty("BuggleFish") ? 1 : 0) != 0);
        Assert.assertTrue((r.getDescription().indexOf("testdesc2") != -1 ? 1 : 0) != 0);
    }

    public void testXPath() {
        RuleSetFactory rsf = new RuleSetFactory();
        RuleSet rs = rsf.createRuleSet(new ByteArrayInputStream(RULE_WITH_XPATH.getBytes()));
        Rule r = (Rule)rs.getRules().iterator().next();
        Assert.assertTrue((boolean)r.hasProperty("xpath"));
        Assert.assertEquals((String)" //Block ", (String)r.getStringProperty("xpath"));
    }
}

