/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.swingui.ResultsViewer;

class SearchResultsViewer
extends ResultsViewer {
    protected SearchResultsViewer() {
    }

    protected void analyze(File directory, RuleSet ruleSet) {
        ArrayList fileList = new ArrayList(20);
        FilesFilter fileFilter = new FilesFilter();
        this.buildFileList(directory, fileList, fileFilter);
        File[] sourceFiles = new File[fileList.size()];
        sourceFiles = fileList.toArray(sourceFiles);
        fileList.clear();
        this.analyze(sourceFiles, ruleSet);
    }

    private void buildFileList(File directory, List fileList, FileFilter fileFilter) {
        File[] files = directory.listFiles(fileFilter);
        int n = 0;
        while (n < files.length) {
            if (files[n].isDirectory()) {
                this.buildFileList(files[n], fileList, fileFilter);
            } else {
                fileList.add(files[n]);
            }
            files[n] = null;
            ++n;
        }
    }

    private class FilesFilter
    implements FileFilter {
        private String fileExtension = ".java";

        private FilesFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory() && !file.isHidden()) {
                return true;
            }
            if (file.isFile() && !file.isHidden()) {
                String fileName = file.getName().toLowerCase();
                return fileName.endsWith(this.fileExtension);
            }
            return false;
        }
    }
}

