/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.Color;
import java.io.StringWriter;
import java.util.Iterator;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleViolation;

class HTMLResultRenderer {
    private boolean m_reportNoViolations;
    private StringWriter m_writer;

    HTMLResultRenderer() {
    }

    protected void beginRendering(boolean reportNoViolations) {
        this.m_reportNoViolations = reportNoViolations;
        this.m_writer = new StringWriter(25000);
        this.m_writer.write("<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">\n");
        this.m_writer.write("<html>\n");
        this.m_writer.write("<head>\n");
        this.m_writer.write("<meta content=\"text/html; charset=iso-8859-1\">\n");
        this.m_writer.write("<title>PMD Analysis Results</title>\n");
        this.m_writer.write("</head>\n");
        this.m_writer.write("<body>\n");
    }

    protected String endRendering() {
        this.m_writer.write("</body>\n");
        this.m_writer.write("</html>\n");
        return this.m_writer.toString();
    }

    public void render(String fileName, Report report) {
        Iterator violations = report.iterator();
        if (!violations.hasNext()) {
            if (this.m_reportNoViolations) {
                this.m_writer.write("<b>Source File:</b> ");
                this.m_writer.write(fileName);
                this.m_writer.write("\n<p>\n");
                this.m_writer.write("No rule violations detected.<br>\n");
            }
            return;
        }
        this.m_writer.write("<b>Source File:</b> ");
        this.m_writer.write(fileName);
        this.m_writer.write("\n<br>\n");
        String hexValue = Integer.toHexString(Color.WHITE.getRGB());
        if (hexValue.startsWith("0x")) {
            hexValue = hexValue.substring(2);
        }
        if (hexValue.length() > 6) {
            hexValue = hexValue.substring(hexValue.length() - 6);
        }
        this.m_writer.write("<table bgcolor=\"#" + hexValue + "\" border>\n");
        this.m_writer.write("<tr>\n");
        this.m_writer.write("<th><b>Line<br>No.</b></th>\n");
        this.m_writer.write("<th><b>Rule</b></th>\n");
        this.m_writer.write("<th><b>Priority</b></th>\n");
        this.m_writer.write("<th><b>Description</b></th>\n");
        this.m_writer.write("<th><b>Example</b></th>\n");
        this.m_writer.write("</tr>\n");
        while (violations.hasNext()) {
            RuleViolation ruleViolation = (RuleViolation)violations.next();
            Rule rule = ruleViolation.getRule();
            this.m_writer.write("<tr>\n");
            this.m_writer.write("<td align=\"center\" valign=\"top\">\n");
            this.m_writer.write("<font size=\"3\">\n");
            this.m_writer.write(String.valueOf(ruleViolation.getLine()));
            this.m_writer.write("\n</font>\n");
            this.m_writer.write("</td>\n");
            String ruleMessage = ruleViolation.getDescription();
            if (ruleMessage == null) {
                ruleMessage = "";
            } else {
                this.removeNewLineCharacters(ruleMessage);
            }
            this.m_writer.write("<td align=\"left\" valign=\"top\">\n");
            this.m_writer.write("<font size=\"3\">\n");
            this.m_writer.write(ruleMessage);
            this.m_writer.write("\n</font>\n");
            this.m_writer.write("</td>\n");
            this.m_writer.write("<td align=\"left\" valign=\"top\">\n");
            this.m_writer.write("<font size=\"3\">\n");
            this.m_writer.write(rule.getPriorityName());
            this.m_writer.write("\n</font>\n");
            this.m_writer.write("</td>\n");
            String description = rule.getDescription();
            if (description == null) {
                description = "";
            } else {
                this.removeNewLineCharacters(description);
            }
            this.m_writer.write("<td align=\"left\" valign=\"top\">\n");
            this.m_writer.write("<font size=\"3\">\n");
            this.m_writer.write(description);
            this.m_writer.write("\n</font>\n");
            this.m_writer.write("</td>\n");
            String example = rule.getExample();
            if (example != null && example.length() > 0) {
                StringBuffer buffer = new StringBuffer(example);
                int n = buffer.length() - 1;
                while (n >= 0) {
                    if (buffer.charAt(n) != '\n') break;
                    buffer.deleteCharAt(n);
                    --n;
                }
                example = buffer.toString();
                this.m_writer.write("<td align=\"left\" valign=\"top\">\n");
                this.m_writer.write("<pre>\n");
                this.m_writer.write("<font size=\"-1\">");
                this.m_writer.write(example);
                this.m_writer.write("</font>");
                this.m_writer.write("\n</pre>\n");
                this.m_writer.write("</td>\n");
            }
            this.m_writer.write("</tr>\n");
        }
        this.m_writer.write("</table>\n");
        this.m_writer.write("<p><p>\n");
    }

    private String removeNewLineCharacters(String text) {
        int lastIndex;
        char[] chars = text.trim().toCharArray();
        int startIndex = 0;
        int n = 0;
        while (n < chars.length) {
            if (chars[n] != ' ' && chars[n] != '\n') {
                startIndex = n;
                break;
            }
            ++n;
        }
        int n2 = lastIndex = chars.length - 1;
        while (n2 >= 0) {
            if (chars[n2] != ' ' && chars[n2] != '\n') {
                lastIndex = n2;
                break;
            }
            --n2;
        }
        return String.valueOf(chars, startIndex, lastIndex + 1);
    }
}

