/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import net.sourceforge.pmd.ProjectFile;
import net.sourceforge.pmd.swingui.ComponentFactory;
import net.sourceforge.pmd.swingui.PMDViewer;
import net.sourceforge.pmd.swingui.Resources;

class AboutPMD
extends JDialog {
    protected AboutPMD(PMDViewer pmdViewer) {
        super(pmdViewer, "About PMD", true);
        this.initialize();
    }

    protected AboutPMD(JDialog dialog) {
        super(dialog, "About PMD", true);
        this.initialize();
    }

    private void initialize() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        int windowWidth = 750;
        int windowHeight = 500;
        int windowLocationX = (screenSize.width - windowWidth) / 2;
        int windowLocationY = (screenSize.height - windowHeight) / 2;
        this.setLocation(windowLocationX, windowLocationY);
        this.setSize(windowWidth, windowHeight);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        JPanel contentPanel = new JPanel(new BorderLayout());
        EmptyBorder emptyBorder = new EmptyBorder(10, 10, 10, 10);
        contentPanel.setBorder(emptyBorder);
        contentPanel.add((Component)this.createTabbedPane(), "Center");
        contentPanel.add((Component)this.createButtonPanel(), "South");
        JScrollPane scrollPane = ComponentFactory.createScrollPane(contentPanel);
        this.getContentPane().add(scrollPane);
    }

    private JPanel createButtonPanel() {
        JButton closeButton = new JButton("Close");
        closeButton.setForeground(Color.white);
        closeButton.setBackground(UIManager.getColor("pmdBlue"));
        closeButton.addActionListener(new CloseButtonActionListener());
        JPanel buttonPanel = ComponentFactory.createButtonPanel();
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    private JTabbedPane createTabbedPane() {
        JTabbedPane tabbedPane = new JTabbedPane(3);
        tabbedPane.addTab("About", this.createAboutPanel());
        tabbedPane.addTab("Info", this.createInfoPanel());
        tabbedPane.addTab("Credits", this.createCreditsPanel());
        tabbedPane.setFont(UIManager.getFont("tabFont"));
        return tabbedPane;
    }

    private JPanel createAboutPanel() {
        JPanel aboutPanel = new JPanel(new BorderLayout());
        ImageIcon imageIcon = (ImageIcon)UIManager.get("pmdLogoImage");
        JLabel imageLabel = new JLabel(imageIcon);
        aboutPanel.add((Component)imageLabel, "Center");
        JPanel bottomPanel = new JPanel(new GridLayout(2, 1));
        bottomPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        aboutPanel.add((Component)bottomPanel, "South");
        String versionText = Resources.getString("RESOURCEVersion") + " " + ProjectFile.getProperty("currentVersion");
        JLabel versionLabel = new JLabel(versionText);
        versionLabel.setFont(UIManager.getFont("labelFont"));
        versionLabel.setHorizontalAlignment(0);
        bottomPanel.add(versionLabel);
        String sourceForgeText = Resources.getString("RESOURCEDevelopedBySourceForgePMDTeam");
        JLabel sourceForgeLabel = new JLabel(sourceForgeText);
        sourceForgeLabel.setFont(UIManager.getFont("labelFont"));
        sourceForgeLabel.setHorizontalAlignment(0);
        bottomPanel.add(sourceForgeLabel);
        return aboutPanel;
    }

    private JPanel createInfoPanel() {
        GridBagLayout layout = new GridBagLayout();
        JPanel infoPanel = new JPanel(layout);
        int row = 0;
        this.addName("Java Runtime Environment Version", row, infoPanel);
        this.addValue(System.getProperty("java.version"), row, infoPanel);
        this.addName("Java Runtime Environment Vendor", ++row, infoPanel);
        this.addValue(System.getProperty("java.vendor"), row, infoPanel);
        this.addName("Java Installation Directory", ++row, infoPanel);
        this.addValue(System.getProperty("java.home"), row, infoPanel);
        this.addName("Java ClassPath", ++row, infoPanel);
        this.addMultiLineValue(System.getProperty("java.class.path"), row, 5, infoPanel);
        this.addName("Operating System Name", row += 5, infoPanel);
        this.addValue(System.getProperty("os.name"), row, infoPanel);
        this.addName("Operating System Architecture", ++row, infoPanel);
        this.addValue(System.getProperty("os.arch"), row, infoPanel);
        this.addName("Operating System Version", ++row, infoPanel);
        this.addValue(System.getProperty("os.version"), row, infoPanel);
        this.addName("User's Home Directory", ++row, infoPanel);
        this.addValue(System.getProperty("user.home"), row, infoPanel);
        this.addName("User's Current Working Director", ++row, infoPanel);
        this.addValue(System.getProperty("user.dir"), row, infoPanel);
        this.addName("VM Total Memory", ++row, infoPanel);
        long totalMemory = Runtime.getRuntime().totalMemory() / 1024L;
        String totalMemoryText = DecimalFormat.getNumberInstance().format(totalMemory) + "KB";
        this.addValue(totalMemoryText, row, infoPanel);
        this.addName("VM Free Memory", ++row, infoPanel);
        long freeMemory = Runtime.getRuntime().freeMemory() / 1024L;
        String freeMemoryText = DecimalFormat.getNumberInstance().format(freeMemory) + "KB";
        this.addValue(freeMemoryText, row, infoPanel);
        this.addName("VM Used Memory", ++row, infoPanel);
        long usedMemory = totalMemory - freeMemory;
        String usedMemoryText = DecimalFormat.getNumberInstance().format(usedMemory) + "KB";
        this.addValue(usedMemoryText, row, infoPanel);
        return infoPanel;
    }

    private void addName(String name, int row, JPanel infoPanel) {
        JLabel label = new JLabel(name, 4);
        label.setFont(UIManager.getFont("labelFont"));
        label.setHorizontalAlignment(4);
        label.setForeground(UIManager.getColor("pmdBlue"));
        GridBagLayout layout = (GridBagLayout)infoPanel.getLayout();
        GridBagConstraints constraints = layout.getConstraints(label);
        constraints.gridx = 0;
        constraints.gridy = row;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        infoPanel.add((Component)label, constraints);
    }

    private void addValue(String value, int row, JPanel infoPanel) {
        JLabel label = new JLabel(value, 2);
        label.setFont(UIManager.getFont("dataFont"));
        GridBagLayout layout = (GridBagLayout)infoPanel.getLayout();
        GridBagConstraints constraints = layout.getConstraints(label);
        constraints.gridx = 1;
        constraints.gridy = row;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(2, 2, 2, 2);
        infoPanel.add((Component)label, constraints);
    }

    private void addMultiLineValue(String value, int row, int lines, JPanel infoPanel) {
        JTextArea textArea = ComponentFactory.createTextArea(value);
        textArea.setBackground(Color.lightGray);
        JScrollPane scrollPane = ComponentFactory.createScrollPane(textArea);
        Font font = textArea.getFont();
        FontMetrics fontMetrics = textArea.getFontMetrics(font);
        int width = 500;
        int height = lines * fontMetrics.getHeight() + 5;
        Dimension size = new Dimension(width, height);
        scrollPane.setSize(size);
        scrollPane.setMinimumSize(size);
        scrollPane.setPreferredSize(size);
        GridBagLayout layout = (GridBagLayout)infoPanel.getLayout();
        GridBagConstraints constraints = layout.getConstraints(scrollPane);
        constraints.gridx = 1;
        constraints.gridy = row;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 1;
        constraints.insets = new Insets(2, 2, 2, 2);
        infoPanel.add((Component)scrollPane, constraints);
    }

    private JPanel createCreditsPanel() {
        JPanel parentPanel = new JPanel(new BorderLayout());
        JLabel title = new JLabel("The SourceForge PMD Project Team");
        EtchedBorder etchedBorder = new EtchedBorder(0);
        CompoundBorder compoundBorder = new CompoundBorder(etchedBorder, etchedBorder);
        EmptyBorder emptyBorder = new EmptyBorder(10, 10, 10, 10);
        compoundBorder = new CompoundBorder(emptyBorder, compoundBorder);
        compoundBorder = new CompoundBorder(compoundBorder, emptyBorder);
        title.setBorder(compoundBorder);
        title.setFont(UIManager.getFont("label16Font"));
        title.setHorizontalAlignment(0);
        title.setForeground(UIManager.getColor("pmdRed"));
        parentPanel.add((Component)title, "North");
        GridBagLayout layout = new GridBagLayout();
        JPanel creditsPanel = new JPanel(layout);
        parentPanel.add((Component)creditsPanel, "Center");
        int row = 0;
        this.addTitle("Project Administrators", row, creditsPanel);
        this.addPerson("Tom Copeland", row, creditsPanel);
        this.addPerson("David Craine", ++row, creditsPanel);
        this.addPerson("David Dixon-Peugh", ++row, creditsPanel);
        this.addTitle(" ", ++row, creditsPanel);
        String developerNameKey = "developers/developer/name";
        String developerSelectKey = "developers/developer/roles/role";
        String selectValue = "developer";
        String[] developers = this.getPeople(developerNameKey, developerSelectKey, selectValue);
        this.addTitle("Developers", ++row, creditsPanel);
        --row;
        int n = 0;
        while (n < developers.length) {
            this.addPerson(developers[n], ++row, creditsPanel);
            ++n;
        }
        this.addTitle(" ", ++row, creditsPanel);
        String[] contributors = this.getPeople("contributors/contributor/name", null, null);
        this.addTitle("Contributors", ++row, creditsPanel);
        --row;
        int n2 = 0;
        while (n2 < contributors.length) {
            this.addPerson(contributors[n2], ++row, creditsPanel);
            ++n2;
        }
        return parentPanel;
    }

    private void addTitle(String name, int row, JPanel creditsPanel) {
        JLabel label = new JLabel(name, 4);
        label.setFont(UIManager.getFont("label14Font"));
        label.setHorizontalAlignment(4);
        label.setForeground(UIManager.getColor("pmdBlue"));
        GridBagLayout layout = (GridBagLayout)creditsPanel.getLayout();
        GridBagConstraints constraints = layout.getConstraints(label);
        constraints.gridx = 0;
        constraints.gridy = row;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 2, 0, 2);
        creditsPanel.add((Component)label, constraints);
    }

    private void addPerson(String value, int row, JPanel creditsPanel) {
        JLabel label = new JLabel(value, 2);
        label.setFont(UIManager.getFont("serif14Font"));
        GridBagLayout layout = (GridBagLayout)creditsPanel.getLayout();
        GridBagConstraints constraints = layout.getConstraints(label);
        constraints.gridx = 1;
        constraints.gridy = row;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 2, 0, 2);
        creditsPanel.add((Component)label, constraints);
    }

    private String[] getPeople(String nameKey, String selectKey, String selectValue) {
        String nameList = ProjectFile.getProperty(nameKey);
        String[] names = ProjectFile.toArray(nameList);
        if (selectKey != null && selectValue != null) {
            String selectList = ProjectFile.getProperty(selectKey);
            String[] selections = ProjectFile.toArray(selectList);
            ArrayList<String> tempNameList = new ArrayList<String>();
            int n = 0;
            while (n < names.length) {
                if (n < selections.length && selections[n].equalsIgnoreCase(selectValue)) {
                    tempNameList.add(names[n]);
                }
                selections[n] = null;
                names[n] = null;
                ++n;
            }
            names = new String[tempNameList.size()];
            tempNameList.toArray(names);
            tempNameList.clear();
        }
        Arrays.sort(names, new PeopleNameComparator());
        return names;
    }

    private class CloseButtonActionListener
    implements ActionListener {
        private CloseButtonActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            AboutPMD.this.setVisible(false);
        }
    }

    private class PeopleNameComparator
    implements Comparator {
        private PeopleNameComparator() {
        }

        public int compare(Object object1, Object object2) {
            String name1 = (String)object1;
            String name2 = (String)object2;
            int index = name1.lastIndexOf(32) + 1;
            if (index >= 0) {
                name1 = name1.substring(index).concat(name1);
            }
            if ((index = name2.lastIndexOf(32) + 1) >= 0) {
                name2 = name2.substring(index).concat(name2);
            }
            return name1.compareToIgnoreCase(name2);
        }

        public boolean compare(Object object) {
            return object == this;
        }
    }
}

