/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.rules.ImportWrapper;

public class DuplicateImportsRule
extends AbstractRule {
    private Set singleTypeImports;
    private Set importOnDemandImports;

    public Object visit(ASTCompilationUnit node, Object data) {
        RuleContext ctx = (RuleContext)data;
        this.singleTypeImports = new HashSet();
        this.importOnDemandImports = new HashSet();
        super.visit(node, data);
        Iterator i = this.importOnDemandImports.iterator();
        while (i.hasNext()) {
            ImportWrapper thisImportOnDemand = (ImportWrapper)i.next();
            Iterator j = this.singleTypeImports.iterator();
            while (j.hasNext()) {
                ImportWrapper thisSingleTypeImport = (ImportWrapper)j.next();
                String singleTypePkg = thisSingleTypeImport.getName().substring(0, thisSingleTypeImport.getName().lastIndexOf("."));
                if (!thisImportOnDemand.getName().equals(singleTypePkg)) continue;
                String msg = MessageFormat.format(this.getMessage(), thisSingleTypeImport.getName());
                ctx.getReport().addRuleViolation(this.createRuleViolation(ctx, thisSingleTypeImport.getLine(), msg));
            }
        }
        this.singleTypeImports.clear();
        this.importOnDemandImports.clear();
        return data;
    }

    public Object visit(ASTImportDeclaration node, Object data) {
        ImportWrapper wrapper = new ImportWrapper(node.getImportedNameNode().getImage(), node.getImportedNameNode().getBeginLine());
        if (node.isImportOnDemand()) {
            if (this.importOnDemandImports.contains(wrapper)) {
                this.createRV((RuleContext)data, node.getImportedNameNode());
            } else {
                this.importOnDemandImports.add(wrapper);
            }
        } else if (this.singleTypeImports.contains(wrapper)) {
            this.createRV((RuleContext)data, node.getImportedNameNode());
        } else {
            this.singleTypeImports.add(wrapper);
        }
        return data;
    }

    private void createRV(RuleContext ctx, SimpleNode importNameNode) {
        String msg = MessageFormat.format(this.getMessage(), importNameNode.getImage());
        ctx.getReport().addRuleViolation(this.createRuleViolation(ctx, importNameNode.getBeginLine(), msg));
    }
}

