/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.cpd.cppast.CPPParser;
import net.sourceforge.pmd.cpd.cppast.CPPParserTokenManager;
import net.sourceforge.pmd.cpd.cppast.Token;
import net.sourceforge.pmd.cpd.cppast.TokenMgrError;

public class CPPTokenizer
implements Tokenizer {
    protected String EOL = System.getProperty("line.separator", "\n");
    private static boolean initted;

    /*
     * WARNING - void declaration
     */
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries, Reader input) throws IOException {
        try {
            String currentLine;
            ArrayList<void> lines = new ArrayList<void>();
            StringBuffer sb = new StringBuffer();
            LineNumberReader r = new LineNumberReader(input);
            while ((currentLine = r.readLine()) != null) {
                void var7_9;
                lines.add(var7_9);
                sb.append((String)var7_9);
                sb.append(this.EOL);
            }
            sourceCode.setCode(lines);
            if (!initted) {
                new CPPParser(new StringReader(sb.toString()));
                initted = true;
            }
            CPPParser.ReInit(new StringReader(sb.toString()));
            Token currToken = CPPParserTokenManager.getNextToken();
            int count = 0;
            while (currToken.image != "") {
                tokenEntries.add(new TokenEntry(currToken.image, ++count, sourceCode.getFileName(), currToken.beginLine));
                currToken = CPPParserTokenManager.getNextToken();
            }
            tokenEntries.add(TokenEntry.EOF);
            System.out.println("Added " + sourceCode.getFileName());
        }
        catch (TokenMgrError err) {
            System.out.println("Skipping " + sourceCode.getFileName() + " due to parse error");
            ArrayList<String> emptyCode = new ArrayList<String>();
            emptyCode.add("");
            sourceCode.setCode(emptyCode);
            tokenEntries.add(TokenEntry.EOF);
        }
    }
}

