/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CPDNullListener;
import net.sourceforge.pmd.cpd.FileFinder;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.MatchAlgorithm;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.Tokens;

public class CPD {
    public static final String EOL = System.getProperty("line.separator", "\n");
    private Map source = new HashMap();
    private CPDListener listener = new CPDNullListener();
    private Tokens tokens = new Tokens();
    private int minimumTileSize;
    private MatchAlgorithm matchAlgorithm;
    private Language language;

    public CPD(int minimumTileSize, Language language) {
        this.minimumTileSize = minimumTileSize;
        this.language = language;
    }

    public void setCpdListener(CPDListener cpdListener) {
        this.listener = cpdListener;
    }

    public void go() {
        this.matchAlgorithm = new MatchAlgorithm(this.source, this.tokens);
        this.matchAlgorithm.setListener(this.listener);
        this.matchAlgorithm.findMatches(this.minimumTileSize);
    }

    public Iterator getMatches() {
        return this.matchAlgorithm.matches();
    }

    public void add(File file) throws IOException {
        this.add(1, file);
    }

    public void addAllInDirectory(String dir) throws IOException {
        this.addDirectory(dir, false);
    }

    public void addRecursively(String dir) throws IOException {
        this.addDirectory(dir, true);
    }

    public void add(List files) throws IOException {
        Iterator i = files.iterator();
        while (i.hasNext()) {
            this.add(files.size(), (File)i.next());
        }
    }

    private void addDirectory(String dir, boolean recurse) throws IOException {
        FileFinder finder = new FileFinder();
        this.add(finder.findFilesFrom(dir, this.language.getFileFilter(), recurse));
    }

    private void add(int fileCount, File file) throws IOException {
        this.listener.addedFile(fileCount, file);
        SourceCode sourceCode = new SourceCode(file.getAbsolutePath());
        FileReader reader = new FileReader(file);
        this.language.getTokenizer().tokenize(sourceCode, this.tokens, reader);
        reader.close();
        this.source.put(sourceCode.getFileName(), sourceCode);
    }

    public static void main(String[] args) {
        if (args.length > 3 || args.length < 2) {
            CPD.usage();
            System.exit(1);
        }
        try {
            String lang = "java";
            if (args.length == 3) {
                lang = args[2];
            }
            LanguageFactory f = new LanguageFactory();
            Language language = f.createLanguage(lang);
            CPD cpd = new CPD(Integer.parseInt(args[0]), language);
            cpd.addRecursively(args[1]);
            long start = System.currentTimeMillis();
            cpd.go();
            long total = System.currentTimeMillis() - start;
            System.out.println(new SimpleRenderer().render(cpd.getMatches()));
            System.out.println("That took " + total + " milliseconds");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD <tile size> <directory> [<language>]");
        System.out.println("i.e: ");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD 100 c:\\jdk14\\src\\java ");
        System.out.println("or: ");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD 100 c:\\apache\\src\\ cpp");
    }
}

