/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.swingui.Resources;

public class RuleSetList {
    private static final String RULE_SET_LIST_FILE_NAME = "Included_Rule_Set_Names.txt";

    public static final String[] getIncludedRuleSetNames(String directoryPath) throws PMDException {
        File file;
        String[] ruleSetNames = new String[]{};
        if (directoryPath != null && (file = new File((directoryPath = directoryPath.trim()) + File.separator + RULE_SET_LIST_FILE_NAME)).exists()) {
            BufferedReader inputStream = null;
            try {
                inputStream = new BufferedReader(new FileReader(file));
                String ruleSetNameList = inputStream.readLine();
                StringTokenizer parser = new StringTokenizer(ruleSetNameList, ",");
                ruleSetNames = new String[parser.countTokens()];
                int index = 0;
                while (parser.hasMoreTokens()) {
                    ruleSetNames[index] = parser.nextToken().trim();
                    ++index;
                }
            }
            catch (FileNotFoundException exception) {
                String message = Resources.getString("RESOURCE_RuleSetListFileNotFound");
                PMDException pmdException = new PMDException(message, exception);
                pmdException.fillInStackTrace();
                throw pmdException;
            }
            catch (IOException exception) {
                String message = Resources.getString("RESOURCE_RuleSetListFileIOError");
                PMDException pmdException = new PMDException(message, exception);
                pmdException.fillInStackTrace();
                throw pmdException;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException exception) {
                        inputStream = null;
                    }
                }
            }
        }
        return ruleSetNames;
    }

    public static final void saveIncludedRuleSetNames(String directoryPath, String[] ruleSetNames) throws PMDException {
        if (directoryPath != null && ruleSetNames != null) {
            File file = new File((directoryPath = directoryPath.trim()) + File.separator + RULE_SET_LIST_FILE_NAME);
            if (file.exists()) {
                file.delete();
            } else {
                File directory = new File(directoryPath);
                directory.mkdirs();
            }
            PrintWriter outputStream = null;
            try {
                try {
                    outputStream = new PrintWriter(new FileWriter(file));
                    StringBuffer buffer = new StringBuffer(100);
                    int n = 0;
                    while (n < ruleSetNames.length) {
                        buffer.append(ruleSetNames[n]);
                        buffer.append(',');
                        ++n;
                    }
                    if (buffer.length() > 0) {
                        buffer.setLength(buffer.length() - 1);
                    }
                    outputStream.println(buffer.toString());
                }
                catch (FileNotFoundException exception) {
                    String message = Resources.getString("RESOURCE_RuleSetListFileNotFound");
                    PMDException pmdException = new PMDException(message, exception);
                    pmdException.fillInStackTrace();
                    throw pmdException;
                }
                catch (IOException exception) {
                    String message = Resources.getString("RESOURCE_RuleSetListFileIOError");
                    PMDException pmdException = new PMDException(message, exception);
                    pmdException.fillInStackTrace();
                    throw pmdException;
                }
                Object var9_9 = null;
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (outputStream != null) {
                    outputStream.close();
                }
                throw throwable;
            }
        }
    }
}

