/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;

public class RuleSet {
    private Set rules = new HashSet();
    private String name;
    private String description;
    private boolean m_include;
    private String m_fileName;

    public int size() {
        return this.rules.size();
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public Set getRules() {
        return this.rules;
    }

    public Rule getRuleByName(String ruleName) {
        Iterator i = this.rules.iterator();
        while (i.hasNext()) {
            Rule r = (Rule)i.next();
            if (!r.getName().equals(ruleName)) continue;
            return r;
        }
        throw new RuntimeException("Couldn't find rule named " + ruleName + " in the ruleset " + this.name);
    }

    public void addRuleSet(RuleSet ruleSet) {
        this.rules.addAll(ruleSet.getRules());
    }

    public void apply(List acuList, RuleContext ctx) {
        Iterator rs = this.rules.iterator();
        while (rs.hasNext()) {
            Rule rule = (Rule)rs.next();
            rule.apply(acuList, ctx);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean include() {
        return this.m_include;
    }

    public void setInclude(boolean include) {
        this.m_include = include;
    }

    public String getFileName() {
        if (this.m_fileName == null) {
            this.m_fileName = this.name.toLowerCase().replace(' ', '_') + ".xml";
        }
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        if (fileName != null && (fileName = fileName.trim()).length() == 0) {
            fileName = null;
        }
        this.m_fileName = fileName;
    }
}

