/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.pmd.util.ResourceLoader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectFile {
    private static Properties PROPERTIES;
    private static Exception PARSE_EXCEPTION;
    private static final String VALUE_SEPARATOR = "&vs;";

    public static final String getProperty(String key) {
        String value;
        String string = key = key == null ? "" : key.trim().toLowerCase();
        if (PROPERTIES == null) {
            new ProjectFile().loadProperties();
        }
        return (value = PROPERTIES.getProperty(key)) == null ? "" : value;
    }

    public static final Enumeration getPropertyKeys() {
        return PROPERTIES.propertyNames();
    }

    public static final int getPropertyCount() {
        int count = 0;
        Enumeration<?> keys = PROPERTIES.propertyNames();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++count;
        }
        return count;
    }

    public static final String[] toArray(String propertyValue) {
        String[] values = new String[]{};
        if (propertyValue != null) {
            StringTokenizer parser = new StringTokenizer(propertyValue, VALUE_SEPARATOR);
            int valueCount = parser.countTokens();
            values = new String[valueCount];
            int index = 0;
            while (parser.hasMoreTokens()) {
                values[index] = parser.nextToken();
                ++index;
            }
        }
        return values;
    }

    public static final Exception getException() {
        return PARSE_EXCEPTION;
    }

    private void loadProperties() {
        PROPERTIES = new Properties();
        try {
            InputStream inputStream = ResourceLoader.loadResourceAsStream("project.xml");
            InputSource inputSource = new InputSource(inputStream);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            factory.setFeature("http://xml.org/sax/features/namespaces", false);
            SAXParser parser = factory.newSAXParser();
            MainContentHandler mainContentHandler = new MainContentHandler();
            parser.parse(inputSource, (DefaultHandler)mainContentHandler);
        }
        catch (Exception exception) {
            PARSE_EXCEPTION = exception;
        }
    }

    private class MainContentHandler
    extends DefaultHandler {
        private StringBuffer m_buffer = new StringBuffer(100);
        private Stack m_nameStack = new Stack();
        private final String PROJECT = "project";

        private MainContentHandler() {
        }

        public void startElement(String namespace, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            if (!qualifiedName.equalsIgnoreCase("project")) {
                this.m_nameStack.push(qualifiedName);
            }
        }

        public void characters(char[] chars, int beginIndex, int length) {
            this.m_buffer.append(chars, beginIndex, length);
        }

        public void endElement(String namespace, String localName, String qualifiedName) throws SAXException {
            String value = this.m_buffer.toString().replace('\n', ' ').trim();
            String key = this.buildKey();
            String existingValue = PROPERTIES.getProperty(key);
            if (existingValue != null) {
                value = existingValue + ProjectFile.VALUE_SEPARATOR + value;
            }
            PROPERTIES.setProperty(key, value);
            this.m_buffer.setLength(0);
            this.m_nameStack.pop();
        }

        private String buildKey() {
            StringBuffer name = new StringBuffer(100);
            Iterator iterator = this.m_nameStack.iterator();
            while (iterator.hasNext()) {
                name.append(iterator.next());
                name.append('/');
            }
            if (name.length() > 0) {
                name.setLength(name.length() - 1);
            }
            return name.toString().toLowerCase();
        }
    }
}

