/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.ant.gettext;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.xnap.commons.ant.gettext.AbstractGettextTask;
import org.xnap.commons.ant.gettext.GettextUtils;

public abstract class AbstractGettextGenerateTask
extends AbstractGettextTask {
    protected String msgcatCmd = "msgcat";
    protected String msgfmtCmd = "msgfmt";
    protected String targetBundle = "Messages";
    protected String outputFormat = "class";
    protected String javaVersion = "2";
    protected String outputDirectory;
    protected Vector poFiles = new Vector();

    public void setMsgcatCmd(String string) {
        this.msgcatCmd = string;
    }

    public void setMsgfmtCmd(String string) {
        this.msgfmtCmd = string;
    }

    public void setTargetBundle(String string) {
        this.targetBundle = string;
    }

    public void setOutputFormat(String string) {
        this.outputFormat = string;
    }

    public void setJavaVersion(String string) {
        this.javaVersion = string;
    }

    public void setOutputDirectory(String string) {
        this.outputDirectory = string;
    }

    public void addFileSet(FileSet fileSet) {
        this.poFiles.add(fileSet);
    }

    protected String[] getPoFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.poFiles.isEmpty()) {
            Iterator iterator = this.poFiles.iterator();
            while (iterator.hasNext()) {
                FileSet fileSet = (FileSet)iterator.next();
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                String[] stringArray = directoryScanner.getIncludedFiles();
                File file = fileSet.getDir(this.getProject());
                String string = this.getParentPath(file, this.getLocation());
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(this.getAbsolutePath(stringArray[i], string));
                }
            }
            return arrayList.toArray(new String[0]);
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(this.poDirectory);
        directoryScanner.setIncludes(new String[]{"**/*.po"});
        directoryScanner.scan();
        return directoryScanner.getIncludedFiles();
    }

    protected void checkPreconditions() {
        if (this.outputDirectory == null) {
            throw new BuildException("outputDirectory must be specified: <... outputDirectory=\"po\"");
        }
    }

    protected CommandlineFactory getCommandlineFactory() {
        if ("class".equals(this.outputFormat)) {
            return new MsgFmtCommandlineFactory();
        }
        if ("properties".equals(this.outputFormat)) {
            return new MsgCatCommandlineFactory();
        }
        throw new BuildException("Unknown output format: " + this.outputFormat + ". Should be 'class' or 'properties'.");
    }

    protected class MsgCatCommandlineFactory
    extends CommandlineFactory {
        protected MsgCatCommandlineFactory() {
        }

        public Commandline createCommandline(File file, String string) {
            String string2 = AbstractGettextGenerateTask.this.targetBundle.replace('.', File.separatorChar);
            if (string != null) {
                string2 = string2 + "_" + GettextUtils.getJavaLocale(string);
            }
            File file2 = new File(AbstractGettextGenerateTask.this.outputDirectory, string2 + ".properties");
            Commandline commandline = new Commandline();
            commandline.setExecutable(AbstractGettextGenerateTask.this.msgcatCmd);
            commandline.createArgument().setValue("--no-location");
            commandline.createArgument().setValue("-p");
            commandline.createArgument().setFile(file);
            commandline.createArgument().setValue("-o");
            commandline.createArgument().setFile(file2);
            return commandline;
        }
    }

    protected class MsgFmtCommandlineFactory
    extends CommandlineFactory {
        protected MsgFmtCommandlineFactory() {
        }

        public Commandline createCommandline(File file, String string) {
            Commandline commandline = new Commandline();
            commandline.setExecutable(AbstractGettextGenerateTask.this.msgfmtCmd);
            if ("2".equals(AbstractGettextGenerateTask.this.javaVersion)) {
                commandline.createArgument().setValue("--java2");
            } else {
                commandline.createArgument().setValue("--java");
            }
            commandline.createArgument().setValue("-d");
            commandline.createArgument().setValue(AbstractGettextGenerateTask.this.outputDirectory);
            commandline.createArgument().setValue("-r");
            commandline.createArgument().setValue(AbstractGettextGenerateTask.this.targetBundle);
            if (string != null) {
                commandline.createArgument().setValue("-l");
                commandline.createArgument().setValue(GettextUtils.getJavaLocale(string));
            }
            commandline.createArgument().setFile(file);
            AbstractGettextGenerateTask.this.log(commandline.toString(), 1);
            return commandline;
        }
    }

    protected abstract class CommandlineFactory {
        protected CommandlineFactory() {
        }

        public abstract Commandline createCommandline(File var1, String var2);

        public Commandline createCommandline(File file) {
            String string = file.getName().substring(0, file.getName().lastIndexOf(46));
            return this.createCommandline(file, string);
        }
    }
}

