/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.iterablelayouts;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.uci.ics.jung.algorithms.shortestpath.UnweightedShortestPath;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import samples.preview_new_graphdraw.EmittedLayout;
import samples.preview_new_graphdraw.VisVertex;
import samples.preview_new_graphdraw.iter.IterableLayout;

public class KKLayout
extends IterableLayout {
    private double EPSILON = 0.1;
    private int currentIteration;
    private double L;
    private double K = 1.0;
    private DoubleMatrix2D dm;
    private Indexer id;
    private boolean adjustForGravity = true;
    private boolean exchangeVertices = true;
    protected UnweightedShortestPath unweightedShortestPaths;
    protected double diameter;
    protected static final String LAYOUT_INDEX_KEY = "Index for KKLayout";
    protected Set vertices;
    protected double energy = Double.MAX_VALUE;
    protected double energyDelta = Double.MAX_VALUE;
    public final double THRESHOLD;
    static int round = 0;

    public KKLayout() {
        this.THRESHOLD = 0.01;
    }

    public KKLayout(double thresh) {
        this.THRESHOLD = thresh;
    }

    public void initializeLocationsFromLayout(EmittedLayout sla) {
        super.initializeLocationsFromLayout(sla);
        this.vertices = sla.visVertexMap.keySet();
        int n = this.vertices.size();
        this.dm = new DenseDoubleMatrix2D(n, n);
        Graph theGraph = (Graph)((Vertex)this.vertices.iterator().next()).getGraph();
        this.unweightedShortestPaths = new UnweightedShortestPath(theGraph);
        this.id = Indexer.getAndUpdateIndexer(theGraph, LAYOUT_INDEX_KEY);
        this.diameter = this.getDiameter(n, this.id);
        int width = sla.getScreenSize().width;
        int height = sla.getScreenSize().height;
        double L0 = height > width ? (double)width : (double)height;
        this.L = L0 / this.diameter * 0.9;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double dist = this.getDistance((Vertex)this.id.getVertex(i), (Vertex)this.id.getVertex(j));
                this.dm.setQuick(i, j, dist);
                this.dm.setQuick(j, i, dist);
            }
        }
    }

    private double getDiameter(int n, Indexer id) {
        double diameter = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                Number dist = this.unweightedShortestPaths.getDistance((Vertex)id.getVertex(i), (Vertex)id.getVertex(j));
                if (dist == null || !(dist.doubleValue() > diameter)) continue;
                diameter = dist.doubleValue();
            }
        }
        return diameter;
    }

    protected double getDistance(Vertex v1, Vertex v2) {
        Number n = this.unweightedShortestPaths.getDistance(v1, v2);
        if (n == null) {
            return this.diameter + 1.0;
        }
        return n.doubleValue();
    }

    public void calculate() {
        ++this.currentIteration;
        ArrayList<VisVertex> orderedVisVertices = new ArrayList<VisVertex>(this.vertices.size());
        Iterator iter = this.vertices.iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            orderedVisVertices.add(this.getVisVertex(v));
        }
        double oldEnergy = this.energy;
        this.energy = this.calcEnergy(orderedVisVertices);
        this.energyDelta = Math.abs(oldEnergy - this.energy);
        int n = this.vertices.size();
        if (n == 0) {
            return;
        }
        double maxDeltaM = 0.0;
        Vertex pm = null;
        Iterator iter2 = this.vertices.iterator();
        while (iter2.hasNext()) {
            Vertex v = (Vertex)iter2.next();
            double deltam = this.calcDeltaM(v, this.vertices);
            if (!(maxDeltaM < deltam)) continue;
            maxDeltaM = deltam;
            pm = v;
        }
        if (pm == null) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            double[] dxy = this.calcDeltaXY(pm, this.vertices);
            VisVertex vv = this.getVisVertex(pm);
            vv.offset(dxy[0], dxy[1]);
            double deltam = this.calcDeltaM(pm, this.vertices);
            if (deltam < this.EPSILON) break;
        }
        if (this.adjustForGravity) {
            this.adjustForGravity(this.vertices);
        }
        if (this.exchangeVertices && maxDeltaM < this.EPSILON) {
            this.energy = this.calcEnergy(orderedVisVertices);
            for (int ix = 0; ix < orderedVisVertices.size() - 1; ++ix) {
                VisVertex vi = (VisVertex)orderedVisVertices.get(ix);
                ListIterator itj = orderedVisVertices.listIterator(ix + 1);
                while (itj.hasNext()) {
                    VisVertex vj = (VisVertex)itj.next();
                    double xenergy = this.calcEnergyIfExchanged(vi, vj, orderedVisVertices);
                    if (!(this.energy > xenergy)) continue;
                    double sx = vi.getX();
                    double sy = vi.getY();
                    vi.setX(vj.getX());
                    vi.setY(vj.getY());
                    vj.setX(sx);
                    vj.setY(sy);
                    return;
                }
            }
        }
    }

    public void adjustForGravity(Set vertices) {
        int width = this.getScreenSize().width;
        int height = this.getScreenSize().height;
        double gx = 0.0;
        double gy = 0.0;
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            Vertex i = (Vertex)iter.next();
            VisVertex vv = this.getVisVertex(i);
            gx += vv.getX();
            gy += vv.getY();
        }
        double diffx = (double)(width / 2) - (gx /= (double)vertices.size());
        double diffy = (double)(height / 2) - (gy /= (double)vertices.size());
        Iterator iter2 = vertices.iterator();
        while (iter2.hasNext()) {
            Vertex i = (Vertex)iter2.next();
            VisVertex vv = this.getVisVertex(i);
            vv.offset(diffx, diffy);
        }
    }

    public void setAdjustForGravity(boolean on) {
        this.adjustForGravity = on;
    }

    public boolean getAdjustForGravity() {
        return this.adjustForGravity;
    }

    public void setExchangeVertices(boolean on) {
        this.exchangeVertices = on;
    }

    public boolean getExchangeVertices() {
        return this.exchangeVertices;
    }

    private double[] calcDeltaXY(Vertex m, Set vertices) {
        double dE_dxm = 0.0;
        double dE_dym = 0.0;
        double d2E_d2xm = 0.0;
        double d2E_dxmdym = 0.0;
        double d2E_dymdxm = 0.0;
        double d2E_d2ym = 0.0;
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            Vertex i = (Vertex)iter.next();
            if (i == m) continue;
            double dist = this.getBFSDistance(m, i);
            double l_mi = this.L * dist;
            double k_mi = this.K / (dist * dist);
            VisVertex vm = this.getVisVertex(m);
            VisVertex vi = this.getVisVertex(i);
            double dx = vm.getX() - vi.getX();
            double dy = vm.getY() - vi.getY();
            double d = Math.sqrt(dx * dx + dy * dy);
            double ddd = d * d * d;
            dE_dxm += k_mi * (1.0 - l_mi / d) * dx;
            dE_dym += k_mi * (1.0 - l_mi / d) * dy;
            d2E_d2xm += k_mi * (1.0 - l_mi * dy * dy / ddd);
            d2E_dxmdym += k_mi * l_mi * dx * dy / ddd;
            d2E_d2ym += k_mi * (1.0 - l_mi * dx * dx / ddd);
        }
        d2E_dymdxm = d2E_dxmdym;
        double denomi = d2E_d2xm * d2E_d2ym - d2E_dxmdym * d2E_dymdxm;
        double deltaX = (d2E_dxmdym * dE_dym - d2E_d2ym * dE_dxm) / denomi;
        double deltaY = (d2E_dymdxm * dE_dxm - d2E_d2xm * dE_dym) / denomi;
        return new double[]{deltaX, deltaY};
    }

    private double calcDeltaM(Vertex m, Set vertices) {
        double dEdxm = 0.0;
        double dEdym = 0.0;
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            Vertex i = (Vertex)iter.next();
            if (i == m) continue;
            double dist = this.getBFSDistance(i, m);
            double l_mi = this.L * dist;
            double k_mi = this.K / (dist * dist);
            VisVertex vm = this.getVisVertex(m);
            VisVertex vi = this.getVisVertex(i);
            double dx = vm.getX() - vi.getX();
            double dy = vm.getY() - vi.getY();
            double d = Math.sqrt(dx * dx + dy * dy);
            double common = k_mi * (1.0 - l_mi / d);
            dEdxm += common * dx;
            dEdym += common * dy;
        }
        return Math.sqrt(dEdxm * dEdxm + dEdym * dEdym);
    }

    private double calcEnergy(List visVertices) {
        double energy = 0.0;
        for (int i = 0; i < visVertices.size() - 1; ++i) {
            for (int j = i + 1; j < visVertices.size(); ++j) {
                VisVertex vi = (VisVertex)visVertices.get(i);
                VisVertex vj = (VisVertex)visVertices.get(j);
                double dist = this.getBFSDistance(vi.getVertex(), vj.getVertex());
                double l_ij = this.L * dist;
                double k_ij = this.K / (dist * dist);
                double dx = vi.getX() - vj.getX();
                double dy = vi.getY() - vj.getY();
                double d = Math.sqrt(dx * dx + dy * dy);
                energy += k_ij / 2.0 * (dx * dx + dy * dy + l_ij * l_ij - 2.0 * l_ij * d);
            }
        }
        return energy;
    }

    private double getBFSDistance(Vertex u, Vertex v) {
        int i = this.id.getIndex(u);
        int j = this.id.getIndex(v);
        return this.dm.getQuick(i, j);
    }

    private double calcEnergyIfExchanged(VisVertex p, VisVertex q, List orderedVertices) {
        VisVertex pButQ = new VisVertex(p.getVertex(), q.getX(), q.getY());
        VisVertex qButP = new VisVertex(q.getVertex(), p.getX(), p.getY());
        ArrayList<VisVertex> l = new ArrayList<VisVertex>(orderedVertices);
        int x = l.indexOf(p);
        l.remove(p);
        l.add(x, pButQ);
        x = l.indexOf(q);
        l.remove(p);
        l.add(x, qButP);
        return this.calcEnergy(l);
    }

    public boolean iterationsAreDone() {
        return this.energyDelta < this.THRESHOLD;
    }

    public boolean isFinite() {
        return true;
    }
}

