/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.impl;

import edu.uci.ics.jung.graph.Graph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import samples.preview_new_graphdraw.EdgeRenderer;
import samples.preview_new_graphdraw.EmittedLayout;
import samples.preview_new_graphdraw.VertexRenderer;
import samples.preview_new_graphdraw.VisEdge;
import samples.preview_new_graphdraw.VisVertex;
import samples.preview_new_graphdraw.event.ClickListener;
import samples.preview_new_graphdraw.impl.GraphLayoutPanelMouseListener;
import samples.preview_new_graphdraw.iter.GraphLayoutPanelUtils;
import samples.preview_new_graphdraw.iter.TransformerPipeline;

public class GraphLayoutPanel
extends JPanel {
    public static final GraphLayoutPanelMouseListener.ClickPolicy NO_EVENT_POLICY = new GraphLayoutPanelMouseListener.NoEventPolicy();
    public static final GraphLayoutPanelMouseListener.ClickPolicy VERTEX_ONLY_POLICY = new GraphLayoutPanelMouseListener.VertexEventPolicy();
    public static final GraphLayoutPanelMouseListener.ClickPolicy EDGE_ONLY_POLICY = new GraphLayoutPanelMouseListener.VertexEventPolicy();
    public static final GraphLayoutPanelMouseListener.ClickPolicy EDGE_AND_VERTEX_POLICY = new GraphLayoutPanelMouseListener.EdgeAndVertexPolicy();
    public static final GraphLayoutPanelMouseListener.ClickPolicy EDGE_AND_VERTEX_BOTH = new GraphLayoutPanelMouseListener.BothEdgeAndVertexPolicy();
    protected GraphLayoutPanelMouseListener.ClickPolicy clickPolicy = VERTEX_ONLY_POLICY;
    protected VertexRenderer mVertexRenderer;
    protected EdgeRenderer mEdgeRenderer;
    protected volatile EmittedLayout mLayout;
    protected TransformerPipeline pipeline;
    List listeners = null;
    protected EmittedLayout cleanOriginal;
    static int i = 0;

    public GraphLayoutPanel(Graph g, Dimension d, VertexRenderer vr, EdgeRenderer er) {
        this.addMouseListener(this.getDefaultMouseListener());
        this.setPreferredSize(d);
        this.setSize(d);
        this.mVertexRenderer = vr;
        this.mEdgeRenderer = er;
        this.pipeline = new TransformerPipeline(this);
        this.setBackground(Color.white);
    }

    protected MouseListener getDefaultMouseListener() {
        return new GraphLayoutPanelMouseListener(this);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.mLayout == null) {
            return;
        }
        EmittedLayout localLayout = this.mLayout;
        Iterator iter = localLayout.visEdgeMap.values().iterator();
        while (iter.hasNext()) {
            VisEdge eee = (VisEdge)iter.next();
            this.mEdgeRenderer.renderEdge(graphics, eee);
        }
        iter = localLayout.visVertexMap.values().iterator();
        while (iter.hasNext()) {
            VisVertex vvv = (VisVertex)iter.next();
            this.mVertexRenderer.renderVertex(graphics, vvv);
        }
    }

    public void addClickListener(ClickListener cl) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        this.listeners.add(cl);
    }

    public void setClickPolicy(GraphLayoutPanelMouseListener.ClickPolicy policy) {
        this.clickPolicy = policy;
    }

    public EmittedLayout getGraphLayout() {
        return this.mLayout;
    }

    public void setLayoutDisplay(EmittedLayout lr2) {
        this.cleanOriginal = lr2;
        this.resizeLayouts();
    }

    public TransformerPipeline getPipeline() {
        return this.pipeline;
    }

    public void resizeLayouts() {
        EmittedLayout tempLayout = GraphLayoutPanelUtils.copy(this.cleanOriginal);
        this.pipeline.transformSequentially(tempLayout);
        this.mLayout = tempLayout;
        this.repaint();
    }

    public void updateGraphToMatch(Graph g) {
    }
}

