/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberEdgeValue;
import edu.uci.ics.jung.utils.TestGraphs;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;

public class ShowLayouts
extends JApplet {
    protected static Graph[] g_array;
    protected static int graph_index;
    protected static String[] graph_names;
    static /* synthetic */ Class class$edu$uci$ics$jung$graph$Graph;
    static /* synthetic */ Class class$edu$uci$ics$jung$visualization$FRLayout;
    static /* synthetic */ Class class$edu$uci$ics$jung$visualization$contrib$KKLayout;
    static /* synthetic */ Class class$edu$uci$ics$jung$visualization$contrib$CircleLayout;
    static /* synthetic */ Class class$edu$uci$ics$jung$visualization$SpringLayout;
    static /* synthetic */ Class class$edu$uci$ics$jung$visualization$ISOMLayout;

    private static JPanel getGraphPanel() {
        g_array = new Graph[graph_names.length];
        ShowLayouts.g_array[0] = TestGraphs.createTestGraph(false);
        ShowLayouts.g_array[1] = TestGraphs.generateMixedRandomGraph(new UserDatumNumberEdgeValue("weight"), 20, true);
        ShowLayouts.g_array[2] = TestGraphs.getDemoGraph();
        ShowLayouts.g_array[3] = TestGraphs.createDirectedAcyclicGraph(4, 4, 0.3);
        ShowLayouts.g_array[4] = TestGraphs.getOneComponentGraph();
        ShowLayouts.g_array[5] = TestGraphs.createChainPlusIsolates(18, 5);
        ShowLayouts.g_array[6] = TestGraphs.createChainPlusIsolates(0, 20);
        Graph g = g_array[4];
        final VisualizationViewer vv = new VisualizationViewer(new FRLayout(g), (Renderer)new PluggableRenderer());
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        vv.setGraphMouse(graphMouse);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(vv, 1.1f, vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(vv, 0.9090909f, vv.getCenter());
            }
        });
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(((DefaultModalGraphMouse)vv.getGraphMouse()).getModeListener());
        vv.setPickSupport(new ShapePickSupport());
        JPanel jp = new JPanel();
        jp.setBackground(Color.WHITE);
        jp.setLayout(new BorderLayout());
        jp.add((Component)vv, "Center");
        Class[] combos = ShowLayouts.getCombos();
        JComboBox<Class> jcb = new JComboBox<Class>(combos);
        jcb.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String valueString = value.toString();
                valueString = valueString.substring(valueString.lastIndexOf(46) + 1);
                return super.getListCellRendererComponent((JList<?>)list, valueString, index, isSelected, cellHasFocus);
            }
        });
        jcb.addActionListener(new LayoutChooser(jcb, vv));
        jcb.setSelectedItem(class$edu$uci$ics$jung$visualization$FRLayout == null ? (class$edu$uci$ics$jung$visualization$FRLayout = ShowLayouts.class$("edu.uci.ics.jung.visualization.FRLayout")) : class$edu$uci$ics$jung$visualization$FRLayout);
        JPanel control_panel = new JPanel(new GridLayout(2, 1));
        JPanel topControls = new JPanel();
        JPanel bottomControls = new JPanel();
        control_panel.add(topControls);
        control_panel.add(bottomControls);
        jp.add((Component)control_panel, "North");
        JComboBox<String> graph_chooser = new JComboBox<String>(graph_names);
        graph_chooser.addActionListener(new GraphChooser(jcb));
        topControls.add(jcb);
        topControls.add(graph_chooser);
        bottomControls.add(plus);
        bottomControls.add(minus);
        bottomControls.add(modeBox);
        return jp;
    }

    public void start() {
        this.getContentPane().add(ShowLayouts.getGraphPanel());
    }

    private static Class[] getCombos() {
        ArrayList<Class> layouts = new ArrayList<Class>();
        layouts.add(class$edu$uci$ics$jung$visualization$contrib$KKLayout == null ? (class$edu$uci$ics$jung$visualization$contrib$KKLayout = ShowLayouts.class$("edu.uci.ics.jung.visualization.contrib.KKLayout")) : class$edu$uci$ics$jung$visualization$contrib$KKLayout);
        layouts.add(class$edu$uci$ics$jung$visualization$FRLayout == null ? (class$edu$uci$ics$jung$visualization$FRLayout = ShowLayouts.class$("edu.uci.ics.jung.visualization.FRLayout")) : class$edu$uci$ics$jung$visualization$FRLayout);
        layouts.add(class$edu$uci$ics$jung$visualization$contrib$CircleLayout == null ? (class$edu$uci$ics$jung$visualization$contrib$CircleLayout = ShowLayouts.class$("edu.uci.ics.jung.visualization.contrib.CircleLayout")) : class$edu$uci$ics$jung$visualization$contrib$CircleLayout);
        layouts.add(class$edu$uci$ics$jung$visualization$SpringLayout == null ? (class$edu$uci$ics$jung$visualization$SpringLayout = ShowLayouts.class$("edu.uci.ics.jung.visualization.SpringLayout")) : class$edu$uci$ics$jung$visualization$SpringLayout);
        layouts.add(class$edu$uci$ics$jung$visualization$ISOMLayout == null ? (class$edu$uci$ics$jung$visualization$ISOMLayout = ShowLayouts.class$("edu.uci.ics.jung.visualization.ISOMLayout")) : class$edu$uci$ics$jung$visualization$ISOMLayout);
        return layouts.toArray(new Class[0]);
    }

    public static void main(String[] args) {
        JPanel jp = ShowLayouts.getGraphPanel();
        JFrame jf = new JFrame();
        jf.getContentPane().add(jp);
        jf.setDefaultCloseOperation(3);
        jf.pack();
        jf.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        graph_names = new String[]{"Two component graph", "Random mixed-mode graph", "Miscellaneous multicomponent graph", "Random directed acyclic graph", "One component graph", "Chain+isolate graph", "Trivial (disconnected) graph"};
    }

    private static final class LayoutChooser
    implements ActionListener {
        private final JComboBox jcb;
        private final VisualizationViewer vv;

        private LayoutChooser(JComboBox jcb, VisualizationViewer vv) {
            this.jcb = jcb;
            this.vv = vv;
        }

        public void actionPerformed(ActionEvent arg0) {
            Class layoutC;
            Object[] constructorArgs = new Object[]{g_array[graph_index]};
            Class lay = layoutC = (Class)this.jcb.getSelectedItem();
            try {
                Constructor constructor = lay.getConstructor(class$edu$uci$ics$jung$graph$Graph == null ? (class$edu$uci$ics$jung$graph$Graph = ShowLayouts.class$("edu.uci.ics.jung.graph.Graph")) : class$edu$uci$ics$jung$graph$Graph);
                Object o = constructor.newInstance(constructorArgs);
                Layout l = (Layout)o;
                this.vv.stop();
                this.vv.setGraphLayout(l, false);
                this.vv.restart();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class GraphChooser
    implements ActionListener {
        private JComboBox layout_combo;

        public GraphChooser(JComboBox layout_combo) {
            this.layout_combo = layout_combo;
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            graph_index = cb.getSelectedIndex();
            this.layout_combo.setSelectedIndex(this.layout_combo.getSelectedIndex());
        }
    }
}

