/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.visualization.HasGraphLayout;
import edu.uci.ics.jung.visualization.HasShapeFunctions;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.transform.LayoutTransformer;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class ShapePickSupport
implements PickSupport {
    protected HasGraphLayout hasGraphLayout;
    protected HasShapeFunctions hasShapeFunctions;
    protected float pickSize;
    protected LayoutTransformer layoutTransformer;

    public ShapePickSupport(HasGraphLayout hasGraphLayout, LayoutTransformer layoutTransformer, HasShapeFunctions hasShapeFunctions, float pickSize) {
        this.hasGraphLayout = hasGraphLayout;
        this.hasShapeFunctions = hasShapeFunctions;
        this.layoutTransformer = layoutTransformer;
        this.pickSize = pickSize;
    }

    public ShapePickSupport(float pickSize) {
        this.pickSize = pickSize;
    }

    public ShapePickSupport() {
        this(2.0f);
    }

    public void setHasGraphLayout(HasGraphLayout hasGraphLayout) {
        this.hasGraphLayout = hasGraphLayout;
    }

    public void setHasShapes(HasShapeFunctions hasShapes) {
        this.hasShapeFunctions = hasShapes;
    }

    public LayoutTransformer getLayoutTransformer() {
        return this.layoutTransformer;
    }

    public void setLayoutTransformer(LayoutTransformer layoutTransformer) {
        this.layoutTransformer = layoutTransformer;
    }

    public Vertex getVertex(double x, double y) {
        Layout layout = this.hasGraphLayout.getGraphLayout();
        Vertex closest = null;
        double minDistance = Double.MAX_VALUE;
        while (true) {
            try {
                Iterator iter = layout.getGraph().getVertices().iterator();
                while (iter.hasNext()) {
                    double dy;
                    Rectangle2D bounds;
                    double dx;
                    double dist;
                    AffineTransform xform;
                    if (this.hasShapeFunctions == null) continue;
                    Vertex v = (Vertex)iter.next();
                    Shape shape = this.hasShapeFunctions.getVertexShapeFunction().getShape(v);
                    Point2D p = this.layoutTransformer.layoutTransform(layout.getLocation(v));
                    if (p == null || !(shape = (xform = AffineTransform.getTranslateInstance(p.getX(), p.getY())).createTransformedShape(shape)).contains(x, y) || !((dist = (dx = (bounds = shape.getBounds2D()).getCenterX() - x) * dx + (dy = bounds.getCenterY() - y) * dy) < minDistance)) continue;
                    minDistance = dist;
                    closest = v;
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        return closest;
    }

    public Edge getEdge(double x, double y) {
        Layout layout = this.hasGraphLayout.getGraphLayout();
        Rectangle2D.Float pickArea = new Rectangle2D.Float((float)x - this.pickSize / 2.0f, (float)y - this.pickSize / 2.0f, this.pickSize, this.pickSize);
        Edge closest = null;
        double minDistance = Double.MAX_VALUE;
        while (true) {
            try {
                Iterator iter = layout.getGraph().getEdges().iterator();
                while (iter.hasNext()) {
                    float dy;
                    float dx;
                    float dist;
                    if (this.hasShapeFunctions == null) continue;
                    Edge e = (Edge)iter.next();
                    Pair pair = e.getEndpoints();
                    Vertex v1 = (Vertex)pair.getFirst();
                    Vertex v2 = (Vertex)pair.getSecond();
                    boolean isLoop = v1.equals(v2);
                    Point2D p1 = this.layoutTransformer.layoutTransform(layout.getLocation(v1));
                    Point2D p2 = this.layoutTransformer.layoutTransform(layout.getLocation(v2));
                    if (p1 == null || p2 == null) continue;
                    float x1 = (float)p1.getX();
                    float y1 = (float)p1.getY();
                    float x2 = (float)p2.getX();
                    float y2 = (float)p2.getY();
                    AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
                    Shape edgeShape = this.hasShapeFunctions.getEdgeShapeFunction().getShape(e);
                    if (isLoop) {
                        Shape s2 = this.hasShapeFunctions.getVertexShapeFunction().getShape(v2);
                        Rectangle2D s2Bounds = s2.getBounds2D();
                        xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
                        xform.translate(0.0, -edgeShape.getBounds2D().getHeight() / 2.0);
                    } else {
                        float dx2 = x2 - x1;
                        float dy2 = y2 - y1;
                        double theta = Math.atan2(dy2, dx2);
                        xform.rotate(theta);
                        float dist2 = (float)Math.sqrt(dx2 * dx2 + dy2 * dy2);
                        xform.scale(dist2, 1.0);
                    }
                    if (!(edgeShape = xform.createTransformedShape(edgeShape)).intersects(pickArea)) continue;
                    float cx = 0.0f;
                    float cy = 0.0f;
                    float[] f = new float[6];
                    PathIterator pi = ((GeneralPath)edgeShape).getPathIterator(null);
                    if (!pi.isDone()) {
                        pi.next();
                        pi.currentSegment(f);
                        cx = f[0];
                        cy = f[1];
                        if (!pi.isDone()) {
                            pi.currentSegment(f);
                            cx = f[0];
                            cy = f[1];
                        }
                    }
                    if (!((double)(dist = (dx = (float)((double)cx - x)) * dx + (dy = (float)((double)cy - y)) * dy) < minDistance)) continue;
                    minDistance = dist;
                    closest = e;
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        return closest;
    }

    public void setLayout(Layout layout) {
    }
}

