/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.HasGraphLayout;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.RadiusGraphElementAccessor;

public class RadiusPickSupport
extends RadiusGraphElementAccessor
implements PickSupport {
    protected HasGraphLayout hasGraphLayout;

    public RadiusPickSupport(HasGraphLayout hasGraphLayout, double maxDistance) {
        this(maxDistance);
        this.hasGraphLayout = hasGraphLayout;
    }

    public RadiusPickSupport() {
        this(Math.sqrt(Double.MAX_VALUE));
    }

    public RadiusPickSupport(double maxDistance) {
        super(null, maxDistance);
    }

    public void setHasGraphLayout(HasGraphLayout hasGraphLayout) {
        this.hasGraphLayout = hasGraphLayout;
    }

    public Vertex getVertex(double x, double y) {
        return this.getVertex(x, y, this.maxDistance);
    }

    public Vertex getVertex(double x, double y, double maxDistance) {
        if (this.hasGraphLayout != null) {
            this.layout = this.hasGraphLayout.getGraphLayout();
        }
        return super.getVertex(x, y, maxDistance);
    }

    public Edge getEdge(double x, double y) {
        return this.getEdge(x, y, this.maxDistance);
    }

    public Edge getEdge(double x, double y, double maxDistance) {
        if (this.hasGraphLayout != null) {
            this.layout = this.hasGraphLayout.getGraphLayout();
        }
        return super.getEdge(x, y, maxDistance);
    }
}

