/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.ChangeEventSupport;
import edu.uci.ics.jung.utils.DefaultChangeEventSupport;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.Coordinates;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.RandomVertexLocationDecorator;
import edu.uci.ics.jung.visualization.VertexLocationFunction;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeListener;

public abstract class AbstractLayout
implements Layout,
ChangeEventSupport {
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);
    private Set dontmove;
    private static final Object BASE_KEY = "edu.uci.ics.jung.Base_Visualization_Key";
    private Dimension currentSize;
    private Graph baseGraph;
    private Graph visibleGraph;
    protected VertexLocationFunction vertex_locations;
    private Object key;
    private Set visibleVertices;
    private Set visibleEdges;

    public AbstractLayout(Graph g) {
        this.baseGraph = g;
        this.visibleGraph = g;
        this.visibleEdges = g.getEdges();
        this.visibleVertices = g.getVertices();
        this.dontmove = new HashSet();
    }

    public boolean dontMove(Vertex v) {
        return this.isLocked(v);
    }

    public boolean isLocked(Vertex v) {
        return this.dontmove.contains(v);
    }

    public Iterator getVertexIterator() {
        return this.getVisibleVertices().iterator();
    }

    public void initialize(Dimension size) {
        this.initialize(size, new RandomVertexLocationDecorator(size));
    }

    public void initialize(Dimension size, VertexLocationFunction v_locations) {
        this.currentSize = size;
        this.vertex_locations = v_locations;
        this.initialize_local();
        this.initializeLocations();
    }

    protected void initialize_local() {
    }

    protected void postInitialize() {
    }

    protected abstract void initialize_local_vertex(Vertex var1);

    public Object getBaseKey() {
        if (this.key == null) {
            this.key = new Pair(this, BASE_KEY);
        }
        return this.key;
    }

    protected void initializeLocations() {
        try {
            Iterator iter = this.baseGraph.getVertices().iterator();
            while (iter.hasNext()) {
                Vertex v = (Vertex)iter.next();
                Coordinates coord = (Coordinates)v.getUserDatum(this.getBaseKey());
                if (coord == null) {
                    coord = new Coordinates();
                    v.addUserDatum(this.getBaseKey(), coord, UserData.REMOVE);
                }
                if (!this.dontmove.contains(v)) {
                    this.initializeLocation(v, coord, this.currentSize);
                }
                this.initialize_local_vertex(v);
            }
        }
        catch (ConcurrentModificationException cme) {
            this.initializeLocations();
        }
    }

    protected void initializeLocation(Vertex v, Coordinates coord, Dimension d) {
        coord.setLocation(this.vertex_locations.getLocation(v));
    }

    public String getStatus() {
        return null;
    }

    public abstract void advancePositions();

    protected Graph getVisibleGraph() {
        return this.visibleGraph;
    }

    public Dimension getCurrentSize() {
        return this.currentSize;
    }

    protected Vertex getAVertex(Edge e) {
        Vertex v = (Vertex)e.getIncidentVertices().iterator().next();
        return v;
    }

    public Coordinates getCoordinates(ArchetypeVertex v) {
        return (Coordinates)v.getUserDatum(this.getBaseKey());
    }

    public double getX(Vertex v) {
        Coordinates coords = (Coordinates)v.getUserDatum(this.getBaseKey());
        return coords.getX();
    }

    public double getY(Vertex v) {
        Coordinates coords = (Coordinates)v.getUserDatum(this.getBaseKey());
        return coords.getY();
    }

    public Point2D getLocation(ArchetypeVertex v) {
        return this.getCoordinates(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(Dimension size) {
        Dimension oldSize;
        if (this.currentSize == null) {
            this.currentSize = size;
            return;
        }
        Dimension dimension = this.currentSize;
        synchronized (dimension) {
            if (this.currentSize.equals(size)) {
                return;
            }
            oldSize = this.currentSize;
            this.currentSize = size;
        }
        int xOffset = (size.width - oldSize.width) / 2;
        int yOffset = (size.height - oldSize.height) / 2;
        while (true) {
            try {
                Iterator iter = this.getGraph().getVertices().iterator();
                while (iter.hasNext()) {
                    Vertex e = (Vertex)iter.next();
                    this.offsetVertex(e, xOffset, yOffset);
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
    }

    protected void offsetVertex(Vertex v, double xOffset, double yOffset) {
        Coordinates c = this.getCoordinates(v);
        c.add(xOffset, yOffset);
        this.forceMove(v, c.getX(), c.getY());
    }

    public void restart() {
        this.initialize_local();
        this.initializeLocations();
    }

    public Vertex getVertex(double x, double y) {
        return this.getVertex(x, y, Math.sqrt(Double.MAX_VALUE));
    }

    public Vertex getVertex(double x, double y, double maxDistance) {
        double minDistance = maxDistance * maxDistance;
        Vertex closest = null;
        while (true) {
            try {
                Iterator iter = this.getVisibleVertices().iterator();
                while (iter.hasNext()) {
                    double dy;
                    Vertex v = (Vertex)iter.next();
                    Point2D p = this.getLocation(v);
                    double dx = p.getX() - x;
                    double dist = dx * dx + (dy = p.getY() - y) * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = v;
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        return closest;
    }

    public Edge getEdge(double x, double y) {
        return this.getEdge(x, y, Math.sqrt(Double.MAX_VALUE));
    }

    public Edge getEdge(double x, double y, double maxDistance) {
        double minDistance = maxDistance * maxDistance;
        Edge closest = null;
        while (true) {
            try {
                Iterator iter = this.getVisibleEdges().iterator();
                while (iter.hasNext()) {
                    double distance2;
                    Edge e = (Edge)iter.next();
                    if (e.numVertices() != 2) continue;
                    Set vertices = e.getIncidentVertices();
                    Iterator vertexIterator = vertices.iterator();
                    Vertex v1 = (Vertex)vertexIterator.next();
                    Vertex v2 = (Vertex)vertexIterator.next();
                    Point2D p1 = this.getLocation(v1);
                    Point2D p2 = this.getLocation(v2);
                    double x1 = p1.getX();
                    double y1 = p1.getY();
                    double x2 = p2.getX();
                    double y2 = p2.getY();
                    if (x1 == x2 && y1 == y2) continue;
                    double b = ((y - y1) * (y2 - y1) + (x - x1) * (x2 - x1)) / ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                    if (b <= 0.0) {
                        distance2 = (x - x1) * (x - x1) + (y - y1) * (y - y1);
                    } else if (b >= 1.0) {
                        distance2 = (x - x2) * (x - x2) + (y - y2) * (y - y2);
                    } else {
                        double x3 = x1 + b * (x2 - x1);
                        double y3 = y1 + b * (y2 - y1);
                        distance2 = (x - x3) * (x - x3) + (y - y3) * (y - y3);
                    }
                    if (!(distance2 < minDistance)) continue;
                    minDistance = distance2;
                    closest = e;
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        return closest;
    }

    public Graph getGraph() {
        return this.baseGraph;
    }

    public Set getVisibleEdges() {
        return this.visibleEdges;
    }

    public Set getVisibleVertices() {
        return this.visibleVertices;
    }

    public void forceMove(Vertex picked, double x, double y) {
        Coordinates coord = this.getCoordinates(picked);
        coord.setX(x);
        coord.setY(y);
        this.fireStateChanged();
    }

    public void lockVertex(Vertex v) {
        this.dontmove.add(v);
    }

    public void unlockVertex(Vertex v) {
        this.dontmove.remove(v);
    }

    public void applyFilter(Graph g) {
        this.visibleGraph = g;
        this.visibleVertices = GraphUtils.getEqualVertices(g.getVertices(), this.baseGraph);
        this.visibleEdges = GraphUtils.getEqualEdges(g.getEdges(), this.baseGraph);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }
}

