/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.utils;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import edu.uci.ics.jung.graph.event.GraphEventType;
import edu.uci.ics.jung.utils.UserData;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Predicate;

public class SubsetManager
implements GraphEventListener {
    protected Map vertexMap;
    protected Map edgeMap;
    protected ArchetypeGraph g;

    protected SubsetManager(ArchetypeGraph g) {
        g.addUserDatum("edu.ics.uci.jung.graph.ArchetypeGraph:SubsetManager", this, UserData.REMOVE);
        g.addListener(this, GraphEventType.ALL_SINGLE_EVENTS);
        this.g = g;
    }

    public static SubsetManager getInstance(ArchetypeGraph g) {
        SubsetManager sm = (SubsetManager)g.getUserDatum("edu.ics.uci.jung.graph.ArchetypeGraph:SubsetManager");
        if (sm == null) {
            sm = new SubsetManager(g);
        }
        return sm;
    }

    public void vertexAdded(GraphEvent event) {
        ArchetypeVertex v = (ArchetypeVertex)event.getGraphElement();
        Map vMap = this.getVertexMap();
        Iterator iter = vMap.keySet().iterator();
        while (iter.hasNext()) {
            Predicate p = (Predicate)iter.next();
            if (!p.evaluate((Object)v)) continue;
            Set s = (Set)vMap.get(p);
            s.add(v);
        }
    }

    public void vertexRemoved(GraphEvent event) {
        ArchetypeVertex v = (ArchetypeVertex)event.getGraphElement();
        Map vMap = this.getVertexMap();
        Iterator iter = vMap.keySet().iterator();
        while (iter.hasNext()) {
            Set s = (Set)vMap.get(iter.next());
            s.remove(v);
        }
    }

    public void edgeAdded(GraphEvent event) {
        ArchetypeEdge e = (ArchetypeEdge)event.getGraphElement();
        Map eMap = this.getEdgeMap();
        Iterator iter = eMap.keySet().iterator();
        while (iter.hasNext()) {
            Predicate p = (Predicate)iter.next();
            if (!p.evaluate((Object)e)) continue;
            Set s = (Set)eMap.get(p);
            s.add(e);
        }
    }

    public void edgeRemoved(GraphEvent event) {
        ArchetypeEdge e = (ArchetypeEdge)event.getGraphElement();
        Map eMap = this.getEdgeMap();
        Iterator iter = eMap.keySet().iterator();
        while (iter.hasNext()) {
            Set s = (Set)eMap.get(iter.next());
            s.remove(e);
        }
    }

    public Set getVertices(Predicate p) {
        Set s = (Set)this.getVertexMap().get(p);
        if (s != null) {
            return Collections.unmodifiableSet(s);
        }
        return null;
    }

    public Set getEdges(Predicate p) {
        Set s = (Set)this.getEdgeMap().get(p);
        if (s != null) {
            return Collections.unmodifiableSet(s);
        }
        return null;
    }

    public boolean addVertexSubset(Predicate p) {
        Map vMap = this.getVertexMap();
        if (!vMap.containsKey(p)) {
            HashSet<ArchetypeVertex> subset = new HashSet<ArchetypeVertex>();
            vMap.put(p, subset);
            Iterator v_iter = this.g.getVertices().iterator();
            while (v_iter.hasNext()) {
                ArchetypeVertex v = (ArchetypeVertex)v_iter.next();
                if (!p.evaluate((Object)v)) continue;
                subset.add(v);
            }
            return true;
        }
        return false;
    }

    public boolean addEdgeSubset(Predicate p) {
        Map eMap = this.getEdgeMap();
        if (!eMap.containsKey(p)) {
            HashSet<ArchetypeVertex> subset = new HashSet<ArchetypeVertex>();
            eMap.put(p, subset);
            Iterator e_iter = this.g.getEdges().iterator();
            while (e_iter.hasNext()) {
                ArchetypeVertex e = (ArchetypeVertex)e_iter.next();
                if (!p.evaluate((Object)e)) continue;
                subset.add(e);
            }
            return true;
        }
        return false;
    }

    public void removeVertexSubset(Predicate p) {
        this.getVertexMap().remove(p);
    }

    public void removeEdgeSubset(Predicate p) {
        this.getVertexMap().remove(p);
    }

    protected Map getVertexMap() {
        if (this.vertexMap == null) {
            this.vertexMap = new HashMap();
        }
        return this.vertexMap;
    }

    protected Map getEdgeMap() {
        if (this.edgeMap == null) {
            this.edgeMap = new HashMap();
        }
        return this.edgeMap;
    }
}

