/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.random.generators;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.random.generators.GraphGenerator;
import edu.uci.ics.jung.utils.GraphUtils;
import java.util.Random;

public class ErdosRenyiGenerator
implements GraphGenerator {
    private int mNumVertices;
    private double mEdgeConnectionProbability;
    private Random mRandom;

    public ErdosRenyiGenerator(int numVertices, double p) {
        if (numVertices <= 0) {
            throw new IllegalArgumentException("A positive # of vertices must be specified.");
        }
        this.mNumVertices = numVertices;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p must be between 0 and 1.");
        }
        this.mEdgeConnectionProbability = p;
        this.mRandom = new Random();
    }

    public ArchetypeGraph generateGraph() {
        UndirectedSparseGraph g = new UndirectedSparseGraph();
        GraphUtils.addVertices((Graph)g, this.mNumVertices);
        Object[] v_array = g.getVertices().toArray();
        for (int i = 0; i < this.mNumVertices - 1; ++i) {
            Vertex v_i = (Vertex)v_array[i];
            for (int j = i + 1; j < this.mNumVertices; ++j) {
                Vertex v_j = (Vertex)v_array[j];
                if (!(this.mRandom.nextDouble() < this.mEdgeConnectionProbability)) continue;
                g.addEdge(new UndirectedSparseEdge(v_i, v_j));
            }
        }
        return g;
    }

    public void setSeed(long seed) {
        this.mRandom.setSeed(seed);
    }
}

