/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.random.generators;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.AbstractSparseEdge;
import edu.uci.ics.jung.graph.impl.AbstractSparseVertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseVertex;
import edu.uci.ics.jung.random.generators.EvolvingGraphGenerator;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

public class BarabasiAlbertGenerator
implements EvolvingGraphGenerator {
    private Graph mGraph = null;
    private int mNumEdgesToAttachPerStep;
    private int mElapsedTimeSteps;
    private Random mRandom;
    protected Vector vertex_index;
    protected int init_vertices;
    protected Map index_vertex;
    protected boolean directed;
    protected boolean parallel;
    public static final Object SEED = "edu.uci.ics.jung.random.generators.BarabasiAlbertGenerator.SEED";

    public BarabasiAlbertGenerator(int init_vertices, int numEdgesToAttach, boolean directed, boolean parallel, int seed) {
        if (init_vertices <= 0) {
            throw new IllegalArgumentException("Number of initial unconnected 'seed' vertices must be positive");
        }
        if (numEdgesToAttach <= 0) {
            throw new IllegalArgumentException("Number of edges to attach at each time step must be positive");
        }
        if (!parallel && init_vertices < numEdgesToAttach) {
            throw new IllegalArgumentException("If parallel edges disallowed, initialnumber of vertices must be >= number of edges to attach at each time step");
        }
        this.mNumEdgesToAttachPerStep = numEdgesToAttach;
        this.mRandom = new Random(seed);
        this.init_vertices = init_vertices;
        this.directed = directed;
        this.parallel = parallel;
        this.initialize();
    }

    public BarabasiAlbertGenerator(int init_vertices, int numEdgesToAttach, int seed) {
        this(init_vertices, numEdgesToAttach, false, false, seed);
    }

    public BarabasiAlbertGenerator(int init_vertices, int numEdgesToAttach) {
        this(init_vertices, numEdgesToAttach, (int)System.currentTimeMillis());
    }

    private void initialize() {
        this.mGraph = this.directed ? new DirectedSparseGraph() : new UndirectedSparseGraph();
        if (this.parallel) {
            this.mGraph.getEdgeConstraints().remove(Graph.NOT_PARALLEL_EDGE);
        }
        this.vertex_index = new Vector(2 * this.init_vertices);
        this.index_vertex = new HashMap(2 * this.init_vertices);
        for (int i = 0; i < this.init_vertices; ++i) {
            UndirectedSparseVertex v = new UndirectedSparseVertex();
            this.mGraph.addVertex(v);
            this.vertex_index.add(v);
            this.index_vertex.put(v, new Integer(i));
            v.addUserDatum(SEED, SEED, UserData.REMOVE);
        }
        this.mElapsedTimeSteps = 0;
    }

    private Edge createRandomEdge(Set preexistingNodes, Vertex newVertex, Set added_pairs) {
        AbstractSparseEdge to_add;
        Pair endpoints;
        Vertex attach_point;
        boolean created_edge = false;
        do {
            double degree;
            double attach_prob;
            attach_point = (Vertex)this.vertex_index.elementAt(this.mRandom.nextInt(this.vertex_index.size()));
            endpoints = new Pair(newVertex, attach_point);
            if (!this.parallel && added_pairs.contains(endpoints) || !((attach_prob = ((degree = this.directed ? (double)attach_point.inDegree() : (double)attach_point.degree()) + 1.0) / (double)(this.mGraph.numEdges() + this.mGraph.numVertices() - 1)) >= this.mRandom.nextDouble())) continue;
            created_edge = true;
        } while (!created_edge);
        if (this.directed) {
            to_add = new DirectedSparseEdge(newVertex, attach_point);
            added_pairs.add(endpoints);
        } else {
            to_add = new UndirectedSparseEdge(newVertex, attach_point);
            added_pairs.add(endpoints);
            added_pairs.add(new Pair(attach_point, newVertex));
        }
        return to_add;
    }

    public void evolveGraph(int numTimeSteps) {
        for (int i = 0; i < numTimeSteps; ++i) {
            this.evolveGraph();
            ++this.mElapsedTimeSteps;
        }
    }

    private void evolveGraph() {
        Set preexistingNodes = this.mGraph.getVertices();
        AbstractSparseVertex newVertex = this.directed ? new DirectedSparseVertex() : new UndirectedSparseVertex();
        this.mGraph.addVertex(newVertex);
        LinkedList<Edge> edges = new LinkedList<Edge>();
        HashSet added_pairs = new HashSet(this.mNumEdgesToAttachPerStep * 3);
        for (int i = 0; i < this.mNumEdgesToAttachPerStep; ++i) {
            edges.add(this.createRandomEdge(preexistingNodes, newVertex, added_pairs));
        }
        Iterator iter = edges.iterator();
        while (iter.hasNext()) {
            this.mGraph.addEdge((Edge)iter.next());
        }
        this.vertex_index.add(newVertex);
        this.index_vertex.put(newVertex, new Integer(this.vertex_index.size() - 1));
    }

    public int getIndex(Vertex v) {
        return (Integer)this.index_vertex.get(v);
    }

    public int getNumElapsedTimeSteps() {
        return this.mElapsedTimeSteps;
    }

    public ArchetypeGraph generateGraph() {
        return this.mGraph;
    }

    public void reset() {
        this.initialize();
    }
}

